<?php $__env->startSection('styles'); ?>

    <!--Select2 css -->
    <link href="<?php echo e(URL::asset('assets/plugins/select2/select2.min.css')); ?>" rel="stylesheet" />

    <!-- File Uploads css-->
    <link href="<?php echo e(URL::asset('assets/plugins/fileuploads/css/dropify.css')); ?>" rel="stylesheet" type="text/css" />

    <!--Mutipleselect css-->
    <link rel="stylesheet" href="<?php echo e(URL::asset('assets/plugins/multipleselect/multiple-select.css')); ?>">

    <!-- Tabs css-->
    <link href="<?php echo e(URL::asset('assets/plugins/tabs/tabs-style.css')); ?>" rel="stylesheet" />
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <!-- page-header -->
    <div class="page-header">
        <ol class="breadcrumb"><!-- breadcrumb -->
            <li class="breadcrumb-item"><a href="#">ฺBlog</a></li>
            <li class="breadcrumb-item active" aria-current="page">ฺBlog Category Form</li>
        </ol><!-- End breadcrumb -->
    </div>
    <!-- End page-header -->

    <!-- row -->
    <div class="row">
        <div class="col-md-12">
            <form id="blog_category_frm" name="blog_category_frm" method="POST" onsubmit="setSaveCategory(this); return false;" enctype="multipart/form-data" >
                <?php echo csrf_field(); ?>
                <input type="hidden" name="id" value="<?php echo e(!empty($category->id) ? $category->id :'0'); ?>">
                <div class="card">
                    <div class="card-header pb-0">
                        <h3 class="card-title">Blog Category Form</h3>
                    </div>
                    <div class="card-body">
                        <div class="panel panel-primary">
                            <div class="tab_wrapper first_tab">
                                <ul class="tab_list">
                                    <li class="icons-list-item"><i class="flag flag-th"></i> &nbsp; ภาษาไทย</li>
                                    <li class="icons-list-item"><i class="flag flag-gb"></i> &nbsp; ภาษาอังกฤษ</li>
                                </ul>

                                <div class="content_wrapper">
                                    <div class="tab_content active">
                                        <div class="row">
                                            <div class="col-md-12">
                                                
                                                <div class="form-group ">
                                                    <label class="form-label">หมวดหมู่</label>
                                                    <select name="parent_id" class="form-control select2-show-search" data-placeholder="Choose Parent">
                                                        <option value="0">-- กรุณาเลือกหมวดหมู่ --</option>
                                                        <?php $__currentLoopData = $parents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $parent): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <?php if( !empty($category->id) && $parent->id == $category->parent_id): ?>
                                                                <option value="<?php echo e($parent->id); ?>" selected="selected"><?php echo e($parent->name_th); ?></option>
                                                            <?php else: ?>
                                                                <option value="<?php echo e($parent->id); ?>" ><?php echo e($parent->name_th); ?></option>
                                                            <?php endif; ?>

                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </select>
                                                </div>

                                                <div class="form-group">
                                                    <label class="form-label">ชื่อหมวดหมู่</label>
                                                    <input id="name_th" type="text" class="form-control" name="name_th" value="<?php echo e(!empty($category->name_th) ? $category->name_th :''); ?>" placeholder="ชื่อหมวดหมู่">
                                                    <input id="param" type="hidden" class="form-control" name="param" value="" placeholder="param">
                                                </div>

                                                <div class="form-group">
                                                    <label class="form-label">คำอธิบาย</label>
                                                    <textarea id="blog_category_description_th" class="form-control texteditor" name="description_th" rows="4" placeholder="คำอธิบาย"><?php echo e(!empty($category->description_th) ? $category->description_th :''); ?></textarea>
                                                </div>

                                                <div class="form-group">
                                                    <label class="form-label">สถานะ</label>
                                                    <div class="form-check form-check-inline">
                                                        <?php if( empty($category->status) || ( !empty($category->status) && $category->status == 1 ) ): ?>
                                                            <input class="form-check-input" type="radio" name="status" id="status_enable" value="1" checked="checked">
                                                            <label class="form-check-label" for="status_enable">เปิด</label>&nbsp;
                                                            <input class="form-check-input" type="radio" name="status" id="status_disable" value="0">
                                                            <label class="form-check-label" for="status_disable">ปิด</label>
                                                        <?php else: ?>
                                                            <input class="form-check-input" type="radio" name="status" id="status_enable" value="1" >
                                                            <label class="form-check-label" for="status_enable">เปิด</label>&nbsp;
                                                            <input class="form-check-input" type="radio" name="status" id="status_disable" checked="checked" value="0">
                                                            <label class="form-check-label" for="status_disable">ปิด</label>
                                                        <?php endif; ?>

                                                    </div>
                                                    </label>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="card-footer text-right">
                                            <div class="form-group mb-1">
                                                <div class="btn-list">
                                                    <button type="submit" class="btn btn-primary"><i class="fa fa-save"></i> Save</button>
                                                    <button onclick="mwz_redirect('<?php echo e(route('admin.blog.category.index')); ?>');" type="button" class="btn btn-warning"><i class="fa fa-undo" aria-hidden="true"></i>Cancel</button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="tab_content">
                                        <div class="row">
                                            <div class="col-md-12">

                                                <div class="form-group">
                                                    <label class="form-label">Name</label>
                                                    <input id="name_en" type="text" class="form-control" name="name_en" value="<?php echo e(!empty($category->name_en) ? $category->name_en :''); ?>" placeholder="Name">
                                                    <input id="param" type="hidden" class="form-control" name="param" value="" placeholder="param">
                                                </div>

                                                <div class="form-group">
                                                    <label class="form-label">description</label>
                                                    <textarea id="blog_category_description_en" class="form-control texteditor" name="description_en" rows="4" placeholder="description"><?php echo e(!empty($category->description_en) ? $category->description_en :''); ?></textarea>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
    <!-- .row -->

<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>

    <!--Jquery Sparkline js-->
    <script src="<?php echo e(URL::asset('assets/plugins/vendors/jquery.sparkline.min.js')); ?>"></script>

    <!-- File uploads js -->
    <script src="<?php echo e(URL::asset('assets/plugins/fileuploads/js/dropify.js')); ?>"></script>
    <script src="<?php echo e(URL::asset('assets/plugins/fileuploads/js/dropify-demo.js')); ?>"></script>

    <!--Select2 js -->
    <script src="<?php echo e(URL::asset('assets/plugins/select2/select2.full.min.js')); ?>"></script>
    <!-- <script src="<?php echo e(URL::asset('assets/js/form-elements.js')); ?>"></script> -->

    <!--MutipleSelect js-->
    <script src="<?php echo e(URL::asset('assets/plugins/multipleselect/multiple-select.js')); ?>"></script>
    <script src="<?php echo e(URL::asset('assets/plugins/multipleselect/multi-select.js')); ?>"></script>

    <!--ckeditor js-->
    <script src="<?php echo e(URL::asset('assets/plugins/tinymce/tinymce.min.js')); ?>"></script>
    <!-- <script src="<?php echo e(URL::asset('assets/js/formeditor.js')); ?>"></script> -->

    <!---Tabs js-->
    <script src="<?php echo e(URL::asset('assets/plugins/tabs/jquery.multipurpose_tabcontent.js')); ?>"></script>
    <script src="<?php echo e(URL::asset('assets/plugins/tabs/tabs.js')); ?>"></script>

    <!-- Notifications js -->
    <link href="<?php echo e(URL::asset('assets/plugins/notify-growl/css/jquery.growl.css')); ?>" rel="stylesheet" />
    <link href="<?php echo e(URL::asset('assets/plugins/notify-growl/css/notifIt.css')); ?>" rel="stylesheet" />
    <script src="<?php echo e(URL::asset('assets/plugins/bootbox/bootbox.js')); ?>"></script>
    <script src="<?php echo e(URL::asset('assets/plugins/notify-growl/js/rainbow.js')); ?>"></script>
    <script src="<?php echo e(URL::asset('assets/plugins/notify-growl/js/jquery.growl.js')); ?>"></script>

    <!-- validator js -->
    <script src="<?php echo e(URL::asset('assets/plugins/validator/js/jquery.validate.min.js')); ?>"></script>

    <!-- mwz master js css -->
    <link rel="stylesheet" href="<?php echo e(mix('css/mwz.css')); ?>">
    <script src="<?php echo e(mix('js/mwz.js')); ?>"></script>

    <!-- module js css -->
    <link rel="stylesheet" href="<?php echo e(mix('css/blog.css')); ?>">
    <script src="<?php echo e(mix('js/blog.js')); ?>"></script>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/dev.mwz/Modules/Blog/Resources/views/category_form.blade.php ENDPATH**/ ?>