
$( document ).ready(function() {
    // init for master
    initDatatable();

    // init for master category
    initCategorydatatable();
   
});

// =========================  master =========================== //

initDatatable= function (){
    if($('#master-datatable').length>0){
        oTable= $('#master-datatable').DataTable( {
            "processing": true,
            "serverSide": true,
            "stateSave": true,
            "ajax": {
                "url": "/admin/master/datatable_ajax"
            },
            "columns": [
                { "data": "id" , orderable: false, searchable: false},
                { "data": "name" },
                { "data": "updated_at"  },
                { "data": "action", orderable: false, searchable: false }
            ]
        } );
    }
}

setReloadDataTable = function (){
   $('#master-datatable').DataTable().ajax.reload(null, false );
}

setUpdateStatus=function(id,status){
    event.preventDefault();
    let _token   = $('meta[name="csrf-token"]').attr('content');

    $.ajax({
        url: "/admin/master/set_status",
        type:"POST",
        data:{
          id:id,
          status:status,
          _token: _token
        },
        success:function(resp){
            if(resp.success){
                mwz_noti('success',resp.msg);
                setReloadDataTable();
            }else{
                mwz_noti('error',resp.msg);
                setReloadDataTable();
            }
        },
    });
}


setDelete=function(id){
    bootbox.confirm("Are you sure to delete master?", function(result){
        if(result){
            event.preventDefault();
            let _token   = $('meta[name="csrf-token"]').attr('content');

            $.ajax({
                url: "/admin/master/set_delete",
                type:"POST",
                data:{
                  id:id,
                  status:status,
                  _token: _token
                },
                success:function(resp){
                    if(resp.success){
                        mwz_noti('success',resp.msg);
                        setReloadDataTable();
                    }else{
                        mwz_noti('error',resp.msg);
                        setReloadDataTable();
                    }
                },
            });
        }
    })
}


setSave=function(){
    event.preventDefault();
    tinyMCE.triggerSave();
    var frm_data = new FormData($('#master_frm')[0]);
    $.ajax({
        url: "/admin/master/save" ,
        type:"POST",
        contentType: false,
        data: frm_data ,
        processData: false,
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        beforeSend:function(xhr){
            var rules = {
                    name: "required",
                    description: "required",
                    detail: "required",
                    status: "required"
                }

            var messages = {
                    name: "Please enter master name",
                    description: "Please enter master description",
                    detail: "Please enter master detail",
                    agree: "Please select status"
                }

            mwz_frm_validate($("#master_frm"),rules,messages)

            if( $("#master_frm").valid()) {
                return $("#master_frm").valid();
            }else{
                mwz_noti('error',resp.msg);
                return $("#master_frm").valid();
            }
        },
        success:function(resp){
            if(resp.success){
                mwz_noti('success',resp.msg);
                window.location.href = '/admin/master/' ;
            }else{
                mwz_noti('error',resp.msg);
            }
        },
    });
    
}

// =========================  category =========================== //

initCategorydatatable= function (){
    if($('#master-categroy-datatable').length>0){
        oTable= $('#master-categroy-datatable').DataTable( {
            "processing": true,
            "serverSide": true,
            "stateSave": true,
            "ajax": {
                "url": "/admin/master/category_datatable_ajax"
            },
            "columns": [
                { "data": "id" , orderable: false, searchable: false},
                { "data": "name" },
                { "data": "updated_at"  },
                { "data": "action", orderable: false, searchable: false }
            ]
        } );
    }
}


setReloadCategoryDataTable = function (){
   $('#master-categroy-datatable').DataTable().ajax.reload(null, false );
}


setUpdateCategoryStatus=function(category_id,status){
    event.preventDefault();
    let _token   = $('meta[name="csrf-token"]').attr('content');

    $.ajax({
        url: "/admin/master/category_set_category_status",
        type:"POST",
        data:{
          category_id:category_id,
          status:status,
          _token: _token
        },
        success:function(resp){
            if(resp.success){
                mwz_noti('success',resp.msg);
                setReloadCategoryDataTable();
            }else{
                mwz_noti('error',resp.msg);
                setReloadCategoryDataTable();
            }
        },
    });
}


setDeleteCategory=function(category_id){
    bootbox.confirm("Are you sure to delete category?", function(result){
        if(result){
            event.preventDefault();
            let _token   = $('meta[name="csrf-token"]').attr('content');

            $.ajax({
                url: "/admin/master/category_set_category_delete",
                type:"POST",
                data:{
                  category_id:category_id,
                  status:status,
                  _token: _token
                },
                success:function(resp){
                    if(resp.success){
                        mwz_noti('success',resp.msg);
                        setReloadCategoryDataTable();
                    }else{
                        mwz_noti('error',resp.msg);
                        setReloadCategoryDataTable();
                    }
                },
            });
        }
    })
}


setSaveCategory=function(frm){
    event.preventDefault();
    tinyMCE.triggerSave();

    var frm_data = new FormData($('#master_category_frm')[0]);

    $.ajax({
        url: "/admin/master/category/save" ,
        type:"POST",
        contentType: false,
        data: frm_data ,
        processData: false,
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        beforeSend:function(xhr){
            var rules = {
                    name: "required",
                    description: "required",
                    status: "required"
                }

            var messages = {
                    name: "Please enter category name",
                    description: "Please enter category description",
                    status: "Please select status"
                }

            mwz_frm_validate($("#master_category_frm"),rules,messages)

            if( $("#master_category_frm").valid()) {
                return $("#master_category_frm").valid();
            }else{
                mwz_noti('error',resp.msg);
                return $("#master_category_frm").valid();
            }
        },
        success:function(resp){
            if(resp.success){
                mwz_noti('success',resp.msg);
                window.location.href = '/admin/master/category/' ;
            }else{
                mwz_noti('error',resp.msg);
            }
        },
    });
    
}