<?php
session_start();
// if($_SESSION['_DOMAIN_ID']==1807) {
// 	ini_set('max_execution_time', '600');
// }
header('Content-Type: text/html; charset=utf-8');
$protocol = stripos($_SERVER['SERVER_PROTOCOL'],'https') === true ? 'https://' : 'http://';
// shopup site directory create
$_DOMAIN_ID = (int)$_SESSION['_DOMAIN_ID'];
if($_DOMAIN_ID==0) {
	exit;
}
// $_SITE_URL= "http://m.shopup.com/" ;
$_SITE_DIR = "../../../sites/{$_DOMAIN_ID}/files/u/";
$_FILE_PATH = "../../../sites/{$_DOMAIN_ID}/files/u/";

$_SITE_UPLOAD_DIR = "../../../sites/{$_DOMAIN_ID}/files/u/";
$_FILE_UPLOAD_PATH = "../../../sites/{$_DOMAIN_ID}/files/u/";

// $_SITE_CACHE_DIR = "../../../sites/{$_DOMAIN_ID}/cache/";
// $_FILE_CACHE_PATH = "../../../sites/{$_DOMAIN_ID}/cache/";

$_SITE_CSS_DIR = "../../../sites/{$_DOMAIN_ID}/cssoverwrite/";
$_FILE_CSS_PATH = "../../../sites/{$_DOMAIN_ID}/cssoverwrite/";

if(!file_exists($_SITE_CSS_DIR)) {
	@mkdir($_SITE_CSS_DIR);
	@chmod($_SITE_CSS_DIR,0755);
}

// if(!file_exists($_SITE_UPLOAD_DIR)) {
// 	@mkdir($_SITE_UPLOAD_DIR);
// 	@chmod($_SITE_UPLOAD_DIR,0755);
// }

include_once dirname(__FILE__).DIRECTORY_SEPARATOR.'elFinderConnector.class.php';
include_once dirname(__FILE__).DIRECTORY_SEPARATOR.'elFinder.class.php';
include_once dirname(__FILE__).DIRECTORY_SEPARATOR.'elFinderVolumeDriver.class.php';
include_once dirname(__FILE__).DIRECTORY_SEPARATOR.'elFinderVolumeLocalFileSystem.class.php';
// Required for MySQL storage connector
// include_once dirname(__FILE__).DIRECTORY_SEPARATOR.'elFinderVolumeMySQL.class.php';
// Required for FTP connector support
// include_once dirname(__FILE__).DIRECTORY_SEPARATOR.'elFinderVolumeFTP.class.php';
/**
 * Simple function to demonstrate how to control file access using "accessControl" callback.
 * This method will disable accessing files/folders starting from  '.' (dot)
 *
 * @param  string  $attr  attribute name (read|write|locked|hidden)
 * @param  string  $path  file path relative to volume root directory started with directory separator
 * @return bool|null
 **/
function access($attr, $path, $data, $volume) {
	return strpos(basename($path), '.') === 0       // if file/folder begins with '.' (dot)
		? !($attr == 'read' || $attr == 'write')    // set read+write to false, other (locked+hidden) set to true
		:  null;                                    // else elFinder decide it itself
}

$filesize = "5M";
if($_SESSION['_DOMAIN_CONFIG']['package_id']==3) {
	$filesize = "50M";
} else if($_SESSION['_DOMAIN_CONFIG']['package_id']==2) {
	$filesize = "10M";
} else {
	$filesize = "5M";
}

$opts = array(
	// 'debug' => true,
	'roots' => array(
		array(
			'driver'		=> 'LocalFileSystem',   // driver for accessing file system (REQUIRED)
			'path'			=> $_SITE_DIR ,         // path to files (REQUIRED)
			'URL'			=> $_FILE_PATH, // URL to files (REQUIRED)
			'accessControl' => 'access',             // disable and hide dot starting files (OPTIONAL)
			'alias'			=> 'Upload',
			'uploadMaxSize'	=> $filesize,
			'uploadOrder'	=> array('deny','allow'),
			'uploadDeny' 	=> array('text/php','text/plain','text/html','text/javascript','application/x-httpd-php'),
			'uploadAllow'	=> array(
				'image',
				'application/xhtml+xml',
				'application/msword','text/csv',
				'application/vnd.openxmlformats-officedocument.wordprocessingml.document',
				'text/csv',
				'application/pdf',
				'application/zip',
				'application/xml',
				'application/vnd.ms-powerpoint',
				'application/vnd.openxmlformats-officedocument.presentationml.presentation',
				'image/svg+xml'
			),
			// 'uploadOrder'	=> array('allow','deny'),
			// 'uploadAllow'	=> array('css','js','bmp','jpg','JPG','jpeg','JPEG','jpeg','gif','GIF','png','PNG','tif','TIF','tiff','TIFF:','xls','pdf','swf','avi','doc','docx','ppt','pptx','xls','xlsx','zip','rar','mp3','mp4','webm','woff','ttf'),
			// 'uploadDeny' => array('text/php')
		),
		array(
			'driver'		=> 'LocalFileSystem',   // driver for accessing file system (REQUIRED)
			'path'			=> $_SITE_CSS_DIR ,         // path to files (REQUIRED)
			'URL'			=> $_FILE_CSS_PATH, // URL to files (REQUIRED)
			'accessControl' => 'access',             // disable and hide dot starting files (OPTIONAL)
			'alias'			=> 'Css',
			'uploadOrder'	=> array('deny','allow'),
			'uploadDeny' 	=> array('text/php','text/plain','text/html','text/javascript','application/x-httpd-php'),
			'uploadAllow'	=> array(
				'image',
				'application/xhtml+xml',
				'application/msword','text/csv',
				'application/vnd.openxmlformats-officedocument.wordprocessingml.document',
				'text/csv',
				'application/pdf',
				'application/zip',
				'application/xml',
				'application/vnd.ms-powerpoint',
				'application/vnd.openxmlformats-officedocument.presentationml.presentation',
				'image/svg+xml'
			),
			// 'uploadOrder'	=> array('allow','deny'),
			// 'uploadDeny'	=> array('text/html','php','js')
		)
	)
);

if($_DOMAIN_ID==2320){
	$opts = array(
	// 'debug' => true,
	'roots' => array(
		array(
			'driver'        => 'LocalFileSystem',   // driver for accessing file system (REQUIRED)
			'path'          => $_SITE_DIR ,         // path to files (REQUIRED)
			'URL'           => $_FILE_PATH,			// URL to files (REQUIRED)
			'accessControl' => 'access',			// disable and hide dot starting files (OPTIONAL)
			'alias'      	=> 'Upload',
			'uploadMaxSize'	=> $filesize
		),
		// array(
		// 	'driver'        => 'LocalFileSystem',   // driver for accessing file system (REQUIRED)
		// 	'path'          => $_SITE_CACHE_DIR ,         // path to files (REQUIRED)
		// 	'URL'           => $_FILE_CACHE_PATH, // URL to files (REQUIRED)
		// 	'accessControl' => 'access',             // disable and hide dot starting files (OPTIONAL)
		// 	'alias'      => 'Cache'
		// ),
		array(
			'driver'        => 'LocalFileSystem',   // driver for accessing file system (REQUIRED)
			'path'          => $_SITE_CSS_DIR ,         // path to files (REQUIRED)
			'URL'           => $_FILE_CSS_PATH, // URL to files (REQUIRED)
			'accessControl' => 'access',             // disable and hide dot starting files (OPTIONAL)
			'alias'      	=> 'Css'
		)
	)
	);
}

// run elFinder
$connector = new elFinderConnector(new elFinder($opts));
$connector->run();