/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, { enumerable: true, get: getter });
/******/ 		}
/******/ 	};
/******/
/******/ 	// define __esModule on exports
/******/ 	__webpack_require__.r = function(exports) {
/******/ 		if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 			Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 		}
/******/ 		Object.defineProperty(exports, '__esModule', { value: true });
/******/ 	};
/******/
/******/ 	// create a fake namespace object
/******/ 	// mode & 1: value is a module id, require it
/******/ 	// mode & 2: merge all properties of value into the ns
/******/ 	// mode & 4: return value when already ns object
/******/ 	// mode & 8|1: behave like require
/******/ 	__webpack_require__.t = function(value, mode) {
/******/ 		if(mode & 1) value = __webpack_require__(value);
/******/ 		if(mode & 8) return value;
/******/ 		if((mode & 4) && typeof value === 'object' && value && value.__esModule) return value;
/******/ 		var ns = Object.create(null);
/******/ 		__webpack_require__.r(ns);
/******/ 		Object.defineProperty(ns, 'default', { enumerable: true, value: value });
/******/ 		if(mode & 2 && typeof value != 'string') for(var key in value) __webpack_require__.d(ns, key, function(key) { return value[key]; }.bind(null, key));
/******/ 		return ns;
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "/";
/******/
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = 0);
/******/ })
/************************************************************************/
/******/ ({

/***/ "./Resources/assets/js/app.js":
/*!************************************!*\
  !*** ./Resources/assets/js/app.js ***!
  \************************************/
/*! no static exports found */
/***/ (function(module, exports) {

$(document).ready(function () {
  // init for table all
  initDatatable();
  teacherDatatable();
  recordDataTable();
  courseDataTable();
  courseList(); //ajax province

  getProvince();
}); // =========================  member =========================== //

getProvince = function getProvince() {
  var getprovince = $('#province');
  var getdistrict = $('#district');
  var getsubdistrict = $('#sub_district');

  var _token = $('meta[name="csrf-token"]').attr('content');

  getprovince.on('change', function () {
    if ($(this).val() != "") {
      var provinceId = $(this).val();
      $.ajax({
        url: "/admin/member/province",
        type: "POST",
        data: {
          id: provinceId,
          _token: _token
        },
        success: function success(resp) {
          $('#district').html(resp);
        }
      });
    }
  });
  getdistrict.on('change', function () {
    if ($(this).val() != "") {
      var districtId = $(this).val();
      $.ajax({
        url: "/admin/member/district",
        type: "POST",
        data: {
          id: districtId,
          _token: _token
        },
        success: function success(resp) {
          $('#sub_district').html(resp);
        }
      });
    }
  });
  getsubdistrict.on('change', function () {
    if ($(this).val() != "") {
      var subdistrictId = $(this).val();
      $.ajax({
        url: "/admin/member/subdistrict",
        type: "POST",
        data: {
          id: subdistrictId,
          _token: _token
        },
        success: function success(resp) {
          $('#zipcode').html(resp);
        }
      });
    }
  });
};

initDatatable = function initDatatable() {
  if ($('#member-datatable').length > 0) {
    oTable = $('#member-datatable').DataTable({
      "processing": true,
      "serverSide": true,
      "stateSave": true,
      "ajax": {
        "url": "/admin/member/datatable_ajax"
      },
      "columns": [{
        "data": "id",
        orderable: false,
        searchable: false
      }, {
        "data": "name"
      }, {
        "data": "email"
      }, {
        "data": "accept_term"
      }, {
        "data": "accept_condition"
      }, {
        "data": "join_date"
      }, {
        "data": "action",
        orderable: false,
        searchable: false
      }]
    });
  }
};

teacherDatatable = function teacherDatatable() {
  if ($('#teacher-datatable').length > 0) {
    oTable = $('#teacher-datatable').DataTable({
      "processing": true,
      "serverSide": true,
      "stateSave": true,
      "ajax": {
        "url": "/admin/member/datatable_ajax_teacher"
      },
      "columns": [{
        "data": "id",
        orderable: false,
        searchable: false
      }, {
        "data": "name"
      }, {
        "data": "email"
      }, {
        "data": "accept_term"
      }, {
        "data": "accept_condition"
      }, {
        "data": "join_date"
      }, {
        "data": "action",
        orderable: false,
        searchable: false
      }]
    });
  }
};

recordDataTable = function recordDataTable() {
  var idf = $('input[name="id"]').val();

  if ($('#record-datatable').length > 0) {
    oTable = $('#record-datatable').DataTable({
      "processing": true,
      "serverSide": true,
      "stateSave": true,
      "ajax": {
        "url": "/admin/member/recordDataTable",
        "type": "get",
        "data": {
          "idf": idf
        }
      },
      "columns": [{
        "data": "id",
        orderable: false,
        searchable: false
      }, {
        "data": "name_th"
      }, {
        "data": "nickname"
      }, {
        "data": "date"
      }, {
        "data": "payment_status"
      }, {
        "data": "status"
      }, {
        "data": "action",
        orderable: false,
        searchable: false
      }]
    });
  }
};

courseDataTable = function courseDataTable() {
  var idf = $('input[name="id"]').val();

  if ($('#record-course').length > 0) {
    oTable = $('#record-course').DataTable({
      "processing": true,
      "serverSide": true,
      "stateSave": true,
      "ajax": {
        "url": "/admin/member/courseDataTable",
        "type": "get",
        "data": {
          "idf": idf
        }
      },
      "columns": [{
        "data": "id",
        orderable: false,
        searchable: false
      }, {
        "data": "name_th"
      }, {
        "data": "student_id"
      }, {
        "data": "date"
      }, {
        "data": "status"
      }, {
        "data": "action",
        orderable: false,
        searchable: false
      }]
    });
  }
};

courseList = function courseList() {
  var idf = $('input[name="id"]').val();

  if ($('#courselist-datatable').length > 0) {
    oTable = $('#courselist-datatable').DataTable({
      "processing": true,
      "serverSide": true,
      "stateSave": true,
      "ajax": {
        "url": "/admin/member/courseList",
        "type": "get",
        "data": {
          "idf": idf
        }
      },
      "columns": [{
        "data": "id",
        orderable: false,
        searchable: false
      }, {
        "data": "sequence"
      }, {
        "data": "name_th"
      }, {
        "data": "description_th"
      }, {
        "data": "price"
      }, {
        "data": "action",
        orderable: false,
        searchable: false
      }]
    });
  }
};

setReloadDataTable = function setReloadDataTable() {
  $('#member-datatable').DataTable().ajax.reload(null, false);
  $('#teacher-datatable').DataTable().ajax.reload(null, false);
  $('#record-course').DataTable().ajax.reload(null, false);
  $('#record-datatable').DataTable().ajax.reload(null, false);
  $('#courselist-datatable').DataTable().ajax.reload(null, false);
};

setUpdateStatus = function setUpdateStatus(id, status) {
  event.preventDefault();

  var _token = $('meta[name="csrf-token"]').attr('content');

  $.ajax({
    url: "/admin/member/set_status",
    type: "POST",
    data: {
      id: id,
      status: status,
      _token: _token
    },
    success: function success(resp) {
      if (resp.success) {
        mwz_noti('success', resp.msg);
        setReloadDataTable();
      } else {
        mwz_noti('error', resp.msg);
        setReloadDataTable();
      }
    }
  });
};

setUpdateStatuscourse = function setUpdateStatuscourse(id, status) {
  event.preventDefault();

  var _token = $('meta[name="csrf-token"]').attr('content');

  $.ajax({
    url: "/admin/member/set_statuscourse",
    type: "POST",
    data: {
      id: id,
      status: status,
      _token: _token
    },
    success: function success(resp) {
      if (resp.success) {
        mwz_noti('success', resp.msg);
        setReloadDataTable();
      } else {
        mwz_noti('error', resp.msg);
        setReloadDataTable();
      }
    }
  });
};

setUpdateStatusRegisCourse = function setUpdateStatusRegisCourse(id, status) {
  event.preventDefault();

  var _token = $('meta[name="csrf-token"]').attr('content');

  $.ajax({
    url: "/admin/member/set_status_regis_course",
    type: "POST",
    data: {
      id: id,
      status: status,
      _token: _token
    },
    success: function success(resp) {
      if (resp.success) {
        mwz_noti('success', resp.msg);
        setReloadDataTable();
      } else {
        mwz_noti('error', resp.msg);
        setReloadDataTable();
      }
    }
  });
  console.log('test');
};

setDelete = function setDelete(id) {
  bootbox.confirm("Are you sure to delete member?", function (result) {
    if (result) {
      event.preventDefault();

      var _token = $('meta[name="csrf-token"]').attr('content');

      $.ajax({
        url: "/admin/member/set_delete",
        type: "POST",
        data: {
          id: id,
          status: status,
          _token: _token
        },
        success: function success(resp) {
          if (resp.success) {
            mwz_noti('success', resp.msg);
            setReloadDataTable();
          } else {
            mwz_noti('error', resp.msg);
            setReloadDataTable();
          }
        }
      });
    }
  });
};

setSave = function setSave() {
  event.preventDefault();
  tinyMCE.triggerSave();
  var frm_data = new FormData($('#member_frm')[0]);
  $.ajax({
    url: "/admin/member/save",
    type: "POST",
    contentType: false,
    data: frm_data,
    processData: false,
    headers: {
      'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
    },
    beforeSend: function beforeSend(xhr) {
      var rules = {
        name: "required",
        email: "required",
        accept_term: "required",
        accept_condition: "required",
        status: "required"
      };
      var messages = {
        name: "Please enter member name",
        email: "Please enter member email",
        accept_term: "Please enter member accept_term",
        accept_condition: "Please enter member accept_condition",
        agree: "Please select status"
      };
      mwz_frm_validate($("#member_frm"), rules, messages);

      if ($("#member_frm").valid()) {
        return $("#member_frm").valid();
      } else {
        mwz_noti('error', resp.msg);
        return $("#member_frm").valid();
      }
    },
    success: function success(resp) {
      if (resp.success) {
        mwz_noti('success', resp.msg);
        window.location.href = '/admin/member/';
      } else {
        mwz_noti('error', resp.msg);
      }
    }
  });
};

setSaveTeacher = function setSaveTeacher() {
  event.preventDefault();
  tinyMCE.triggerSave();
  var frm_data = new FormData($('#member_frm')[0]);
  $.ajax({
    url: "/admin/member/saveteacher",
    type: "POST",
    contentType: false,
    data: frm_data,
    processData: false,
    headers: {
      'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
    },
    beforeSend: function beforeSend(xhr) {
      var rules = {
        email: "required",
        phone: "required",
        address: "required",
        sub_district: "required",
        district: "required",
        province: "required",
        zipcode: "required",
        description_profile: "required",
        resume: "required",
        vdo: "required",
        title_name: "required",
        name: "required",
        nickname: "required",
        birthdate: "required",
        status: "required"
      };
      var messages = {
        email: "Please enter member email",
        phone: "Please enter member phone",
        address: "Please enter member address",
        sub_district: "Please enter member sub_district",
        district: "Please enter member district",
        province: "Please enter member province",
        zipcode: "Please enter member zipcode",
        description_profile: "Please enter member detail_profile",
        resume: "Please enter member resume",
        vdo: "Please enter member vdo",
        title_name: "Please enter member title_name",
        name: "Please enter member name",
        nickname: "Please enter member nickname",
        birthdate: "Please enter member birthdate",
        agree: "Please select status"
      };
      mwz_frm_validate($("#member_frm"), rules, messages);

      if ($("#member_frm").valid()) {
        return $("#member_frm").valid();
      } else {
        mwz_noti('error', resp.msg);
        return $("#member_frm").valid();
      }
    },
    success: function success(resp) {
      if (resp.success) {
        mwz_noti('success', resp.msg);
        window.location.href = '/admin/member/';
      } else {
        mwz_noti('error', resp.msg);
      }
    }
  });
};

/***/ }),

/***/ "./Resources/assets/sass/app.scss":
/*!****************************************!*\
  !*** ./Resources/assets/sass/app.scss ***!
  \****************************************/
/*! no static exports found */
/***/ (function(module, exports) {

// removed by extract-text-webpack-plugin

/***/ }),

/***/ 0:
/*!***************************************************************************!*\
  !*** multi ./Resources/assets/js/app.js ./Resources/assets/sass/app.scss ***!
  \***************************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

__webpack_require__(/*! /Applications/XAMPP/xamppfiles/htdocs/dev.mwz/Modules/Member/Resources/assets/js/app.js */"./Resources/assets/js/app.js");
module.exports = __webpack_require__(/*! /Applications/XAMPP/xamppfiles/htdocs/dev.mwz/Modules/Member/Resources/assets/sass/app.scss */"./Resources/assets/sass/app.scss");


/***/ })

/******/ });