<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class SetLocale
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle(Request $request, Closure $next)
    {
        
        $segments = $request->segments();
        $locale = $segments[0];
        app()->setLocale($locale);

        print_r(Auth::guard('admin')->user()) ;

        app()->setLocale(Auth::guard('admin')->user()->locale);
        
        $languages = ['th','en','jp','ch'];
        if (!in_array($locale, $languages)) {
            $segments = array_merge(['th'], $segments);
            return $this->redirector->to(implode('/', $segments));
        }
        
        return $next($request);
    }
}
