@extends('layouts.app')

@section('styles')

    <!---Tabs css-->
    <link href="{{ URL::asset('assets/plugins/tabs/tabs-style.css') }}" rel="stylesheet" />

    <!--Select2 css -->
    <link href="{{ URL::asset('assets/plugins/select2/select2.min.css') }}" rel="stylesheet" />

    <!-- File Uploads css-->
    <link href="{{ URL::asset('assets/plugins/fileuploads/css/dropify.css') }}" rel="stylesheet" type="text/css" />

    <!--Mutipleselect css-->
    <link rel="stylesheet" href="{{ URL::asset('assets/plugins/multipleselect/multiple-select.css') }}">

    <!-- Gallery css -->
    <link href="{{ URL::asset('assets/plugins/gallery/gallery.css') }}" rel="stylesheet">

@endsection

@section('content')

    <!-- page-header -->
    <div class="page-header">
        <ol class="breadcrumb">
            <!-- breadcrumb -->
            <li class="breadcrumb-item"><a href="{{ route('admin.websetting.websetting.edit') }}">หน้าหลัก</a></li>
            <li class="breadcrumb-item active" aria-current="page">ตั้งค่าเว็บไซต์</li>
        </ol>
    </div>
    <!-- End page-header -->

    <!-- row -->
    <div class="row">
        <div class="col-md-12">
            <form id="setting_frm" name="setting_frm" method="POST" onsubmit="setSave(); return false;"
                enctype="multipart/form-data">
                @csrf
                <input type="hidden" name="id" value="{{ !empty($setting->id) ? $setting->id : '0' }}">

                <div class="panel panel-primary">
                    <div class=" tab-menu-heading">
                        <div class="tabs-menu1 ">
                            <!-- Tabs -->
                            <ul class="nav panel-tabs">
                                <li class="___class_+?10___"><a href="#tab5" class="active"
                                        data-toggle="tab">ตั้งค่าเว็บไซต์</a></li>
                                <li><a href="#tab6" data-toggle="tab">ข้อมูลการทำ SEO</a></li>
                            </ul>
                        </div>
                    </div>
                    <div class="panel-body tabs-menu-body">
                        <div class="tab-content">
                            <div class="tab-pane active " id="tab5">

                                <div class="panel panel-primary">
                                    {{-- start tap --}}
                                    <div class="tab_wrapper first_tab">
                                        <ul class="tab_list">
                                            {{-- header tap 1 --}}
                                            <li class="icons-list-item" style="height: 36px;">โลโก้บริษัทส่วนบน(Header)</i>
                                            </li>
                                            {{-- header tap 2 --}}
                                            <li class="icons-list-item" style="height: 36px;">โลโก้บริษัทส่วนล่าง(Footer)
                                            </li>
                                        </ul>
                                        <div class="content_wrapper">
                                            {{-- tap 1 --}}
                                            <div class="tab_content active">
                                                <div class="row">
                                                    <div class="col-md-12">
                                                        {{-- start input --}}
                                                        <div class="alert alert-default" role="alert" title="ภาษาไทย">
                                                            <span class="alert-inner--icon"><i
                                                                    class="fe fe-bell"></i></i></span>
                                                            <span class="alert-inner--text">คุณกำลังแก้ไขการรูปภาพ
                                                                <strong>Header</strong></span>
                                                        </div>
                                                        @if (empty($setting->logo_header))
                                                            <div class="card">
                                                                <div class="card-header pb-0">
                                                                    <h3 class="mb-0 card-title">อัปโหลดรูปภาพ</h3>
                                                                </div>
                                                                <div class="card-body">
                                                                    <input type="file" name="logo_header"
                                                                        class="dropify" data-default-file="" />
                                                                </div>
                                                                <label class="ml-5">ขนาดรูปภาพ 150 x 150px</label>
                                                            </div>
                                                        @else
                                                            <div class="demo-gallery card">
                                                                <div class="card-header pb-0">
                                                                    <div class="card-title">รูปภาพที่อัปโหลด</div>
                                                                </div>
                                                                <div class="card-body row">
                                                                    <div class="col-md-5"></div>
                                                                    <div class="col-md-2">
                                                                        <ul id="lightgallery" class="list-unstyled">
                                                                            <li data-responsive="{{ $setting->logo_header }}"
                                                                                data-src="{{ $setting->logo_header }}">
                                                                                <a href="">
                                                                                    <img class="img-responsive"
                                                                                        src="{{ $setting->logo_header }}"
                                                                                        alt="Thumb-1">
                                                                                </a>
                                                                            </li>
                                                                        </ul>
                                                                    </div>
                                                                    <div class="col-md-5"></div>
                                                                    <label>ขนาดรูปภาพ 150 x 150px</label>
                                                                    <button type="button" onclick="DeleteImage('1')"
                                                                        class="btn btn-outline-danger btn-block">ลบรูปภาพ</button>
                                                                </div>
                                                            </div>
                                                        @endif
                                                        {{-- end input --}}
                                                    </div>
                                                </div>
                                            </div>
                                            {{-- end tap 1 --}}
                                            {{-- tap 2 --}}
                                            <div class="tab_content">
                                                <div class="row">
                                                    <div class="col-md-12">
                                                        {{-- start input --}}
                                                        <div class="alert alert-default" role="alert" title="ภาษอังกฤษ">
                                                            <span class="alert-inner--icon"><i
                                                                    class="fe fe-bell"></i></i></span>
                                                            <span class="alert-inner--text">คุณกำลังแก้ไขการรูปภาพ
                                                                <strong>Footer</strong></span>
                                                        </div>
                                                        @if (empty($setting->logo_footer))
                                                            <div class="card">
                                                                <div class="card-header pb-0">
                                                                    <h3 class="mb-0 card-title">อัปโหลดรูปภาพ</h3>
                                                                </div>
                                                                <div class="card-body">
                                                                    <input type="file" name="logo_footer"
                                                                        class="dropify" data-default-file="" />
                                                                </div>
                                                                <label class="ml-5">ขนาดรูปภาพ 130 x 95px</label>
                                                            </div>
                                                        @else
                                                            <div class="demo-gallery card">
                                                                <div class="card-header pb-0">
                                                                    <div class="card-title">รูปภาพที่อัปโหลด</div>
                                                                </div>
                                                                <div class="card-body row">
                                                                    <div class="col-md-5"></div>
                                                                    <div class="col-md-2">
                                                                        <ul id="lightgallery_2" class="list-unstyled">
                                                                            <li data-responsive="{{ $setting->logo_footer }}"
                                                                                data-src="{{ $setting->logo_footer }}">
                                                                                <a href="">
                                                                                    <img class="img-responsive"
                                                                                        src="{{ $setting->logo_footer }}"
                                                                                        alt="Thumb-1">
                                                                                </a>
                                                                            </li>
                                                                        </ul>
                                                                    </div>
                                                                    <div class="col-md-5"></div>
                                                                    <label>ขนาดรูปภาพ 130 x 95px</label>
                                                                    <button type="button" onclick="DeleteImage('2')"
                                                                        class="btn btn-outline-danger btn-block">ลบรูปภาพ</button>
                                                                </div>
                                                            </div>
                                                        @endif
                                                        {{-- end input --}}
                                                    </div>
                                                </div>
                                            </div>
                                            {{-- end tap 2 --}}
                                        </div>
                                    </div>
                                    {{-- end tap --}}
                                    {{-- start tap --}}
                                    <div class="tab_wrapper first_tab mt-3">
                                        <ul class="tab_list">
                                            {{-- header tap 1 --}}
                                            <li class="icons-list-item" style="height: 36px;"><i class="flag flag-th"></i>
                                            </li>
                                            {{-- header tap 2 --}}
                                            <li class="icons-list-item" style="height: 36px;"><i class="flag flag-gb"></i>
                                            </li>
                                        </ul>
                                        <div class="content_wrapper">
                                            {{-- tap 1 --}}
                                            <div class="tab_content active">
                                                <div class="row">
                                                    <div class="col-md-12">
                                                        {{-- start input --}}
                                                        <div class="alert alert-default" role="alert" title="ภาษาไทย">
                                                            <span class="alert-inner--icon"><i
                                                                    class="fe fe-bell"></i></i></span>
                                                            <span class="alert-inner--text">คุณกำลังแก้ไขการแสดงผล
                                                                <strong>ภาษาไทย</strong></span>
                                                        </div>
                                                        <div class="form-group" title="ชื่อบริษัท (TH)">
                                                            <label class="form-label">ชื่อบริษัท (TH)</label>
                                                            <input type="text" class="form-control" name="companyname_th"
                                                                placeholder="ชื่อบริษัท (TH)"
                                                                value="{{ !empty($setting->companyname_th) ? $setting->companyname_th : '' }}">
                                                        </div>
                                                        {{-- end input --}}
                                                    </div>
                                                </div>
                                            </div>
                                            {{-- end tap 1 --}}
                                            {{-- tap 2 --}}
                                            <div class="tab_content">
                                                <div class="row">
                                                    <div class="col-md-12">
                                                        {{-- start input --}}
                                                        <div class="alert alert-default" role="alert" title="ภาษอังกฤษ">
                                                            <span class="alert-inner--icon"><i
                                                                    class="fe fe-bell"></i></i></span>
                                                            <span class="alert-inner--text">คุณกำลังแก้ไขการแสดงผล
                                                                <strong>ภาษอังกฤษ</strong></span>
                                                        </div>
                                                        <div class="form-group" title="ชื่อบริษัท (EN)">
                                                            <label class="form-label">ชื่อบริษัท (EN)</label>
                                                            <input type="text" class="form-control" name="companyname_en"
                                                                placeholder="ชื่อบริษัท (EN)"
                                                                value="{{ !empty($setting->companyname_en) ? $setting->companyname_en : '' }}">
                                                        </div>
                                                        {{-- end input --}}
                                                    </div>
                                                </div>
                                            </div>
                                            {{-- end tap 2 --}}
                                        </div>
                                    </div>
                                    {{-- end tap --}}
                                    <div class="card mt-3">
                                        <div class="card-body">
                                            <div class="form-group">
                                                <label class="form-label" title="Link (Login)">Link (Login)</label>
                                                <input type="text" class="form-control" name="link_login"
                                                    placeholder="Link ปลายทางLogin"
                                                    value="{{ !empty($setting->link_login) ? $setting->link_login : '' }}">
                                            </div>

                                            <div class="form-group">
                                                <label class="form-label" title="Facebook">Facebook</label>
                                                <input type="text" class="form-control" name="fb" placeholder="Facebook"
                                                    value="{{ !empty($setting->fb) ? $setting->fb : '' }}">
                                            </div>

                                            <div class="form-group">
                                                <label class="form-label" title="Line">Line</label>
                                                <input type="text" class="form-control" name="line" placeholder="line"
                                                    value="{{ !empty($setting->line) ? $setting->line : '' }}">
                                            </div>

                                            <div class="form-group">
                                                <label class="form-label" title="Youtube">Youtube</label>
                                                <input type="text" class="form-control" name="youtube"
                                                    placeholder="Youtube"
                                                    value="{{ !empty($setting->youtube) ? $setting->youtube : '' }}">
                                            </div>

                                            <div class="form-group">
                                                <label class="form-label" title="E-mail">E-mail</label>
                                                <input type="text" class="form-control" name="email" placeholder="E-mail"
                                                    value="{{ !empty($setting->email) ? $setting->email : '' }}">
                                            </div>

                                            <div class="form-group mt-5">
                                                <div class="btn-list">
                                                    <button type="submit" class="btn btn-primary"><i
                                                            class="ion-checkmark-circled mr-1"></i>บันทึกการเปลี่ยนแปลง</button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                            </div>
                            <div class="tab-pane " id="tab6">
                                <div class="alert alert-default" role="alert">
                                    <span class="alert-inner--icon"><i class="fe fe-bell"></i></span>
                                    <span class="alert-inner--text">การใส่ข้อมูลข้างต้นสำหรับทำ SEO ซึ่งจะช่วยให้ BOT
                                        สามารถเข้าถึงข้อมูลของหน้าเว็บไซต์ และช่วยในการทำ SEO ขั้นสูง</span>
                                </div>
                                <div class="form-group">
                                    <label class="form-label" title="ชื่อเว็บไซต์">ชื่อเว็บไซต์</label>
                                    <input type="text" class="form-control" name="meta_title"
                                        placeholder="โปรดระบุชื่อเว็บไซต์"
                                        value="{{ !empty($setting->meta_title) ? $setting->meta_title : '' }}">
                                </div>
                                <div class="form-group">
                                    <label class="form-label" title="คีย์เวิร์ด">คีย์เวิร์ด</label>
                                    <textarea class="form-control" id="meta_keywords" name="meta_keywords" rows="3"
                                        placeholder="โปรดระบุคีย์เวิร์ด">{{ !empty($setting->meta_keywords) ? $setting->meta_keywords : '' }}</textarea>
                                </div>
                                <div class="form-group">
                                    <label class="form-label" title="รายละเอียดเว็บไซต์">รายละเอียดเว็บไซต์</label>
                                    <textarea class="form-control" id="meta_description" name="meta_description" rows="3"
                                        placeholder="โปรดระบุรายละเอียดเว็บไซต์">{{ !empty($setting->meta_description) ? $setting->meta_description : '' }}</textarea>
                                </div>
                                @if (empty($setting->seo_image))
                                    <div class="card">
                                        <div class="card-header pb-0">
                                            <h3 class="mb-0 card-title">อัปโหลดรูปภาพ</h3>
                                        </div>
                                        <div class="card-body">
                                            <input type="file" name="seo_image" class="dropify"
                                                data-default-file="" />
                                        </div>
                                        <label class="ml-5">ขนาดภาพที่เหมาะสม</label>
                                    </div>
                                @else
                                    <div class="demo-gallery card">
                                        <div class="card-header pb-0">
                                            <div class="card-title">รูปภาพที่อัปโหลด</div>
                                        </div>
                                        <div class="card-body row">
                                            <div class="col-md-5"></div>
                                            <div class="col-md-2">
                                                <ul id="lightgallery_3" class="list-unstyled">
                                                    <li data-responsive="{{ $setting->seo_image }}"
                                                        data-src="{{ $setting->seo_image }}">
                                                        <a href="">
                                                            <img class="img-responsive"
                                                                src="{{ $setting->seo_image }}" alt="Thumb-1">
                                                        </a>
                                                    </li>
                                                </ul>
                                            </div>
                                            <div class="col-md-5"></div>
                                            <label>ขนาดภาพที่เหมาะสม</label>
                                            <button type="button" onclick="DeleteImage('3')"
                                                class="btn btn-outline-danger btn-block">ลบรูปภาพ</button>
                                        </div>
                                    </div>
                                @endif 
                                <div class="form-group">
                                    <label class="form-label" title="Google Analytics, Facebook Pixel">Google Analytics, Facebook Pixel</label>
                                    <textarea class="form-control" id="google_analytics" name="google_analytics" rows="6"
                                        placeholder="">{{ !empty($setting->google_analytics) ? $setting->google_analytics : '' }}</textarea>
                                </div>
                                <div class="form-group mt-5">
                                    <div class="btn-list">
                                        <button type="submit" class="btn btn-primary"><i
                                                class="ion-checkmark-circled mr-1"></i>บันทึกการเปลี่ยนแปลง</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            </form>
        </div>
    </div>
    <!-- .row -->

@endsection('content')

@section('scripts')

    <!--Jquery Sparkline js-->
    <script src="{{ URL::asset('assets/plugins/vendors/jquery.sparkline.min.js') }}"></script>

    <!-- File uploads js -->
    <script src="{{ URL::asset('assets/plugins/fileuploads/js/dropify.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/fileuploads/js/dropify-demo.js') }}"></script>

    <!--Select2 js -->
    <script src="{{ URL::asset('assets/plugins/select2/select2.full.min.js') }}"></script>
    <!-- <script src="{{ URL::asset('assets/js/form-elements.js') }}"></script> -->

    <!--MutipleSelect js-->
    <script src="{{ URL::asset('assets/plugins/multipleselect/multiple-select.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/multipleselect/multi-select.js') }}"></script>

    <!--ckeditor js-->
    <script src="{{ URL::asset('assets/plugins/tinymce/tinymce.min.js') }}"></script>
    <!-- <script src="{{ URL::asset('assets/js/formeditor.js') }}"></script> -->

    <!-- Notifications js -->
    <link href="{{ URL::asset('assets/plugins/notify-growl/css/jquery.growl.css') }}" rel="stylesheet" />
    <link href="{{ URL::asset('assets/plugins/notify-growl/css/notifIt.css') }}" rel="stylesheet" />
    <script src="{{ URL::asset('assets/plugins/bootbox/bootbox.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/notify-growl/js/rainbow.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/notify-growl/js/jquery.growl.js') }}"></script>

    <!-- validator js -->
    <script src="{{ URL::asset('assets/plugins/validator/js/jquery.validate.min.js') }}"></script>

    <!-- Tabs js -->
    <script src="{{ URL::asset('assets/plugins/tabs/jquery.multipurpose_tabcontent.js') }}"></script>
    <!-- <script src="{{ URL::asset('assets/plugins/tabs/tabs.js') }}"></script> -->

    <!-- Gallery js -->
    <script src="{{ URL::asset('assets/plugins/gallery/picturefill.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/gallery/lightgallery.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/gallery/lg-pager.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/gallery/lg-autoplay.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/gallery/lg-fullscreen.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/gallery/lg-zoom.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/gallery/lg-hash.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/gallery/lg-share.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/gallery/gallery.js') }}"></script>

    <!-- mwz master js css -->
    <link rel="stylesheet" href="{{ mix('css/mwz.css') }}">
    <script src="{{ mix('js/mwz.js') }}"></script>

    <!-- module js css -->
    <link rel="stylesheet" href="{{ mix('css/websetting.css') }}">
    <script src="{{ mix('js/websetting.js') }}"></script>

@endsection
