<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateWebsettingTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('websetting', function (Blueprint $table) {
            $table->id();
            $table->string('companyname_th', 250);
            $table->string('companyname_en', 250);
            $table->string('link_login', 200)->nullable();
            $table->string('fb', 200)->nullable();
            $table->string('line', 200)->nullable();
            $table->string('youtube', 200)->nullable();
            $table->string('email', 250);
            $table->string('logo_header', 200)->nullable();
            $table->string('logo_footer', 200)->nullable();
            $table->text('privacy_th')->nullable();
            $table->text('privacy_en')->nullable();
            $table->string('meta_title', 250)->nullable();
            $table->text('meta_keywords')->nullable();
            $table->text('meta_description')->nullable();
            $table->string('seo_image', 250)->nullable();
            $table->text('google_analytics')->nullable();
            $table->dateTime('created_at');
            $table->dateTime('updated_at');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('websetting');
    }
}
