@extends('layouts.app')

@section('styles')

<!--Select2 css -->
<link href="{{URL::asset('assets/plugins/select2/select2.min.css')}}" rel="stylesheet" />

<!-- Time picker css-->
<link href="{{URL::asset('assets/plugins/time-picker/jquery.timepicker.css')}}" rel="stylesheet" />

<!-- Date Picker css-->
<link href="{{URL::asset('assets/plugins/spectrum-date-picker/spectrum.css')}}" rel="stylesheet" />

<!-- File Uploads css-->
<link href="{{URL::asset('assets/plugins/fileuploads/css/dropify.css')}}" rel="stylesheet" type="text/css" />

<!--Mutipleselect css-->
<link rel="stylesheet" href="{{URL::asset('assets/plugins/multipleselect/multiple-select.css')}}">



@endsection

@section('content')

<!-- page-header -->
<div class="page-header">
	<ol class="breadcrumb"><!-- breadcrumb -->
		<li class="breadcrumb-item"><a href="{{ route('admin.websetting.websetting.edit') }}">หน้าหลัก</a></li>
		<li class="breadcrumb-item active" aria-current="page">ข้อมูลส่วนตัว</li>
	</ol>
</div>
<!-- End page-header -->

<!-- row -->
<div class="row">
	<div class="col-md-12">

		<div class="card">
			<div class="card-header pb-0">
				<h3 class="mb-0 card-title">รายละเอียด</h3>
			</div>
			<form id="user_frm" name="user_frm" method="POST" onsubmit="setSave(); return false;" enctype="multipart/form-data" >
				@csrf
				<input type="hidden" name="id" id="user_id" value="{{ !empty($user->id) ? $user->id :'0' }}">
				<div class="card-body">
					<div class="row">
						<div class="col-md-12">
							<div class="form-group">
								<label class="form-label">ชื่อ</label>
								<input type="text" class="form-control" name="name" placeholder="ชื่อ" value="{{ !empty($user->name) ? $user->name :'' }}">
							</div>
							<div class="form-group">
								<label class="form-label">อีเมล์</label>
								<input type="email" class="form-control" name="email" placeholder="youremail@domain.com" value="{{ !empty($user->email) ? $user->email :'' }}">
							</div>
							<div class="form-group">
								<label class="form-label">ชื่อผู้ใช้</label>
								<input <?=(!empty($user->id))?'readonly':'';?> type="text" class="form-control" name="username" placeholder="Username" value="{{ !empty($user->username) ? $user->username :'' }}">
							</div>
							<div class="form-group">
								<label class="form-label">รหัสผ่าน</label>
								<input type="password" class="form-control" id="password" name="password" placeholder="Password" value="{{ !empty($user->password) ? '********' :'' }}">
							</div>
							<div class="form-group">
								<label class="form-label">ช้ำ-รหัสผ่าน</label>
								<input type="password" class="form-control" id="re_password" name="re_password" placeholder="Re Password" value="{{ !empty($user->password) ? '********' :'' }}">
							</div>
							<div class="form-group ">
								<label class="form-label">กลุ่ม</label>
								<select name="group_id" class="form-control select2-show-search" data-placeholder="Choose Parent" onchange="setChangeGroup(this.value);">
									@foreach ($groups as $group)
									@if ( !empty($user->group_id) && $group->id == $user->group_id)
									<option value="{{ $group->id  }}" selected="selected">{{ $group->name }}</option>
									@else
									<option value="{{ $group->id  }}" >{{ $group->name }}</option>
									@endif

									@endforeach
								</select>
							</div>
							<div class="form-group ">
								<label class="form-label">ภาษา</label>
								<select name="locale" class="form-control select2-show-search" data-placeholder="Choose Locale" >
									<option value="th" selected="selected">TH</option>
								</select>
							</div>
							<div class="form-group">
								<label class="form-label">สถานะ เปิด/ปิด</label>
								<div class="form-check form-check-inline">
									<input class="form-check-input" type="radio" name="status" id="status_enable" value="1" checked="checked">
									<label class="form-check-label" for="status_enable" checked="checked">เปิด</label>
								</div>
							</div>
							<div class="form-group">
								<label class="form-label">API Enable</label>
								<div class="form-check form-check-inline">
									@if (empty($user->api_enable) || (!empty($user->api_enable)&&$user->api_enable==1) )
									<input class="form-check-input" type="radio" name="api_enable" id="api_enable" value="1" checked="checked">
									<label class="form-check-label mr-3" for="api_enable">Enable</label>
									<input class="form-check-input" type="radio" name="api_enable" id="api_disable"  value="0">
									<label class="form-check-label" for="api_disable">Disable</label>
									@else
									<input class="form-check-input" type="radio" name="api_enable" id="api_enable" value="1" >
									<label class="form-check-label mr-3" for="api_enable">Enable</label>
									<input class="form-check-input" type="radio" name="api_enable" id="api_disable" checked="checked" value="0">
									<label class="form-check-label" for="api_disable">Disable</label>
									@endif
								</div>
							</div>
						</div>
						<div class="col-md-12 ">
							<div class="form-group mb-1">
								<div class="btn-list">
									<button type="submit" class="btn btn-primary"><i class="ion-checkmark-circled mr-1"></i>บันทึกการเปลี่ยนแปลง</button>
								</div>
							</div>
						</div>
					</div>
						
				</div>
			</form>
		</div>
	</div>
</div>
<!-- .row -->	

@endsection('content')

@section('scripts')

<!--Jquery Sparkline js-->
<script src="{{URL::asset('assets/plugins/vendors/jquery.sparkline.min.js')}}"></script>

<!-- File uploads js -->
<script src="{{URL::asset('assets/plugins/fileuploads/js/dropify.js')}}"></script>
<script src="{{URL::asset('assets/plugins/fileuploads/js/dropify-demo.js')}}"></script>

<!--Select2 js -->
<script src="{{URL::asset('assets/plugins/select2/select2.full.min.js')}}"></script>
<!-- <script src="{{URL::asset('assets/js/form-elements.js')}}"></script> -->

<!--MutipleSelect js-->
<script src="{{URL::asset('assets/plugins/multipleselect/multiple-select.js')}}"></script>
<script src="{{URL::asset('assets/plugins/multipleselect/multi-select.js')}}"></script>

<!--ckeditor js-->
<script src="{{URL::asset('assets/plugins/tinymce/tinymce.min.js')}}"></script>
<!-- <script src="{{URL::asset('assets/js/formeditor.js')}}"></script> -->

<!-- Notifications js -->
<link href="{{URL::asset('assets/plugins/notify-growl/css/jquery.growl.css')}}" rel="stylesheet" />
<link href="{{URL::asset('assets/plugins/notify-growl/css/notifIt.css')}}" rel="stylesheet" />
<script src="{{URL::asset('assets/plugins/bootbox/bootbox.js')}}"></script>
<script src="{{URL::asset('assets/plugins/notify-growl/js/rainbow.js')}}"></script>
<script src="{{URL::asset('assets/plugins/notify-growl/js/jquery.growl.js')}}"></script>

<!-- validator js -->
<script src="{{URL::asset('assets/plugins/validator/js/jquery.validate.min.js')}}"></script>

<!--- Internal Treeview js -->
<script src="{{URL::asset('assets/plugins/treeview/treeview.js')}}"></script>

<!--- Internal Treeview -->
<link href="{{URL::asset('assets/plugins/treeview/treeview.css')}}" rel="stylesheet" type="text/css" />

<!-- mwz master js css -->
<link rel="stylesheet" href="{{ mix('css/mwz.css') }}">
<script src="{{ mix('js/mwz.js')  }}"></script>

<!-- define group role on js -->
<script type="text/javascript">
	var groups_default_role = [];
	<?php
	foreach($groups as $group){
		if(json_decode($group->default_role)){
			?>
			groups_default_role[<?=$group->id?>]=JSON.parse('<?=$group->default_role?>');
		<?php }} ?>
	</script>
	<!-- module js css -->
	<link rel="stylesheet" href="{{ mix('css/user.css') }}">
	<script src="{{ mix('js/user.js')  }}"></script>

	@endsection