<?php

namespace Modules\User\Http\Controllers;

use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;

class RoleController extends Controller
{

    public static function roles(){
        $roles = [
            "dashboard"=>[
                "dashboard"=>[
                    "view"=>['admin.dashboard.dashboard.index','admin.dashboard.dashboard.datatable_ajax']
                ]
            ],
            "master"=>[
                "master"=>[
                    "view"=>['admin.master.master.index','admin.master.master.datatable_ajax'],
                    "add"=>['admin.master.master.add','admin.master.master.save'],
                    "edit"=>['admin.master.master.edit','admin.master.master.save','admin.master.master.set_status'],
                    "delete"=>['admin.master.master.set_delete']
                ],
                'category'=>[
                    "view"=>['admin.user.category.index','admin.user.category.datatable_ajax'],
                    "add"=>['admin.user.category.add','admin.user.category.save'],
                    "edit"=>['admin.user.category.edit','admin.user.category.save','admin.user.category.set_status'],
                    "delete"=>['admin.user.category.set_delete']
                ]
            ],
            "user"=>[
                "user"=>[
                    "view"=>['admin.user.user.index','admin.user.user.datatable_ajax'],
                    "add"=>['admin.user.user.add','admin.user.user.save'],
                    "edit"=>['admin.user.user.edit','admin.user.user.save','admin.user.user.set_status'],
                    "delete"=>['admin.user.user.set_delete']
                ],
                'group'=>[
                    "view"=>['admin.user.group.index','admin.user.group.datatable_ajax'],
                    "add"=>['admin.user.group.add','admin.user.group.save'],
                    "edit"=>['admin.user.group.edit','admin.user.group.save','admin.user.group.set_status'],
                    "delete"=>['admin.user.group.set_delete']
                ]
            ]
        ];

        return $roles ; ;
    }

    public function allow(){

        $user= Auth::guard('admin')->user();
        $user->role=json_decode($user->role,1);

        $route = Route::currentRouteName();
        $roles = $this->roles() ;
        list($profix,$module,$page,$action) = explode('.',$route) ;
        if($profix=='admin'){
            if(isset($roles[$module][$page])){
                $allow_action = '';
                foreach($roles[$module][$page] as $action => $method){
                    if(in_array($route,$method)){
                        $allow_action=$action;
                        break;
                    }
                }

                if(!empty($allow_action)&&isset($user->role[$module][$page][$allow_action])){
                    return true;
                }else{ 
                    return false;
                }
            }
        }
        if($profix=='api'){
            if(isset($roles[$module][$page])){
                $allow_action = '';
                foreach($roles[$module][$page] as $action => $method){
                    if(in_array($route,$method)){
                        $allow_action=$action;
                        break;
                    }
                }

                if(!empty($allow_action)&&isset($user->role[$module][$page][$allow_action])){
                    return true;
                }else{ 
                    return false;
                }
            }
        }
    }
}
