<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::group( [ 'middleware' => 'auth:admin' ], function(){
    Route::prefix('admin/service')->group(function() {

        Route::get('/index', 'ServiceAdminController@index')->name('admin.service.service.index') ;
        Route::get('/datatable_ajax', 'ServiceAdminController@datatable_ajax')->name('admin.service.service.datatable_ajax') ;

        Route::get('/add', 'ServiceAdminController@form')->name('admin.service.service.add') ;
        Route::get('/edit/{category_id}', 'ServiceAdminController@form')->name('admin.service.service.edit') ;
        Route::post('/save', 'ServiceAdminController@save')->name('admin.service.service.save') ;

        Route::get('/header_service/1', 'ServiceAdminController@header_service')->name('admin.service.header.edit') ;
        Route::post('/header_save', 'ServiceAdminController@header_save')->name('admin.service.header.save') ;


        Route::post('/set_status', 'ServiceAdminController@set_status')->name('admin.service.service.set_status') ;
        Route::post('/set_delete', 'ServiceAdminController@set_delete')->name('admin.service.service.set_delete') ;

        Route::post('/delete_image', 'ServiceAdminController@delete_image')->name('admin.service.service.delete_image') ;
    });
});
