@extends('layouts.app')

@section('styles')

    <!---Tabs css-->
    <link href="{{ URL::asset('assets/plugins/tabs/tabs-style.css') }}" rel="stylesheet" />

    <!--Select2 css -->
    <link href="{{ URL::asset('assets/plugins/select2/select2.min.css') }}" rel="stylesheet" />

    <!-- Datetime Picker css-->
    <link rel="stylesheet" href="{{ URL::asset('assets/plugins/datetime-picker/bootstrap-datetimepicker.min.css') }}">

    <!-- File Uploads css-->
    <link href="{{ URL::asset('assets/plugins/fileuploads/css/dropify.css') }}" rel="stylesheet" type="text/css" />

    <!--Mutipleselect css-->
    <link rel="stylesheet" href="{{ URL::asset('assets/plugins/multipleselect/multiple-select.css') }}">

    <!-- Gallery css -->
    <link href="{{ URL::asset('assets/plugins/gallery/gallery.css') }}" rel="stylesheet">

@endsection

@section('content')

    <!-- page-header -->
    <div class="page-header">
        <ol class="breadcrumb">
            <!-- breadcrumb -->
            <li class="breadcrumb-item"><a href="{{ route('admin.websetting.websetting.edit') }}">หน้าหลัก</a></li>
            <li class="breadcrumb-item active" aria-current="page"><a
                    href="{{ route('admin.service.service.index') }}">การให้บริการ</a></li>
            <li class="breadcrumb-item active" aria-current="page">
                {{ !empty($service->id) ? 'จัดการข้อมูลการให้บริการ' : 'เพิ่มข้อมูลการให้บริการ' }}</li>
        </ol>
    </div>
    <!-- End page-header -->

    <!-- row -->
    <div class="row">
        <div class="col-md-12">
            <form id="service_frm" name="service_frm" method="POST" onsubmit="setSave(); return false;"
                enctype="multipart/form-data">
                @csrf
                <input type="hidden" name="id" value="{{ !empty($service->id) ? $service->id : '0' }}">
                <div class="card">
                    <div class="card-body">
                        <div class="panel panel-primary">
                            <div class="form-group mt-3">
                                @if (empty($service->image_service))
                                    <div class="card">
                                        <div class="card-header pb-0">
                                            <h3 class="mb-0 card-title">อัปโหลดรูปภาพ</h3>
                                        </div>
                                        <div class="card-body">
                                            <input type="file" name="image_service" class="dropify" data-default-file="" />
                                        </div>
                                        <label class="ml-5">ขนาดรูปภาพ 1920 x 940px</label>
                                    </div>
                                @else
                                    <div class="demo-gallery card">
                                        <div class="card-header pb-0">
                                            <div class="card-title">รูปภาพที่อัปโหลด</div>
                                        </div>
                                        <div class="card-body row">
                                            <div class="col-md-5"></div>
                                            <div class="col-md-2">
                                                <ul id="lightgallery" class="list-unstyled">
                                                    <li data-responsive="{{ $service->image_service }}"
                                                        data-src="{{ $service->image_service }}">
                                                        <a href="">
                                                            <img class="img-responsive"
                                                                src="{{ $service->image_service }}" alt="Thumb-1">
                                                        </a>
                                                    </li>
                                                </ul>
                                            </div>
                                            <div class="col-md-5"></div>
                                            <label>ขนาดรูปภาพ 1920 x 940px</label>
                                            <button type="button" onclick="DeleteImage('{{ $service->id }}',1)"
                                                class="btn btn-outline-danger btn-block">ลบรูปภาพ</button>
                                        </div>
                                    </div>
                                @endif
                            </div>
                            <div class="form-group mt-3">
                                @if (empty($service->image_home))
                                    <div class="card">
                                        <div class="card-header pb-0">
                                            <h3 class="mb-0 card-title">อัปโหลดรูปภาพ</h3>
                                        </div>
                                        <div class="card-body">
                                            <input type="file" name="image_home" class="dropify" data-default-file="" />
                                        </div>
                                        <label class="ml-5">ขนาดรูปภาพ 95 x 95px</label>
                                    </div>
                                @else
                                    <div class="demo-gallery card">
                                        <div class="card-header pb-0">
                                            <div class="card-title">รูปภาพที่อัปโหลด</div>
                                        </div>
                                        <div class="card-body row">
                                            <div class="col-md-5"></div>
                                            <div class="col-md-2">
                                                <ul id="lightgallery_2" class="list-unstyled">
                                                    <li data-responsive="{{ $service->image_home }}"
                                                        data-src="{{ $service->image_home }}">
                                                        <a href="">
                                                            <img class="img-responsive" src="{{ $service->image_home }}"
                                                                alt="Thumb-1">
                                                        </a>
                                                    </li>
                                                </ul>
                                            </div>
                                            <div class="col-md-5"></div>
                                            <label>ขนาดรูปภาพ 95 x 95px</label>
                                            <button type="button" onclick="DeleteImage('{{ $service->id }}',2)"
                                                class="btn btn-outline-danger btn-block">ลบรูปภาพ</button>
                                        </div>
                                    </div>
                                @endif
                            </div>
                            {{-- Start Tap --}}
                            <div class="tab_wrapper first_tab">
                                <ul class="tab_list">
                                    <li class="icons-list-item" style="height: 36px;" title="ภาษาไทย"><i
                                            class="flag flag-th"></i></li>
                                    <li class="icons-list-item" style="height: 36px;" title="ภาษาอังกฤษ"><i
                                            class="flag flag-gb"></i></li>
                                </ul>
                                <div class="content_wrapper">
                                    {{-- Tap 1 --}}
                                    <div class="tab_content active">
                                        {{-- Start Input --}}
                                        <div class="alert alert-default" role="alert" title="ภาษาไทย">
                                            <span class="alert-inner--icon"><i class="fe fe-bell"></i></i></span>
                                            <span class="alert-inner--text">คุณกำลังแก้ไขการแสดงผล
                                                <strong>ภาษาไทย</strong></span>
                                        </div>
                                        <div class="form-group" title="หัวข้อ (TH)">
                                            <label class="form-label">หัวข้อ (TH)</label>
                                            <input id="service_name_th" type="text" class="form-control"
                                                name="service_name_th"
                                                value="{{ !empty($service->service_name_th) ? $service->service_name_th : '' }}"
                                                placeholder="ชื่อหัวข้อ">
                                        </div>
                                        <div class="form-group" title="คำอธิบาย (TH)">
                                            <label class="form-label">คำอธิบาย (TH)</label>
                                            <textarea id="detail_category_description_th" class="form-control texteditor"
                                                name="detail_th" rows="4"
                                                placeholder="คำอธิบาย">{{ !empty($service->detail_th) ? $service->detail_th : '' }}</textarea>
                                        </div>
                                        <div class="form-group" title="รายละเอียด (TH)">
                                            <label class="form-label">รายละเอียด (TH)</label>
                                            <textarea id="service_category_description_th" class="form-control texteditor"
                                                name="description_th" rows="4"
                                                placeholder="รายละเอียด">{{ !empty($service->description_th) ? $service->description_th : '' }}</textarea>
                                        </div>
                                        {{-- End Input --}}
                                    </div>
                                    {{-- End Tap 1 --}}
                                    {{-- Tap 2 --}}
                                    <div class="tab_content">
                                        {{-- Start Input --}}
                                        <div class="alert alert-default" role="alert" title="ภาษอังกฤษ">
                                            <span class="alert-inner--icon"><i class="fe fe-bell"></i></i></span>
                                            <span class="alert-inner--text">คุณกำลังแก้ไขการแสดงผล
                                                <strong>ภาษอังกฤษ</strong></span>
                                        </div>
                                        <div class="form-group" title="หัวข้อ (EN)">
                                            <label class="form-label">หัวข้อ (EN)</label>
                                            <input id="service_name_en" type="text" class="form-control"
                                                name="service_name_en"
                                                value="{{ !empty($service->service_name_en) ? $service->service_name_en : '' }}"
                                                placeholder="ชื่อหัวข้อ">
                                        </div>
                                        <div class="form-group" title="คำอธิบาย (EN)">
                                            <label class="form-label">คำอธิบาย (EN)</label>
                                            <textarea id="detail_category_description_en" class="form-control texteditor"
                                                name="detail_en" rows="4"
                                                placeholder="คำอธิบาย">{{ !empty($service->detail_en) ? $service->detail_en : '' }}</textarea>
                                        </div>
                                        <div class="form-group" title="รายละเอียด (EN)">
                                            <label class="form-label">รายละเอียด (EN)</label>
                                            <textarea id="service_category_description" class="form-control texteditor"
                                                name="description_en" rows="4"
                                                placeholder="description">{{ !empty($service->description_en) ? $service->description_en : '' }}</textarea>
                                        </div>
                                        {{-- End Input --}}
                                    </div>
                                    {{-- End Tap 2 --}}
                                </div>
                            </div>
                            {{-- End Tap --}}
                            <div class="card mt-3">
                                <div class="card-body">
                                    <div class="form-group" title="อัปโหลดไฟล์ PDF">
                                        <label class="form-label">อัปโหลดไฟล์ PDF</label>
                                        <div class="input-group file-browser">
                                            <input type="text" class="form-control border-right-0 browse-file"
                                                placeholder="อัปโหลดไฟล์ PDF" readonly>
                                            <label class="input-group-btn mb-0">
                                                <span class="btn btn-primary"> Browse <input type="file" name="file"
                                                        style="display: none;" accept="application/pdf" multiple>
                                                </span>
                                            </label>
                                        </div>
                                    </div>

                                    <div class="form-group" title="ลำดับการแสดงผล">
                                        <label class="form-label">ลำดับการแสดงผล</label>
                                        <input type="text" class="form-control" name="sequence" placeholder="ลำดับการแสดงผล"
                                            value="{{ !empty($service->sequence) ? $service->sequence : '' }}"
                                            onkeypress="return isNumberKey(event)">
                                    </div>

                                    <div class="form-group" title="สถานะ">
                                        <label class="form-label">สถานะ</label>
                                        <div class="form-check form-check-inline">
                                            <input class="form-check-input" type="radio" name="status" id="status_enable"
                                                value="1"
                                                {{ isset($service->status) ? ($service->status == 1 ? 'checked' : '') : 'checked' }}>
                                            <label class="form-check-label" for="status_enable">เปิด</label>
                                        </div>
                                        <div class="form-check form-check-inline">
                                            <input class="form-check-input" type="radio" name="status" id="status_disable"
                                                value="0"
                                                {{ isset($service->status) ? ($service->status == 0 ? 'checked' : '') : '' }}>
                                            <label class="form-check-label" for="status_disable">ปิด</label>
                                        </div>
                                    </div>

                                    <div class="form-group mt-5">
                                        <div class="btn-list">
                                            <button type="submit" class="btn btn-primary"><i
                                                    class="ion-checkmark-circled mr-1"></i>{{ !empty($service->id) ? 'บันทึกการเปลี่ยนแปลง' : 'เพิ่มรายการใหม่' }}</button>
                                            <button onclick="mwz_redirect('{{ route('admin.service.service.index') }}');"
                                                type="button" class="btn btn-warning"><i class="fa fa-undo"
                                                    aria-hidden="true"></i>ยกเลิก</button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
    <!-- .row -->
    <script>
        $(document).ready(function() {
            lightGallery(document.getElementById('lightgallery_2'));
        });
    </script>

@endsection('content')

@section('scripts')

    <!--Jquery Sparkline js-->
    <script src="{{ URL::asset('assets/plugins/vendors/jquery.sparkline.min.js') }}"></script>

    <!-- File uploads js -->
    <script src="{{ URL::asset('assets/plugins/fileuploads/js/dropify.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/fileuploads/js/dropify-demo.js') }}"></script>

    <!--Select2 js -->
    <script src="{{ URL::asset('assets/plugins/select2/select2.full.min.js') }}"></script>
    <!-- <script src="{{ URL::asset('assets/js/form-elements.js') }}"></script> -->

    <!--MutipleSelect js-->
    <script src="{{ URL::asset('assets/plugins/multipleselect/multiple-select.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/multipleselect/multi-select.js') }}"></script>

    <!--ckeditor js-->
    <script src="{{ URL::asset('assets/plugins/tinymce/tinymce.min.js') }}"></script>
    <!-- <script src="{{ URL::asset('assets/js/formeditor.js') }}"></script> -->

    <!-- Datetimepicker js -->
    <script src="{{ URL::asset('assets/plugins/datetime-picker/moment.min.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/datetime-picker/bootstrap-datetimepicker.min.js') }}"></script>

    <!-- Notifications js -->
    <link href="{{ URL::asset('assets/plugins/notify-growl/css/jquery.growl.css') }}" rel="stylesheet" />
    <link href="{{ URL::asset('assets/plugins/notify-growl/css/notifIt.css') }}" rel="stylesheet" />
    <script src="{{ URL::asset('assets/plugins/bootbox/bootbox.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/notify-growl/js/rainbow.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/notify-growl/js/jquery.growl.js') }}"></script>

    <!-- Gallery js -->
    <script src="{{ URL::asset('assets/plugins/gallery/picturefill.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/gallery/lightgallery.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/gallery/lg-pager.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/gallery/lg-zoom.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/gallery/lg-hash.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/gallery/lg-share.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/gallery/gallery.js') }}"></script>

    <!-- validator js -->
    <script src="{{ URL::asset('assets/plugins/validator/js/jquery.validate.min.js') }}"></script>

    <!-- Tabs js -->
    <script src="{{ URL::asset('assets/plugins/tabs/jquery.multipurpose_tabcontent.js') }}"></script>
    <!-- <script src="{{ URL::asset('assets/plugins/tabs/tabs.js') }}"></script> -->

    <!-- mwz master js css -->
    <link rel="stylesheet" href="{{ mix('css/mwz.css') }}">
    <script src="{{ mix('js/mwz.js') }}"></script>

    <!-- module js css -->
    <link rel="stylesheet" href="{{ mix('css/service.css') }}">
    <script src="{{ mix('js/service.js') }}"></script>
    <script>
        //NumberKey ลำดัการแสดงผล
        function isNumberKey(evt) {
            var charCode = (evt.which) ? evt.which : event.keyCode
            if (charCode > 31 && (charCode < 48 || charCode > 57))
                return false;
            return true;
        }
    </script>

@endsection
