$(document).ready(function () {
    // init for service
    initDatatable();

    //tab inti
    if ($('.first_tab').length > 0) {
        $(".first_tab").champ();
    }
});

$(function () {
    'use strict'; // Datepicker

    $(function () {
        $('#datetimepicker').datetimepicker();
    });
});

$(document).on('change', ':file', function () {
    var input = $(this),
        numFiles = input.get(0).files ? input.get(0).files.length : 1,
        label = input.val().replace(/\\/g, '/').replace(/.*\//, '');
    input.trigger('fileselect', [numFiles, label]);
});

// Upload file
$(document).ready(function () {
    $(':file').on('fileselect', function (event, numFiles, label) {

        var input = $(this).parents('.input-group').find(':text'),
            log = numFiles > 1 ? numFiles + ' files selected' : label;

        if (input.length) {
            input.val(log);
        } else {
            //if (log) alert(log);
        }

    });
});
// =========================  service =========================== //

initDatatable = function () {
    if ($('#service-datatable').length > 0) {
        oTable = $('#service-datatable').DataTable({
            "processing": true,
            "serverSide": true,
            "stateSave": true,
            "ajax": {
                "url": "/admin/service/datatable_ajax"
            },
            "columns": [
                { "data": "sequence" },
                { "data": "image" },
                { "data": "service_name_th" },
                { "data": "updated_at" },
                { "data": "action", orderable: false, searchable: false }
            ]
        });
    }
}

setReloadDataTable = function () {
    $('#service-datatable').DataTable().ajax.reload(null, false);
}


setSave = function () {
    event.preventDefault();
    tinyMCE.triggerSave();

    var frm_data = new FormData($('#service_frm')[0]);

    $.ajax({
        url: "/admin/service/save",
        type: "POST",
        contentType: false,
        data: frm_data,
        processData: false,
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        success: function (resp) {
            if (resp.success) {
                mwz_noti('success', resp.msg);
                if (resp.code == 200) {
                    JsReload(1500);
                } else {
                    JsRedirect('/admin/service/index', 1500);
                }
            } else {
                mwz_noti('error', resp.msg);
            }
        },
    });
}



setUpdateStatus = function (id, status) {
    event.preventDefault();
    let _token = $('meta[name="csrf-token"]').attr('content');

    $.ajax({
        url: "/admin/service/set_status",
        type: "POST",
        data: {
            id: id,
            status: status,
            _token: _token
        },
        success: function (resp) {
            if (resp.success) {
                mwz_noti('success', resp.msg);
                setReloadDataTable();
            } else {
                mwz_noti('error', resp.msg);
                setReloadDataTable();
            }
        },
    });
}

setDelete = function (id) {
    bootbox.confirm({
        message: "คุณต้องการลบข้อมูลบริการหรือไม่?",
        buttons: {
            confirm: {
                label: 'OK',
                className: 'btn-success'
            },
            cancel: {
                label: 'Cancel',
                className: 'btn-danger'
            }
        },
        callback: function (result) {
            if (result) {
                event.preventDefault();
                let _token = $('meta[name="csrf-token"]').attr('content');

                $.ajax({
                    url: "/admin/service/set_delete",
                    type: "POST",
                    data: {
                        id: id,
                        status: status,
                        _token: _token
                    },
                    success: function (resp) {
                        if (resp.success) {
                            mwz_noti('success', resp.msg);
                            setReloadDataTable();
                        } else {
                            mwz_noti('error', resp.msg);
                            setReloadDataTable();
                        }
                    },
                });
            }
        }
    });
}

// =========================  service header =========================== //
setSaveHeader = function () {
    event.preventDefault();
    tinyMCE.triggerSave();

    var frm_data = new FormData($('#service_frm_header')[0]);

    $.ajax({
        url: "/admin/service/header_save",
        type: "POST",
        contentType: false,
        data: frm_data,
        processData: false,
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        beforeSend: function (xhr) {

            if ($("#service_frm_header").valid()) {
                return $("#service_frm_header").valid();
            } else {
                mwz_noti('error', resp.msg);
                return $("#service_frm_header").valid();
            }
        },
        success: function (resp) {
            if (resp.success) {
                mwz_noti('success', resp.msg);
                window.location.href = '/admin/service/header_service/1';
            } else {
                mwz_noti('error', resp.msg);
            }
        },
    });

}

function JsReload(time) {
    setInterval(function () {
        window.location.reload();
    }, time);
}

function JsRedirect(url, time) {
    setInterval(function () {
        window.location.replace(url);
    }, time);
}


DeleteImage = function (id, type) {
    bootbox.confirm({
        message: "ยืนยันการลบ? <br> เมื่อดำเนินการแล้วจะไม่สามารถย้อนกลับได้!",
        buttons: {
            confirm: {
                label: 'ยืนยัน',
                className: 'btn-success'
            },
            cancel: {
                label: 'ยกเลิก',
                className: 'btn-danger'
            }
        },
        callback: function (result) {
            if (result) {
                let _token = $('meta[name="csrf-token"]').attr('content');
                $.ajax({
                    url: "/admin/service/delete_image",
                    type: "POST",
                    data: {
                        id: id,
                        type: type,
                        _token: _token
                    },
                    success: function (resp) {
                        if (resp.success) {
                            mwz_noti('success', resp.msg);
                            JsReload(1000);
                        } else {
                            mwz_noti('error', resp.msg);
                        }
                    },
                });
            }
        }
    });
}