<?php

namespace Modules\Service\Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class ServiceDatabaseSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        Model::unguard();
        $now = DB::raw('NOW()');

        DB::statement("ALTER TABLE services AUTO_INCREMENT=1");
        DB::table('services')->truncate();
        DB::table('services')->insert([
            'id'=> 1,
            'service_header_th' => 'บริการของเรา',
            'service_header_en' => 'OUR SERVICES',
            'service_name_th' => 'service name thai',
            'service_name_en' => 'service name english',
            'detail_th'=> 'detail service thai',
            'detail_en'=>'detail service english',
            'description_th'=>'service description thai',
            'description_en'=>'service description english',
            'image'=>'service.jpg',
            'file'=>'',
            'sequence'=>1,
            'status' =>1,
            'publish_at' =>$now,
            'created_at'=>$now,
            'updated_at'=>$now
        ]);
    }
}
