<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Kalnoy\Nestedset\NestedSet;

class CreateServiceTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('services', function (Blueprint $table) {
            $table->increments('id');
            $table->string('service_name_th', 250);
            $table->string('service_name_en', 250);
            $table->text('detail_th');
            $table->text('detail_en');
            $table->text('description_th');
            $table->text('description_en');
            $table->string('image_service', 250)->nullable();
            $table->string('image_home', 250)->nullable();
            $table->string('file', 250)->nullable();
            $table->tinyInteger('sequence')->comment('ลำดับในการแสดงผล');
            $table->boolean('status')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('service');
    }
}
