<?php

namespace Modules\Page\Http\Controllers;

use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Routing\Redirector;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\DB;
use Modules\Frontend\Entities\Content;
use Yajra\DataTables\Facades\DataTables;
use Modules\Page\Entities\Pages;

class PageAdminController extends Controller
{


    /**
     * Function : __construct check admin login
     * Dev : pop
     * Update Date : 14 Jul 2021
     * @param Get
     * @return if not login redirect to /admin
     */
    public function __construct()
    {
        $this->middleware('auth:admin');
    }

    /**
     * Function : add con$contactus form
     * Dev : pop
     * Update Date : 04 August 2021
     * @param GET
     * @return category form view
     */
    public function form()
    {
        $content_id_2 = Content::where('id', 2)->first();
        $content_id_3 = Content::where('id', 3)->first();
        $content_id_4 = Content::where('id', 4)->first();
        $content_id_5 = Content::where('id', 5)->first();

        return view('page::form', ['content_id_2' => $content_id_2, 'content_id_3' => $content_id_3, 'content_id_4' => $content_id_4, 'content_id_5' => $content_id_5]);
    }


    /**
     * Function :  member save 
     * Dev : Dave
     * Update Date : 08 jul 2021
     * @param POST
     * @return json response status
     */
    public function save(Request $request)
    {
        $attributes_1 = [
            "content_data_th" => mwz_setTextString($request->get('content_id_2_th')),
            "content_data_en" => mwz_setTextString($request->get('content_id_2_en')),
        ];
        $attributes_2 = [
            "content_data_th" => mwz_setTextString($request->get('content_id_3_th')),
            "content_data_en" => mwz_setTextString($request->get('content_id_3_en')),
        ];
        $attributes_3 = [
            "content_data_th" => mwz_setTextString($request->get('content_id_4_th')),
            "content_data_en" => mwz_setTextString($request->get('content_id_4_en')),
        ];
        $attributes_4 = [
            "content_data_th" => mwz_setTextString($request->get('content_id_5_th')),
            "content_data_en" => mwz_setTextString($request->get('content_id_5_en')),
        ];

        $response_1 = Content::where('id', 2)->update($attributes_1);
        $response_2 = Content::where('id', 3)->update($attributes_2);
        $response_3 = Content::where('id', 4)->update($attributes_3);
        $response_4 = Content::where('id', 5)->update($attributes_4);
        $resp = ['success' => 1, 'code' => 200, 'msg' => 'อัปเดตข้อมูลสำเร็จ'];

        return response()->json($resp);
    }
}
