// redirect to page
mwz_redirect=function(url){
    window.location.href = url ;
}
// form validation
mwz_frm_validate=function(selector,rules, messages){
     $(selector).validate( {
                    rules: rules,
                    messages: messages,
                    errorPlacement: function ( error, element ) {
                        error.addClass( "invalid-feedback" );
                        if ( element.prop( "type" ) === "checkbox" ) {
                            error.insertAfter( element.next( "label" ) );
                        } else {
                            error.insertAfter( element );
                        }
                    },
                    errorElement: 'div',
                    errorClass: 'invalid-feedback',
                    highlight: function ( element, errorClass, validClass ) {
                        $( element ).addClass( "is-invalid" ).removeClass( "is-valid" );
                    },
                    unhighlight: function (element, errorClass, validClass) {
                        $( element ).addClass( "is-valid" ).removeClass( "is-invalid" );
                    }
                } );

}

// mwz_global_load
mwz_global_loading=function(show=1){
    if(show){
        $('#global-loader').fadeIn(100);
    }else{
        $('#global-loader').fadeOut(100);
    }
}

// notification
mwz_noti=function(type,msg) {
    console.log('mwz_noti'+type+" "+msg);
    switch(type){
        case 'success':
            return $.growl.notice({
            title: "success",
            message: msg
        });
        break;
        case 'warning':
            return $.growl.warning({
            title: "warning",
            message: msg
        });
        break;
        case 'error':
            return $.growl.error({
            title: "error",
            message: msg
        });
        break;
        default:
            return $.growl({
                title: "notice",
                message: msg
            });
        break;
    }
};


(function($) {

    if($(".texteditor").length > 0){
        
        tinymce.init({
            selector:"textarea.texteditor",
            skin: "lightgray",
            themes: "modern",
            inline:false,
            height:250,
            mode:"textareas",
            relative_urls:true,
            extended_valid_elements:"i[class|style|title],iframe[src|frameborder|style|scrolling|class|width|height|name|align]",
            fontsize_formats:"8pt 10pt 11pt 12pt 13pt 14pt 15pt 16pt 17pt 18pt 19pt 20pt 21pt 22pt 23pt 24pt 25pt 26pt 28pt 30pt 32pt 34pt 36pt",
            file_browser_callback:elFinderBrowser,
            plugins: [
                "advlist autoresize autolink lists link image charmap print preview anchor emoticons",  
                "searchreplace visualblocks code fullscreen",
                "insertdatetime media table contextmenu paste textcolor hr "
            ],
            autoresize_overflow_padding:5,
            autoresize_min_height:250,
            autoresize_max_height:500,
            extended_valid_elements:'i[class|style|title],span[class|style|title],a[accesskey|charset|class|contenteditable|contextmenu|coords|dir|download|draggable|dropzone|hidden|href|hreflang|id|lang|media|name|rel|rev|shape|spellcheck|style|tabindex|target|title|translate|type|onclick|onfocus|onblur],marquee',
            toolbar1:" insertfile bootstrap ",
            toolbar2:" undo redo | bold italic underline | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link image media ",
            toolbar3:" forecolor backcolor | formatselect styleselect fontselect fontsizeselect | emoticons fontawesome "
        });

    }

    if($(".texteditor").length > 0){
        // Select2 by showing the search
        $('.select2-show-search').select2({
            minimumResultsForSearch: ''
        });
    }
    
})(jQuery);


function elFinderBrowser (field_name, url, type, win) {
    tinymce.activeEditor.windowManager.open({
        file: '/admin/elfinder/tinymce4',// use an absolute path!
        title: 'File Management',
        width: 900,
        height: 450,
        resizable: 'yes'
        },{
            setUrl: function (url) {
            win.document.getElementById(field_name).value = url;
        }
    });
    return false;
}