<?php

namespace Modules\Mwz\Http\Controllers;

use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;

class MwzController extends Controller
{
    public static function flat_categories($categories)
    {
        $traverse = function ($categories, $prefix = '-',$level=0, &$result=[]) use (&$traverse) {
            foreach ($categories as  $category) {
                $category->level = $level ; 

                if($level>0){
                    $show_prefix = str_pad('',$level,$prefix); 
                    $category->name =  $show_prefix.' '.$category->name;
                }
                if(!empty($category->children)){
                    $new_category = $category ;
                    unset($new_category->children) ;
                    $result[$category->id] = $new_category ;
                    $traverse($category->children,'-',$level+1,$result);
                }else{
                    $result[$category->id] = $category ;
                }
            }
            return $result ;
        };

        return $traverse ;
    }

    
}
