<?php

use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Session;
use Illuminate\Pagination\Paginator;
use Illuminate\Support\Facades\Mail;
use Modules\Banner\Entities\Banners;
use Modules\AboutUs\Entities\AboutTeams;
use Modules\AboutUs\Entities\AboutUs;
use Modules\ContactUs\Emails\SendMailContactUs;
use Modules\Frontend\Entities\BlogCategories;
use Modules\Frontend\Entities\Blogs;
use Modules\Frontend\Entities\Content;
use Modules\Frontend\Entities\Cookie;
use Modules\Frontend\Entities\Menu;
use Modules\Frontend\Entities\Services;
use Modules\Frontend\Entities\Websetting;

function mwz_setFlatCategory($categories)
{

    $traverse = function ($categories, $prefix = '-', $level = 0, &$result = []) use (&$traverse) {
        foreach ($categories as  $category) {
            $category->level = $level;

            if ($level > 0) {
                $show_prefix = str_pad('', $level, $prefix);
                $category->name_th =  $show_prefix . ' ' . $category->name_th;
            }
            if (!empty($category->children)) {
                $new_category = $category;
                unset($new_category->children);
                $result[$category->id] = $new_category;
                $traverse($category->children, '-', $level + 1, $result);
            } else {
                $result[$category->id] = $category;
            }
        }
        return $result;
    };

    return $traverse($categories);
}


function mwz_getTextString($str)
{
    return htmlspecialchars_decode(html_entity_decode($str));
}

function mwz_setTextString($str)
{
    return htmlentities(htmlspecialchars($str));
}
function GetMenu($type)
{
    $lang = session()->get('frontend_lang');
    $menu = Menu::where('status', 1)
        ->select('id', 'name_' . (($lang == '') ? 'en' : $lang) . ' as name',  'slug')
        ->where('type', $type)
        ->orderBy('sequence')
        ->get();
    return $menu;
}
function GetMenuBlogCategory()
{
    $lang = session()->get('frontend_lang');
    $blogcategory = BlogCategories::where('status', 1)
        ->select('name_' . (($lang == '') ? 'en' : $lang) . ' as name', 'image', 'id')
        ->orderBy('id')
        ->get();

    return $blogcategory;
}
function GetBanner($category_id)
{
    $lang = session()->get('frontend_lang');
    $banner = DB::table('banners')
        ->select(
            'description_' . (($lang == '') ? 'en' : $lang) . ' as description',
            'image',
            'link_youtube as link',
            'link_destination',
            'status'
        )
        ->where('status', 1)
        ->where('category_id', $category_id)
        ->orderBy('sequence')
        ->orderBy('updated_at')
        ->get();
    return $banner;
}

function GetCountBanner()
{
    $countbanner = Banners::count();
    return $countbanner;
}
function GetWebSetTing($id)
{
    $lang = session()->get('frontend_lang');
    $web = Websetting::where('id', $id)
        ->select(
            'companyname_' . (($lang == '') ? 'en' : $lang) . ' as companyname',
            'privacy_' . (($lang == '') ? 'en' : $lang) . ' as privacy',
            'link_login',
            'fb',
            'line',
            'youtube',
            'email',
            'logo_header',
            'logo_footer',
            'meta_title',
            'meta_keywords',
            'meta_description',
            'seo_image',
            'google_analytics'
        )
        ->first();
    return $web;
}
function GetAboutUs($id)
{
    $lang = session()->get('frontend_lang');
    $about = AboutUs::where('id', $id)
        ->select(
            'image_story',
            'about_header_' . (($lang == '') ? 'en' : $lang) . ' as about_header',
            'description_story_' . (($lang == '') ? 'en' : $lang) . ' as description_story',
            'file_about1',
            'file_about2',
            'description_vision_' . (($lang == '') ? 'en' : $lang) . ' as description_vision',
            'description_team_' . (($lang == '') ? 'en' : $lang) . ' as description_team',
            'description_partner_' . (($lang == '') ? 'en' : $lang) . ' as description_partner'
        )
        ->first();
    return $about;
}
function GetCountTeam()
{
    $countteam = AboutTeams::count();
    return $countteam;
}
function GetAboutTeam($status)
{
    $lang = session()->get('frontend_lang');
    $teams = DB::table('about_teams')
        ->select(
            'image',
            'fullname_' . (($lang == '') ? 'en' : $lang) . ' as fullname',
            'position'
        )
        ->where('status', $status)
        ->orderBy('sequence')
        ->orderBy('updated_at')
        ->paginate(12);
    return $teams;
}
function GetServiceHome()
{
    $lang = session()->get('frontend_lang');
    $service = Services::where('status', 1)
        ->select(
            'id',
            'service_name_' . (($lang == '') ? 'en' : $lang) . ' as name',
            'detail_' . (($lang == '') ? 'en' : $lang) . ' as detail',
            'description_' . (($lang == '') ? 'en' : $lang) . ' as description',
            'image_home',
            'file',
            'sequence'
        )
        ->orderBy('sequence')
        ->get();
    //->paginate(10);
    return $service;
}
function GetServiceDetail($id)
{
    $lang = session()->get('frontend_lang');
    $service_detail = Services::where('id', $id)
        ->select(
            'id',
            'service_name_' . (($lang == '') ? 'en' : $lang) . ' as name',
            'detail_' . (($lang == '') ? 'en' : $lang) . ' as detail',
            'description_' . (($lang == '') ? 'en' : $lang) . ' as description',
            'image_service',
            'file',
            'sequence'
        )
        ->first();
    return $service_detail;
}
function GetNameCategories($category_id)
{
    $lang = session()->get('frontend_lang');
    $blog_categories = BlogCategories::where('id', $category_id)
        ->select('name_' . (($lang == '') ? 'en' : $lang) . ' as name')
        ->where('status', 1)
        ->first();
    return $blog_categories;
}
function GetBlogHome($id)
{
    $lang = session()->get('frontend_lang');
    $blog_home = Blogs::where('status', 1)
        ->select(
            'id',
            'name_' . (($lang == '') ? 'en' : $lang) . ' as name',
            'image',
            'status'
        )
        ->where('category_id', $id)
        ->orderByDesc('sequence')
        ->limit(6)
        ->get();
    return $blog_home;
}
function GetBlogCategories($category_id)
{
    $lang = session()->get('frontend_lang');
    $blog = DB::table('blogs')
        ->join('blog_categories', 'blogs.category_id', '=', 'blog_categories.id')
        ->select(
            'blogs.id',
            'blog_categories.name_' . (($lang == '') ? 'en' : $lang) . ' as name_categories',
            'blogs.category_id',
            'blogs.name_' . (($lang == '') ? 'en' : $lang) . ' as name',
            'blogs.image',
            'blogs.description_' . (($lang == '') ? 'en' : $lang) . ' as description',
            'blogs.image_youtube',
            'blogs.link',
            'blogs.file'
        )
        ->where('blogs.category_id', $category_id)
        ->orderBy('sequence')
        ->paginate(9);
    return $blog;
}

function send_mail_contact($content, $email)
{
    $mail = new SendMailContactUs(['content' => $content]);
    Mail::to($email)->send($mail);
}

function setLanguage()
{
    if (Session::has('frontend_lang')) {
        $frontend_lang = Session::get('frontend_lang');
        App::setLocale($frontend_lang);
    } else {
        App::setLocale('th');
        $locale = 'th';
    }
}

function get_conotent($id)
{
    $lang = session()->get('frontend_lang');
    $content = Content::where('id', $id)
        ->select('id', 'content_data_' . (($lang == '') ? 'en' : $lang) . ' as content')
        ->first();

    return $content;
}

/* Check File In Server */
function CheckFileInServer($file)
{
    if (file_exists($_SERVER['DOCUMENT_ROOT'] . parse_url($file, PHP_URL_PATH))) {
        return true;
    } else {
        return false;
    }
}

function get_content($id)
{
    $lang = session()->get('frontend_lang');
    $content = Content::where('id', $id)
        ->select('id', 'content_data_' . (($lang == '') ? 'en' : $lang) . ' as content')
        ->first();

    return $content;
}

function get_content_back($id)
{
    $content = Content::where('id', $id)->first();

    return $content;
}

function mwz_convertMonth($date_time)
{
    setLanguage();
    $date = explode("-", explode(" ", $date_time)[0]);
    if (session()->get('frontend_lang') == "" || session()->get('frontend_lang') == 'th') {
        $new_date = $date[2] . ' ' . __('frontend::lang.' . $date[1]) . ' ' . ($date[0] + 543);
    } else {
        $new_date =  __('frontend::lang.' . $date[1]) . ' ' . $date[2] . ' ' . $date[0];
    }

    return $new_date;
}

function get_ip_address()
{
    foreach (array('HTTP_CLIENT_IP', 'HTTP_X_FORWARDED_FOR', 'HTTP_X_FORWARDED', 'HTTP_X_CLUSTER_CLIENT_IP', 'HTTP_FORWARDED_FOR', 'HTTP_FORWARDED', 'REMOTE_ADDR') as $key) {
        if (array_key_exists($key, $_SERVER) === true) {
            foreach (explode(',', $_SERVER[$key]) as $ip) {
                $ip = trim($ip); // just to be safe
                if (filter_var($ip, FILTER_VALIDATE_IP, FILTER_FLAG_NO_PRIV_RANGE | FILTER_FLAG_NO_RES_RANGE) !== false) {
                    return $ip;
                }
            }
        }
    }
    return request()->ip(); // it will return server ip when no client ip found
}

function get_cookie($ip)
{
    $cookie = Cookie::where('ip_address', $ip)->first();
    return $cookie;
}
