$(document).ready(function() {
    // init for table all
    initDatatable();
    initDatamenu();

    //tab inti
    if ($('.first_tab').length > 0) {
        $(".first_tab").champ();
    }
});


// =========================  menugroup =========================== //

initDatatable = function() {
    if ($('#menugroup-datatable').length > 0) {
        oTable = $('#menugroup-datatable').DataTable({
            "processing": true,
            "serverSide": true,
            "stateSave": true,
            "ajax": {
                "url": "/admin/menugroup/datatable_ajax"
            },
            "columns": [
                { "data": "id", orderable: false, searchable: false },
                { "data": "name", orderable: false, searchable: false },
                { "data": "updated_at", orderable: false, searchable: false },
                { "data": "action", orderable: false, searchable: false }
            ]
        });
    }
}
setReloadDataTable = function() {
    $('#menugroup-datatable').DataTable().ajax.reload(null, false);
    $('#menu-datatable').DataTable().ajax.reload(null, false);
}

setUpdateStatus = function(id, status) {
    event.preventDefault();
    let _token = $('meta[name="csrf-token"]').attr('content');

    $.ajax({
        url: "/admin/menugroup/set_status",
        type: "POST",
        data: {
            id: id,
            status: status,
            _token: _token
        },
        success: function(resp) {
            if (resp.success) {
                mwz_noti('success', resp.msg);
                setReloadDataTable();
            } else {
                mwz_noti('error', resp.msg);
                setReloadDataTable();
            }
        },
    });
}


setSave = function() {
    event.preventDefault();
    tinyMCE.triggerSave();
    var frm_data = new FormData($('#menu_frm')[0]);
    $.ajax({
        url: "/admin/menugroup/save",
        type: "POST",
        contentType: false,
        data: frm_data,
        processData: false,
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        beforeSend: function(xhr) {

            if ($("#menu_frm").valid()) {
                return $("#menu_frm").valid();
            } else {
                mwz_noti('error', resp.msg);
                return $("#menu_frm").valid();
            }
        },
        success: function(resp) {
            if (resp.success) {
                mwz_noti('success', resp.msg);
                window.location.href = '/admin/menugroup/';
            } else {
                mwz_noti('error', resp.msg);
            }
        },
    });

}

// =========================  menu =========================== //

initDatamenu = function() {
    if ($('#menu-datatable').length > 0) {
        oTable = $('#menu-datatable').DataTable({
            "processing": true,
            "serverSide": true,
            "stateSave": true,
            "ajax": {
                "url": "/admin/menu/datatable_ajax"
            },
            "columns": [
                { "data": "sequence" },
                { "data": "name_th" },
                { "data": "name_en" },
                { "data": "updated_at" },
                { "data": "actionEdit", orderable: false, searchable: false }
            ]
        });
    }
}

setUpdateStatusMenu = function(id, status) {
    event.preventDefault();
    let _token = $('meta[name="csrf-token"]').attr('content');

    $.ajax({
        url: "/admin/menu/set_status",
        type: "POST",
        data: {
            id: id,
            status: status,
            _token: _token
        },
        success: function(resp) {
            if (resp.success) {
                mwz_noti('success', resp.msg);
                setReloadDataTable();
            } else {
                mwz_noti('error', resp.msg);
                setReloadDataTable();
            }
        },
    });
}

setSaveMenu = function() {
    event.preventDefault();
    tinyMCE.triggerSave();
    var frm_data = new FormData($('#menu_frm')[0]);
    $.ajax({
        url: "/admin/menu/save",
        type: "POST",
        contentType: false,
        data: frm_data,
        processData: false,
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        beforeSend: function(xhr) {

            if ($("#menu_frm").valid()) {
                return $("#menu_frm").valid();
            } else {
                mwz_noti('error', resp.msg);
                return $("#menu_frm").valid();
            }
        },
        success: function(resp) {
            if (resp.success) {
                mwz_noti('success', resp.msg);
                window.location.href = '/admin/menu/';
            } else {
                mwz_noti('error', resp.msg);
            }
        },
    });

}