<?php

namespace Modules\Menu\Http\Controllers;

use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
// use Illuminate\Support\Facades\Auth;
use Illuminate\Routing\Redirector;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\DB;

use Yajra\DataTables\Facades\DataTables;
use Modules\Mwz\Http\Controllers\MwzController;
use Modules\Menu\Entities\Menus ;
use Modules\Menu\Entities\MenuGroups ;
use Modules\User\Http\Controllers\RoleController;

class MenuSlugController extends Controller
{
    /**
    * Function : __construct check admin login
    * Dev : dave
    * Update Date : 13 jul 2021
    * @param Get
    * @return if not login redirect to /admin
    */
    // public function __construct()
    // {

    //     $this->middleware('auth:admin');

    //     $this->middleware(function ($request, $next) {
    //         $role = new RoleController();
    //         if($role->allow()){
    //             return $next($request);
    //         }else{ 
    //             redirect()->route('admin.dashboard.dashboard.index')->send();
    //         }

    //     });
    // }

    /**
     * Display a listing of the resource.
     * @return Renderable
     */
    public function index()
    {
        $menus = Menus::all();
        return view('menu::slug')->with('menus', $menus);
    }

    
    /**
    * Function : menu datatable ajax response 
    * Dev : Dave
    * Update Date : 13 jul 2021
    * @param Get
    * @return json of menu 
    */
    public function urlSlug(){
        
    }
    
    /**
    * Function : add menu form
    * Dev : Dave
    * Update Date : 13 jul 2021
    * @param GET
    * @return category form view
    */
    public function form($slug)
    {
        $getid = new Menus;
        foreach ($getid->select('menu.id')->where('slug_en',$slug)->get() as $item) {
            $id = $item->id;
        }
        $menu = [] ;
        if(!empty($slug)){
            $getmenu = Menus::find($id) ;
            $menu = MenuGroups::find($id) ;
            $menu->name = mwz_getTextString($menu->name) ;
            $menu->description = mwz_getTextString($menu->description) ;
        }
        return view('menu::slugform',['menu'=>$menu,'getmenu'=>$getmenu]);
    }
}
