<?php

namespace Modules\Menu\Http\Controllers;

use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
// use Illuminate\Support\Facades\Auth;
use Illuminate\Routing\Redirector;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\DB;

use Yajra\DataTables\Facades\DataTables;
use Modules\Mwz\Http\Controllers\MwzController;
use Modules\Menu\Entities\MenuGroups ;
use Modules\User\Http\Controllers\RoleController;

class MenuGroupController extends Controller
{
    /**
    * Function : __construct check admin login
    * Dev : dave
    * Update Date : 13 jul 2021
    * @param Get
    * @return if not login redirect to /admin
    */
    // public function __construct()
    // {

    //     $this->middleware('auth:admin');

    //     $this->middleware(function ($request, $next) {
    //         $role = new RoleController();
    //         if($role->allow()){
    //             return $next($request);
    //         }else{ 
    //             redirect()->route('admin.dashboard.dashboard.index')->send();
    //         }

    //     });
    // }

    /**
     * Display a listing of the resource.
     * @return Renderable
     */
    public function index()
    {
        return view('menu::index');
    }

    /**
    * Function : menu datatable ajax response 
    * Dev : Dave
    * Update Date : 13 jul 2021
    * @param Get
    * @return json of menu 
    */
    public function datatable_ajax(Request $request){
        if ($request->ajax()) {
            //init datatable
            $dt_name_column = array('name', 'updated_at');
            $dt_order_column = $request->get('order')[0]['column'];
            $dt_order_dir = $request->get('order')[0]['dir'];
            $dt_start = $request->get('start');
            $dt_length = $request->get('length');
            $dt_search = $request->get('search')['value'];

            // create menu object 
            $o_menu = new MenuGroups;

            // add search query if have search from datable
            if(!empty($dt_search)){
                $o_menu->where('name', 'like', "%".$dt_search."%")
                         ->where('updated_at', 'like', "%".$dt_search."%");
            }

            // set query order & limit from datatable
            $o_menu->orderBy($dt_name_column[$dt_order_column], $dt_order_dir)
                        ->offset($dt_start)
                        ->limit($dt_length);            

            // query menu as tree resule
            $menu = $o_menu->get(); 

            // count all category
            $dt_total = $menu->count();

            // prepare datatable for resonse
            $tables = Datatables::of($menu)
                    ->addIndexColumn()
                    ->setRowId('id')
                    ->setRowClass('master_row')
                    ->setTotalRecords($dt_total)
                    ->editColumn('updated_at', function ($record) {
                        return $record->updated_at->format('Y-m-d H:i:s'); 
                      })
                    ->addColumn('action', function ($record) {
                        $action_btn = '<div class="btn-list">';

                        if($record->status==1){
                            $action_btn .= '<a onclick="setUpdateStatus('.$record->id.',0)" href="javascript:void(0);" class="btn btn-outline-success"><i class="fa fa-check"></i></a></a>';
                        }else{
                            $action_btn .=  '<a onclick="setUpdateStatus('.$record->id.',1)" href="javascript:void(0);"  class="btn btn-outline-warning"><i class="fa fa-times"></i></a></a>';
                        }

                        $action_btn .= '<a href="'.route('admin.menu.menugroup.edit',$record->id).'" class="btn btn-outline-primary"><i class="fa fa-pencil"></i></a></a>';

                        $action_btn .= '<a onclick="setDelete('.$record->id.')" href="javascript:void(0);" class="btn btn-outline-danger"><i class="fa fa-trash"></i></a></a>';

                        $action = '</div>' ;

                        return $action_btn ;
                      })
                    ->escapeColumns([])
                    ;

            // response datatable json
            return $tables->make(true) ;
        }
    }
    
    /**
    * Function : add menu form
    * Dev : Dave
    * Update Date : 13 jul 2021
    * @param GET
    * @return category form view
    */
    public function form($id=0)
    {
        $menu = [] ;
        if(!empty($id)){
            $menu = MenuGroups::find($id) ;
            $menu->name = mwz_getTextString($menu->name) ;
            $menu->description = mwz_getTextString($menu->description) ;
        }
        return view('menu::form',['menu'=>$menu]);
    }
    
    /**
    * Function : update menu  status
    * Dev : Dave
    * Update Date : 13 jul 2021
    * @param POST
    * @return json of update status
    */
    public function set_status(Request $request)
    {
        if ($request->ajax()) {
            $id = $request->get('id');
            $status = $request->get('status');

            $menu = MenuGroups::find($id);
            $menu->status=$status;
            
            if($menu->save()){
                $resp = ['success'=>1,'code'=>200,'msg'=>'update category complete'] ;
            }else{
                $resp = ['success'=>0,'code'=>500,'msg'=>'error update category'] ;
            }

            return response()->json($resp);
        }

    }

    /**
    * Function :  member save 
    * Dev : Dave
    * Update Date : 08 jul 2021
    * @param POST
    * @return json response status
    */
    public function save(Request $request)
    {
        //validate post data
        $validator = Validator::make($request->all(), [
            'id' => 'integer',
            'description' => 'required|max:500', 
            'status' => 'required|integer', 
        ]);

        if ($validator->fails()){
            $errors = $validator->errors();
            $resp = ['success'=>0,'code'=>0,'msg'=>'error','error'=>$errors] ;
            return response()->json($resp);
        }

        $now = DB::raw('NOW()');
        $attributes = [
            "name"=>$request->get('name'),
            "description"=>$request->get('description'),
            "status"=>$request->get('status')
        ];
        if(!empty($request->get('id'))){
            $member_category = MenuGroups::where('id',$request->get('id'))->update($attributes) ;
            $resp = ['success'=>1,'code'=>200,'msg'=>'update competet'] ;
        }else{
            $member_category = MenuGroups::create($attributes); 
            if(!empty($request->get('parent_id'))){
                $member_category->parent_id = $request->get('parent_id') ;
            }
            $member_category->save();
            $resp = ['success'=>1,'code'=>200,'msg'=>'insert competet'] ;
        }
        
        return response()->json($resp);
    }

}
