<?php

namespace Modules\Menu\Http\Controllers;

use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
// use Illuminate\Support\Facades\Auth;
use Illuminate\Routing\Redirector;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\DB;

use Yajra\DataTables\Facades\DataTables;
use Modules\Mwz\Http\Controllers\MwzController;
use Modules\Menu\Entities\Menus ;
use Modules\Menu\Entities\MenuGroups ;
use Modules\User\Http\Controllers\RoleController;

class MenuController extends Controller
{
    /**
     * Function : __construct check admin login
     * Dev : Tong
     * Update Date : 16 Jun 2021
     * @param Get
     * @return if not login redirect to /admin
     */
    public function __construct()
    {
        $this->middleware('auth:admin');
    }

    /**
     * Function : index 
     * Dev : Ta
     * Update Date : 27 july 2021
     * @param Get
     * @return view of menu
     */
    public function index()
    {
        return view('menu::menu');
    }

    /**
     * Function : change type menu
     * Dev : Ta
     * Update Date : 27 july 2021
     * @param Get
     * @return view of menu
     */
    public function type_menu($type)
    {
        session()->put('type_menu', $type);
        return back()->withInput();
    }

    /**
     * Function : menu datatable ajax response 
     * Dev : Ta
     * Update Date : 27 july 2021
     * @param Get
     * @return json of menu 
     */
    public function datatable_ajax(Request $request)
    {

        if ($request->ajax()) {
            //get type menu
            $type = ((session()->get('type_menu') == "") ? 1 : session()->get('type_menu'));

            //init datatable
            $dt_name_column = array('_lft','name_th','name_en','updated_at');
            $dt_order_column = $request->get('order')[0]['column'];
            $dt_order_dir = $request->get('order')[0]['dir'];
            $dt_start = $request->get('start');
            $dt_length = $request->get('length');
            $dt_search = $request->get('search')['value'];

            // create menu object 
            $o_menu = new Menus;

            // add search query if have search from datable
            if(!empty($dt_search)){
                $o_menu->where('sequence', 'like', "%".$dt_search."%")
                    ->where('name_th', 'like', "%".$dt_search."%")
                    ->where('name_en', 'like', "%".$dt_search."%");
            }

            // set query order & limit from datatable
            $o_menu->orderBy($dt_name_column[$dt_order_column], $dt_order_dir)
                ->offset($dt_start)
                ->limit($dt_length);

            // query menu as tree resule
            $menu = $o_menu->where('type', $type)->get();
            
            // count all menu
            $dt_total = $menu->count();

            // prepare datatable for resonse
            $tables = Datatables::of($menu)
                ->addIndexColumn()
                ->setRowId('sequence')
                ->setRowClass('menu_row')
                ->setTotalRecords($dt_total)
                ->editColumn('updated_at', function ($record) {
                    return $record->updated_at->format('Y-m-d H:i:s');
                })
                ->addColumn('actionEdit', function ($record) {
                    $action_btn = '<div class="btn-list">';

                    if ($record->status == 1) {
                        $action_btn .= '<a onclick="setUpdateStatusMenu(' . $record->id . ',0)" href="javascript:void(0);" class="btn btn-outline-success"><i class="fa fa-check"></i></a></a>';
                    } else {
                        $action_btn .=  '<a onclick="setUpdateStatusMenu(' . $record->id . ',1)" href="javascript:void(0);"  class="btn btn-outline-warning"><i class="fa fa-times"></i></a></a>';
                    }

                    $action_btn .= '<a href="' . route('admin.menu.menu.edit', $record->id) . '" class="btn btn-outline-primary"><i class="fa fa-pencil"></i></a></a>';
                    $action_btn .= '</div>';

                    return $action_btn;
                })
                ->escapeColumns([]);

            // response datatable json
            return $tables->make(true);
        }
    }

     
    /**
     * Function : add menu form
     * Dev : Ta
     * Update Date : 27 july 2021
     * @param GET
     * @return category form view
     */
    public function form($id = 0)
    {
        $menu = [];
        if (!empty($id)) {
            $menu = Menus::find($id);
        }
        return view('menu::formmenu', ['menu' => $menu]);
    }


    /**
     * Function : update menu  status
     * Dev : Ta
     * Update Date : 27 july 2021
     * @param POST
     * @return json of update status
     */
    public function set_status(Request $request)
    {
        if ($request->ajax()) {
            $id = $request->get('id');
            $status = $request->get('status');

            $menu = Menus::find($id);
            $menu->status = $status;

            if ($menu->save()) {
                $resp = ['success' => 1, 'code' => 200, 'msg' => 'อัปเดตสถานะสำเร็จ'];
            } else {
                $resp = ['success' => 0, 'code' => 500, 'msg' => 'อัปเดตสถานะไม่สำเร็จ!'];
            }

            return response()->json($resp);
        }
    }

    /**
     * Function :  member save 
     * Dev : Ta
     * Update Date : 27 july 2021
     * @param POST
     * @return json response status
     */
    public function save(Request $request)
    {
        //check input is null
        if ($request->get('name_th') == "") {
            $resp = ['error' => 0, 'code' => 301, 'msg' => 'โปรดระบุชื่อเมนูภาษาไทย!', 'focus' => 'name_th'];
            return response()->json($resp);
        }
        if ($request->get('name_en') == "") {
            $resp = ['error' => 0, 'code' => 301, 'msg' => 'โปรดระบุชื่อเมนูภาษาอังกฤษ!', 'focus' => 'name_en'];
            return response()->json($resp);
        }
        if ($request->get('sequence') == "") {
            $resp = ['error' => 0, 'code' => 301, 'msg' => 'โปรดระบุลำดับการแสดงผล!', 'focus' => 'sequence'];
            return response()->json($resp);
        }

        //validate post data
        $validator = Validator::make($request->all(), [
            'name_th' => 'required|max:500',
            'name_en' => 'required|max:500',
            'sequence' => 'required|integer',
            'status' => 'required|integer',
        ]);

        if ($validator->fails()) {
            $errors = $validator->errors();
            $resp = ['success' => 0, 'code' => 0, 'msg' => 'error', 'error' => $errors];
            return response()->json($resp);
        }

        $now = DB::raw('NOW()');
        $attributes = [
            "name_th" => $request->get('name_th'),
            "name_en" => $request->get('name_en'),
            "sequence" => $request->get('sequence'),
            "status" => $request->get('status')
        ];

        if (!empty($request->get('id'))) {
            $menu = Menus::where('id', $request->get('id'))->update($attributes);
            $resp = ['success' => 1, 'code' => 200, 'msg' => 'อัปเดตข้อมูลสำเร็จ'];
        } else {
            $menu = Menus::create($attributes);
            $menu->save();
            $resp = ['success' => 1, 'code' => 200, 'msg' => 'บันทึกข้อมูลสำเร็จ'];
        }

        return response()->json($resp);
    }
}
