<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/
Route::prefix('')->group(function () {
    Route::get('/',                 'FrontendController@index');
    Route::get('/about',            'FrontendController@about')->name('index.frontend.about.partner');;
    Route::get('/blog/{category_id}', 'FrontendController@blog')->name('index.frontend.blog.blog');
    Route::get('/blog-detail/{id}',      'FrontendController@blogDetail')->name('index.frontend.blog.blogDetail');
    Route::get('/blog-tag/{tags}',         'FrontendController@blogTag')->name('index.frontend.blog.tags');
    Route::get('/blog-search',         'FrontendController@blogSearch')->name('index.frontend.blog.search');
    Route::get('/privacy',           'FrontendController@privacy')->name('index.frontend.privacy.privacy');
    Route::get('/career',            'FrontendController@career');
    Route::get('/contact',           'FrontendController@contact');
    Route::get('/service',           'FrontendController@service');
    Route::get('/service-detail/{id}',    'FrontendController@serviceDetail')->name('index.frontend.service.serviceDetail');

    Route::post('/contact/save', 'FrontendController@contact_save')->name('index.frontend.contactus.save');
    Route::post('/career/save', 'FrontendController@career_save')->name('index.frontend.career.save');

    Route::get('ajax/autocompleteajax', 'FrontendController@autoCompleteAjax')->name('index.frontend.blog.autocompleteajax');

    Route::get('language/{lang}', 'FrontendController@language')->name('index.frontend.language');
    Route::get('accept_cookie', 'FrontendController@accept_cookie')->name('index.frontend.accept_cookie');

    Route::post('/subscribe/save', 'FrontendController@subscribe_save')->name('index.frontend.subscribe.save');
    Route::post('/search_list', 'FrontendController@search_list')->name('index.frontend.search_list');
});
