@extends('frontend::layouts.master')
@section('title')

@section('style')

@endsection

@section('content')
    @php
    setLanguage();
    if (!empty(GetBanner(2)[0])) {
        $banner = GetBanner(2)[0];
    } else {
        $banner = [];
    }
    @endphp
    <main id="main">
        <div class="dim-ratio dim-ratio-16by9">
            @if (!empty($banner->link) && $banner->image == '')
                <div class="video-container video-sigi">
                    <div class="dim-item video-js vjs-default-skin" id="youtube-video">
                        {!! $banner->link !!}
                    </div>
                </div>
            @else
                <div class="dim-item">
                    <img src="{{ !empty($banner->image) ? URL::asset($banner->image) : 'storage/no_image/1920-1080.png' }}"
                        alt="Alternate Text" lazyload="true">
                </div>
            @endif
        </div>

        <div class="bg-service rel pt-6 pb-12 pt-32-lg"
            style="background-image:url({{ Module::asset('frontend:img/services/service.svg') }})">
            <div class="container ppdx animate__animated" animate="animate__fadeInLeft">
                {!! mwz_getTextString(get_conotent(1)->content) !!}
            </div>
        </div>

        <div class="rel ppdx mt-n6 mt-0-sm">
            <div class="rel z-1 pt-6-sm pt-0-lg">
                @foreach ($services as $index => $service)
                    @if ($index % 2 == 0)
                        <div class="space jcc mt-12 mt-24-lg">
                            <div class="dim-8-sm dim-6-lg animate__animated odf-lg" animate="animate__fadeIn"><img
                                    src="{{ $service->image_service != '' && CheckFileInServer($service->image_service) ? $service->image_service : '/storage/no_image/1920-940.png' }}"
                                    alt="Alternate Text" lazyload="true">
                            </div>
                            <div class="dim-8-sm dim-6-lg df fc aic ais-lg animate__animated p-4 pl-12-lg pr-32-lg"
                                animate="animate__fadeIn">
                                <div class="stile">{{ $service->name }}</div>
                                <div class="subtile">{!! mwz_getTextString($service->detail) !!}</div><a class="butn butn-8th curve mt-6 pl-6"
                                    href="{{ route('index.frontend.service.serviceDetail', $service->id) }}">
                                    <div class="df aic"><img
                                            src="{{ Module::asset('frontend:img/icon/arrow-r-circle.svg') }}"
                                            alt="Alternate Text" lazyload="true">
                                        <div class="ml-2">@lang('frontend::lang.lang_title_5')</div>
                                    </div>
                                </a>
                            </div>
                        </div>
                    @else
                        <div class="space jcc mt-12 mt-n24-lg">
                            <div class="dim-8-sm dim-6-lg animate__animated odl-lg" animate="animate__fadeIn"><img
                                    src="{{ $service->image_service != '' && CheckFileInServer($service->image_service) ? $service->image_service : '/storage/no_image/1920-940.png' }}"
                                    alt="Alternate Text" lazyload="true">
                            </div>
                            <div class="dim-8-sm dim-6-lg df fc aic ais-lg animate__animated p-4 pr-12-lg pl-32-lg pt-32-lg"
                                animate="animate__fadeIn">
                                <div class="stile">{{ $service->name }}</div>
                                <div class="subtile">{!! mwz_getTextString($service->detail) !!}</div><a class="butn butn-8th curve mt-6 pl-6"
                                    href="{{ route('index.frontend.service.serviceDetail', $service->id) }}">
                                    <div class="df aic"><img
                                            src="{{ Module::asset('frontend:img/icon/arrow-r-circle.svg') }}"
                                            alt="Alternate Text" lazyload="true">
                                        <div class="ml-2">@lang('frontend::lang.lang_title_5')</div>
                                    </div>
                                </a>
                            </div>
                        </div>
                    @endif
                @endforeach
            </div>
            <div class="bg-whlbe" style="background-image:url({{ Module::asset('frontend:img/bg/whlu.svg') }})">
            </div>
        </div>
        @php
            $sum_page = 0;
        @endphp
        <div class="py-12 text-center">
            <div class="ps-pagination">
                <ul class="pagination">
                    <li class="prev {{ $page == 1 ? 'disabled' : '' }}"><a href="{{ $services->previousPageUrl() }}">
                            <h5><i class="fa fa-arrow-left"></i></h5>
                        </a></li>
                    @for ($i = 1; $i <= $services->lastPage(); $i++)
                        <li class="{{ $page == $i ? 'active' : '' }}"><a
                                href="{{ $services->url($i) }}">{{ $i }}</a></li>
                        @php
                            $sum_page++;
                        @endphp
                    @endfor
                    <li class="next {{ $page == $sum_page ? 'disabled' : '' }}"><a
                            href="{{ $services->nextPageUrl() }}">
                            <h5><i class="fa fa-arrow-right"></i></h5>
                        </a></li>
                </ul>
            </div>
        </div>
    </main>
@endsection

@section('script')
    <!--ckeditor js-->
    <script src="{{ URL::asset('assets/plugins/tinymce/tinymce.min.js') }}"></script>
    <!-- <script src="{{ URL::asset('assets/js/formeditor.js') }}"></script> -->

    <!-- Notifications js -->
    <link href="{{ URL::asset('assets/plugins/notify-growl/css/jquery.growl.css') }}" rel="stylesheet" />
    <link href="{{ URL::asset('assets/plugins/notify-growl/css/notifIt.css') }}" rel="stylesheet" />
    <script src="{{ URL::asset('assets/plugins/bootbox/bootbox.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/notify-growl/js/rainbow.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/notify-growl/js/jquery.growl.js') }}"></script>

    <!-- mwz master js css -->
    <link rel="stylesheet" href="{{ mix('css/mwz.css') }}">
    <script src="{{ mix('js/mwz.js') }}"></script>

    <!-- module js css -->
    <link rel="stylesheet" href="{{ mix('css/frontend.css') }}">
    <script src="{{ mix('js/frontend.js') }}"></script>
@endsection
