@extends('frontend::layouts.master')
@section('title')

@section('style')

@endsection

@section('content')
    @php
    setLanguage();
    $service = GetServiceDetail($id);
    @endphp
    <main id="main">
        <div class="rel dim-ratio dim-ratio-16by9"><img class="dim-item"
                src="{{ $service->image_service != '' && CheckFileInServer($service->image_service) ? $service->image_service : '/storage/no_image/1920-940.png' }}"
                alt="Alternate Text" lazyload="true">
            <div class="container ppdx px-lg-12">
                <div class="sdtil text-white">{{ $service->name }}</div>
            </div>
        </div>
        <div class="bg-serd pb-12 pb-24-md"
            style="background-image:url({{ Module::asset('frontend:img/services/service.svg') }})">
            <div class="container ppdx py-12 px-12-lg">
                <div class="content-container">
                    {!! mwz_getTextString($service->description) !!}
                </div>
            </div>
        </div>
        @if (!empty($service->file))
            <div class="ppfd animate__animated" animate="animate__fadeInLeft">
                <div class="item rotassx">
                    <p><strong>PDF FILE</strong></p>
                </div>
                <div class="item"> <a target="_blank" href="{{ url($service->file) }}"><img
                            src="{{ Module::asset('frontend:img/icon/pdf.svg') }}" alt="Alternate Text"
                            lazyload="true"></a></div>
            </div>
        @endif
    </main>
@endsection

@section('script')
    <!--ckeditor js-->
    <script src="{{ URL::asset('assets/plugins/tinymce/tinymce.min.js') }}"></script>
    <!-- <script src="{{ URL::asset('assets/js/formeditor.js') }}"></script> -->

    <!-- Notifications js -->
    <link href="{{ URL::asset('assets/plugins/notify-growl/css/jquery.growl.css') }}" rel="stylesheet" />
    <link href="{{ URL::asset('assets/plugins/notify-growl/css/notifIt.css') }}" rel="stylesheet" />
    <script src="{{ URL::asset('assets/plugins/bootbox/bootbox.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/notify-growl/js/rainbow.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/notify-growl/js/jquery.growl.js') }}"></script>

    <!-- mwz master js css -->
    <link rel="stylesheet" href="{{ mix('css/mwz.css') }}">
    <script src="{{ mix('js/mwz.js') }}"></script>

    <!-- module js css -->
    <link rel="stylesheet" href="{{ mix('css/frontend.css') }}">
    <script src="{{ mix('js/frontend.js') }}"></script>
@endsection
