@extends('frontend::layouts.master')
@section('title')

@section('style')

@endsection

@section('content')
    @php
    setLanguage();
    @endphp
    <main id="main">
        <div class="bg-service rel pt-6 pb-12 pt-32-lg"
            style="background-image:url({{ Module::asset('frontend:img/blog/blog.svg') }})">
            <div class="container ppdx">
                <div class="stit">{{ $blog_cats->name }}</div>
                <div class="space">
                    <div class="dim-7-lg">
                        {!! mwz_getTextString($blog_cats->detail) !!}
                    </div>
                </div>
            </div>
        </div>
        <div class="container ppdx">
            @foreach ($blogs as $index => $blog)
                @if ($index == 0)
                    <div class="highlight-blog aslk animate__animated" animate="animate__fadeInLeft">
                        <div class="img"> <img
                                src="{{ CheckFileInServer($blog->image) && $blog->image != '' ? $blog->image : '/storage/no_image/1920-940.png' }}"
                                alt="Alternate Text" lazyload="true">
                        </div>
                        <div class="content">
                            <div class="date">{{ mwz_convertMonth($blog->publish_at) }}</div>
                            <div class="tlhead my-6">{{ $blog->name }}</div><a class="butn butn-8th curve pl-6 blog-butn"
                                href="{{ route('index.frontend.blog.blogDetail', $blog->id) }}">
                                <div class="df aic"> <img
                                        src="{{ Module::asset('frontend:img/icon/arrow-r-circle.svg') }}"
                                        alt="Alternate Text" lazyload="true">
                                    <div class="ml-2">@lang('frontend::lang.lang_title_5')</div>
                                </div>
                            </a>
                        </div>
                        <a class="tglk" href="{{ route('index.frontend.blog.blogDetail', $blog->id) }}"></a>
                    </div>

                    <div class="space">
                    @else
                        <div class="dim-6-xs dim-4-md dim-3-xl p-4 my-4 animate__animated" animate="animate__fadeInLeft">
                            <div class="sng-blog aslk">
                                <div class="wrapper"><img
                                        src="{{ CheckFileInServer($blog->image) && $blog->image != '' ? $blog->image : '/storage/no_image/1920-940.png' }}"
                                        alt="Alternate Text" lazyload="true">
                                    <div class="px-4">
                                        <p class="my-3 date">{{ mwz_convertMonth($blog->publish_at) }}</p>
                                        <p class="tlhead hd2">{{ $blog->name }}</p>
                                    </div>
                                </div><a class="butn butn-8th curve pl-6 sblog-butn"
                                    href="{{ route('index.frontend.blog.blogDetail', $blog->id) }}">
                                    <div class="df aic"> <img
                                            src="{{ Module::asset('frontend:img/icon/arrow-r-circle.svg') }}"
                                            alt="Alternate Text" lazyload="true">
                                        <div class="ml-2">@lang('frontend::lang.lang_title_5')</div>
                                    </div>
                                </a>
                                <a class="tglk" href="{{ route('index.frontend.blog.blogDetail', $blog->id) }}"></a>
                            </div>
                        </div>
                @endif
            @endforeach
        </div>
        @php
            $sum_page = 0;
        @endphp
        <div class="py-12 text-center">
            <div class="ps-pagination">
                <ul class="pagination">
                    <li class="prev {{ $page == 1 ? 'disabled' : '' }}"><a href="{{ $blogs->previousPageUrl() }}">
                            <h5><i class="fa fa-arrow-left"></i></h5>
                        </a></li>
                    @for ($i = 1; $i <= $blogs->lastPage(); $i++)
                        <li class="{{ $page == $i ? 'active' : '' }}"><a
                                href="{{ $blogs->url($i) }}">{{ $i }}</a></li>
                        @php
                            $sum_page++;
                        @endphp
                    @endfor
                    <li class="next {{ $page == $sum_page ? 'disabled' : '' }}"><a href="{{ $blogs->nextPageUrl() }}">
                            <h5><i class="fa fa-arrow-right"></i></h5>
                        </a></li>
                </ul>
            </div>
        </div>
        </div>
    </main>
@endsection

@section('script')
    <!--ckeditor js-->
    <script src="{{ URL::asset('assets/plugins/tinymce/tinymce.min.js') }}"></script>
    <!-- <script src="{{ URL::asset('assets/js/formeditor.js') }}"></script> -->

    <!-- Notifications js -->
    <link href="{{ URL::asset('assets/plugins/notify-growl/css/jquery.growl.css') }}" rel="stylesheet" />
    <link href="{{ URL::asset('assets/plugins/notify-growl/css/notifIt.css') }}" rel="stylesheet" />
    <script src="{{ URL::asset('assets/plugins/bootbox/bootbox.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/notify-growl/js/rainbow.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/notify-growl/js/jquery.growl.js') }}"></script>

    <!-- mwz master js css -->
    <link rel="stylesheet" href="{{ mix('css/mwz.css') }}">
    <script src="{{ mix('js/mwz.js') }}"></script>

    <!-- module js css -->
    <link rel="stylesheet" href="{{ mix('css/frontend.css') }}">
    <script src="{{ mix('js/frontend.js') }}"></script>
@endsection
