@extends('frontend::layouts.master')
@section('title')

@section('style')
    <style>
        .video-sigi iframe {
            height: 500px;
        }

    </style>
@endsection

@section('content')
    @php
    setLanguage();
    @endphp
    <main id="main">
        <div class="rel dim-ratio dim-ratio-16by9"><img class="dim-item"
                src="{{ CheckFileInServer($blog_detail->image) && $blog_detail->image != '' ? $blog_detail->image : '/storage/no_image/1920-940.png' }}"
                alt="Alternate Text" lazyload="true">
            <div class="container ppdx rel z-1">
                <div class="sdtil text-white">
                    <p class="date">{{ mwz_convertMonth($blog_detail->publish_at) }}</p>
                    <p class="title">{{ $blog_detail->name }}</p>
                </div>
            </div>
            <div class="filbwa"></div>
        </div>
        <div class="rel">
            <div class="container pb-12 ppdx rel">
                <div class="df aic jcs fwp tag-wrapper py-6">
                    @if (!empty($blog_detail->tags))
                        @foreach (explode(',', $blog_detail->tags) as $tags)
                            <a class="mr-2" href="{{ route('index.frontend.blog.tags', $tags) }}">
                                <div class="tagg">{{ $tags }}</div>
                            </a>
                        @endforeach
                    @endif
                </div>
                <div class="content-container mt-6 px-12-lg">
                    {!! mwz_getTextString($blog_detail->description) !!}
                </div>
            </div>
            @if (!empty($blog_detail->file))
                <div class="ppfd sttc">
                    <div class="item rotassx">
                        <p><strong>PDF FILE</strong></p>
                    </div>
                    <div class="item"><a target="_blank" href="{{ url($blog_detail->file) }}"><img
                                src="{{ Module::asset('frontend:img/icon/pdf.svg') }}" alt="Alternate Text"
                                lazyload="true"></a></div>
                </div>
            @endif
        </div>
        @if (!empty($blog_detail->link))
            <div class="bg-default" style="background-image:url('/storage/blog/1629381100.jpg')">
                <div class="container py-12 ppdx">

                    <div class="video-wrapper">
                        <div class="background">
                            <div class="transbox">
                                <div class="video-container video-sigi">
                                    {!! $blog_detail->link !!}
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        @endif
    </main>
@endsection

@section('script')
    <!--ckeditor js-->
    <script src="{{ URL::asset('assets/plugins/tinymce/tinymce.min.js') }}"></script>
    <!-- <script src="{{ URL::asset('assets/js/formeditor.js') }}"></script> -->

    <!-- Notifications js -->
    <link href="{{ URL::asset('assets/plugins/notify-growl/css/jquery.growl.css') }}" rel="stylesheet" />
    <link href="{{ URL::asset('assets/plugins/notify-growl/css/notifIt.css') }}" rel="stylesheet" />
    <script src="{{ URL::asset('assets/plugins/bootbox/bootbox.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/notify-growl/js/rainbow.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/notify-growl/js/jquery.growl.js') }}"></script>

    <!-- mwz master js css -->
    <link rel="stylesheet" href="{{ mix('css/mwz.css') }}">
    <script src="{{ mix('js/mwz.js') }}"></script>

    <!-- module js css -->
    <link rel="stylesheet" href="{{ mix('css/frontend.css') }}">
    <script src="{{ mix('js/frontend.js') }}"></script>
@endsection
