@extends('frontend::layouts.master')
@section('title')

@section('style')

@endsection

@section('content')
    @php
    setLanguage();
    $about = GetAboutUs(1);
    @endphp
    <main id="main">
        <div class="abanner">
            <div class="container ppdx py-12">
                <div class="content-container">
                    {!! mwz_getTextString($about->about_header) !!}
                </div>
            </div><img src="{{ Module::asset('frontend:img/bg/abt.jpg') }}" alt="Alternate Text" lazyload="true">
        </div>
        <div class="rel mbn4">
            <div class="container ppdx abvdscontan">
                <div class="abdds animate__animated" animate="animate__fadeInRight">
                    <div class="content-container">
                        <table>
                            <tr>
                                <td style="width:40%;padding:1rem 2rem">
                                    <div style="max-width:320px;margin:0 auto"><img src="{{ $about->image_story }}"
                                            alt="Alternate Text" lazyload="true">
                                    </div>
                                </td>
                                <td style="padding:1rem;vertical-align:top">
                                    {!! mwz_getTextString($about->description_story) !!}
                                </td>
                            </tr>
                        </table>
                    </div>
                </div>
            </div>
            <div class="bgw"></div>
            <div class="ppfd animate__animated" animate="animate__fadeInLeft">
                @if (CheckFileInServer($about->file_about1) || CheckFileInServer($about->file_about2))
                    <div class="item rotassx">
                        <p><strong>PDF FILE</strong></p>
                    </div>
                @endif
                @if (CheckFileInServer($about->file_about1))
                    <div class="item"> <a target="_blank" href="{{ url($about->file_about1) }}"><img
                                src="{{ Module::asset('frontend:img/icon/pdf.svg') }}" alt="Alternate Text"
                                lazyload="true"></a></div>
                @endif
                @if (CheckFileInServer($about->file_about2))
                    <div class="item"><a target="_blank" href="{{ url($about->file_about2) }}"><img
                                src="{{ Module::asset('frontend:img/icon/pdf.svg') }}" alt="Alternate Text"
                                lazyload="true"></a></div>
                @endif
            </div>
        </div>
        <div class="vis bg-default pt-12"
            style="background-image:url({{ Module::asset('frontend:img/bg/abt-vis.jpg') }})">
            <div class="container ppdx">
                <div class="content-container"><br><br><br><br><br><br>
                    <div class="text-center">
                        {!! mwz_getTextString($about->description_vision) !!}
                    </div>
                </div>
            </div>
            <div class="fil"></div>
        </div>
        <div class="bg2tn" style="background-image:url({{ Module::asset('frontend:img/bg/bg-2tone.svg') }})">
            <div class="tem">
                <div class="container ppdx">
                    <div class="df aic fc fr-lg jcc jcsb-lg my-12">
                        <div class="content-container">
                            {!! mwz_getTextString($about->description_team) !!}
                        </div>
                    </div>
                    <div class="space mx-n4">
                        @foreach ($teams as $team)
                            <div class="dim-6-tn dim-4-md dim-3-xl p-4 animate__animated" animate="animate__fadeIn">
                                <div class="pofc"><img
                                        src="{{ $team->image != '' && CheckFileInServer($team->image) ? $team->image : '/storage/no_image/360-515.png' }}"
                                        alt="Alternate Text" lazyload="true">
                                    <div class="tilsd">{{ $team->fullname }}</div>
                                    <p>{{ $team->position }}</p>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>
            <div class="tem py-12" id="partner_form">
                <div class="container ppdx">
                    <div class="df fc my-12">
                        {!! mwz_getTextString($about->description_partner) !!}
                    </div>
                    <div class="partner-slide">
                        @php
                            $check = 0;
                        @endphp
                        @foreach ($partners as $partner)
                            @php
                                $check++;
                            @endphp
                            @if ($check == 1)
                                <div class="slide-item animate__animated" animate="animate__fadeIn">
                                    @if (!empty($partner->link))
                                        <a target="_blank" href="{{ $partner->link }}">
                                    @endif
                                    <div class="ovlog dim-ratio">
                                        <div class="frame dim-item">
                                            <div class="logo-wrapper bg-default"
                                                style="background-image:url({{ $partner->image != '' && CheckFileInServer($partner->image) ? $partner->image : '/storage/no_image/265-265.png' }})">
                                                <div class="namect text-center">{{ $partner->name }}</div>
                                            </div>
                                        </div>
                                    </div>
                                    @if (!empty($partner->link))
                                        </a>
                                    @endif
                                @else
                                    @if (!empty($partner->link))
                                        <a target="_blank" href="{{ $partner->link }}">
                                    @endif
                                    <div class="ovlog dim-ratio">
                                        <div class="frame dim-item">
                                            <div class="logo-wrapper bg-default"
                                                style="background-image:url({{ $partner->image != '' && CheckFileInServer($partner->image) ? $partner->image : '/storage/no_image/265-265.png' }})">
                                                <div class="namect text-center">{{ $partner->name }}</div>
                                            </div>
                                        </div>
                                    </div>
                                    @if (!empty($partner->link))
                                        </a>
                                    @endif
                                </div>
                                @php
                                    $check = 0;
                                @endphp
                            @endif
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </main>
@endsection

@section('script')
    <!--ckeditor js-->
    <script src="{{ URL::asset('assets/plugins/tinymce/tinymce.min.js') }}"></script>
    <!-- <script src="{{ URL::asset('assets/js/formeditor.js') }}"></script> -->

    <!-- Notifications js -->
    <link href="{{ URL::asset('assets/plugins/notify-growl/css/jquery.growl.css') }}" rel="stylesheet" />
    <link href="{{ URL::asset('assets/plugins/notify-growl/css/notifIt.css') }}" rel="stylesheet" />
    <script src="{{ URL::asset('assets/plugins/bootbox/bootbox.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/notify-growl/js/rainbow.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/notify-growl/js/jquery.growl.js') }}"></script>

    <!-- mwz master js css -->
    <link rel="stylesheet" href="{{ mix('css/mwz.css') }}">
    <script src="{{ mix('js/mwz.js') }}"></script>

    <!-- module js css -->
    <link rel="stylesheet" href="{{ mix('css/frontend.css') }}">
    <script src="{{ mix('js/frontend.js') }}"></script>
@endsection
