$(".apply").on("click", function () {
    $itemid = $(this).parent().parent().parent().find('.itemid').val();
    $itemtitle = $(this).parent().parent().parent().find('.itemtitle').val();
    $(".job_id").val($itemid);
    $(".job_title").val($itemtitle);

    $("html, body").animate({
        scrollTop: $('#careers-form').offset().top
    }, 300);
});

$(document).on('change', ':file', function () {
    var input = $(this),
        numFiles = input.get(0).files ? input.get(0).files.length : 1,
        label = input.val().replace(/\\/g, '/').replace(/.*\//, '');
    input.trigger('fileselect', [numFiles, label]);
});

// Upload file
$(document).ready(function () {
    $(':file').on('fileselect', function (event, numFiles, label) {

        var input = $(this).parents('.has-advanced-upload').find(':text'),
            log = numFiles > 1 ? numFiles + ' files selected' : label;

        if (input.length) {
            input.val(log);
        } else {
            //if (log) alert(log);
        }

    });
});

JsReload = function (time) {
    setInterval(function () {
        window.location.reload();
    }, time);
}

setSave = function () {
    event.preventDefault();
    tinyMCE.triggerSave();
    var frm_data = new FormData($('#contact_frm')[0]);
    $.ajax({
        url: "/contact/save",
        type: "POST",
        contentType: false,
        data: frm_data,
        processData: false,
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        success: function (resp) {
            if (resp.success) {
                mwz_noti('success', resp.msg);
                JsReload(1500);
            } else {
                mwz_noti('error', resp.msg);
                if (resp.focus) {
                    document.getElementById(resp.focus).focus();
                }
            }
        },
    });
}

CareerSave = function () {
    event.preventDefault();
    tinyMCE.triggerSave();
    var frm_data = new FormData($('#career_frm')[0]);
    $.ajax({
        url: "/career/save",
        type: "POST",
        contentType: false,
        data: frm_data,
        processData: false,
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        success: function (resp) {
            if (resp.success) {
                mwz_noti('success', resp.msg);
                JsReload(1500);
            } else {
                mwz_noti('error', resp.msg);
                if (resp.focus) {
                    document.getElementById(resp.focus).focus();
                }
            }
        },
    });
}

Getposition = function (id) {
    document.getElementById('position').value = document.getElementById('title' + id).innerHTML;
    document.getElementById('career_id').value = id;
}

ChangNameImage = function () {
    var fileInput = document.getElementById('file');
    var filename = fileInput.files[0].name;
    document.getElementById('text_image').innerHTML = filename
}

setSubscribe = function () {
    event.preventDefault();
    tinyMCE.triggerSave();
    var frm_data = new FormData($('#subscribe_frm')[0]);
    $.ajax({
        url: "/subscribe/save",
        type: "POST",
        contentType: false,
        data: frm_data,
        processData: false,
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        success: function (resp) {
            if (resp.success) {
                mwz_noti('success', resp.msg);
                JsReload(1500);
            } else {
                mwz_noti('error', resp.msg);
                if (resp.focus) {
                    document.getElementById(resp.focus).focus();
                }
            }
        },
    });
}

var input = document.getElementById("search");
input.addEventListener("keyup", function (event) {
    if (event.keyCode === 13) {
        document.getElementById("search_form").submit();
    }
});

GetSearchList = function () {
    var text_search = document.getElementById("search").value;
    let _token = $('meta[name="csrf-token"]').attr('content');

    $.ajax({
        url: "/search_list",
        type: "POST",
        data: {
            text: text_search,
            _token: _token
        },
        success: function (resp) {
            $('#search-list').html(resp)
        },
    });
}