<?php

namespace Modules\Frontend\Http\Controllers;

use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\View;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\DB;

use Modules\Frontend\Entities\Pages;
use Modules\Frontend\Entities\Contacts;
use Modules\Frontend\Entities\Careers;
use Modules\Frontend\Entities\Candidates;
use Modules\Frontend\Entities\AboutPartners;
use Modules\Frontend\Entities\Blogs;
use Modules\Frontend\Entities\Services;
use Illuminate\Pagination\Paginator;
use Helper;
use Modules\Frontend\Entities\AboutTeams;
use Modules\Frontend\Entities\BlogCategories;
use Modules\Frontend\Entities\Cookie;
use Modules\Subscribe\Entities\Subscribe;

class FrontendController extends Controller
{
    /**
     * Function : frontend number customer home
     * Dev : pop
     * Update Date : 7 August 2021
     * @param POST
     * @return json response data number
     */
    public function index()
    {
        $lang = session()->get('frontend_lang');
        $partners = AboutPartners::where('status', 1)
            ->select('id', 'image', 'name_' . (($lang == '') ? 'en' : $lang) . ' as name', 'link')
            ->orderBy('sequence','ASC')
            ->limit(8)
            ->get();

        return view('frontend::index', ['partners' => $partners]);
    }

    /**
     * Function : frontend save 
     * Dev : pop
     * Update Date : 7 August 2021
     * @param POST
     * @return json response Request
     */
    public function contact_save(Request $request)
    {
        //Check input is null
        if ($request->get('name') == "") {
            $resp = ['error' => 0, 'code' => 301, 'msg' => 'โปรดระบุชื่อ', 'focus' => 'name'];
            return response()->json($resp);
        }
        if ($request->get('email') == "") {
            $resp = ['error' => 0, 'code' => 301, 'msg' => 'โปรดระบุอีเมล', 'focus' => 'email'];
            return response()->json($resp);
        }
        if ($request->get('tel') == "") {
            $resp = ['error' => 0, 'code' => 301, 'msg' => 'โปรดระบุเบอร์โทรศัพท์', 'focus' => 'tel'];
            return response()->json($resp);
        }
        if ($request->get('sub') == "") {
            $resp = ['error' => 0, 'code' => 301, 'msg' => 'โปรดระบุหัวข้อ', 'focus' => 'sub'];
            return response()->json($resp);
        }
        if ($request->get('msg') == "") {
            $resp = ['error' => 0, 'code' => 301, 'msg' => 'โปรดระบุรายละเอียด', 'focus' => 'msg'];
            return response()->json($resp);
        }

        //validate post data
        $validator = Validator::make($request->all(), [
            'name' => 'required',
            'email' => 'required',
            'tel' => 'required',
            'sub' => 'required',
            'msg' => 'required',
        ]);

        if ($validator->fails()) {
            $errors = $validator->errors();
            $resp = ['success' => 0, 'code' => 0, 'msg' => 'เกิกข้อผิดพลาด โปรดลองใหม่อีกครั้ง!', 'error' => $errors];
            return response()->json($resp);
        }

        $attributes = [
            "fullname" => $request->get('name'),
            "email" => $request->get('email'),
            "phone" => $request->get('tel'),
            "subject" => $request->get('sub'),
            "message" => $request->get('msg'),
            "status" => 0
        ];

        $contact = Contacts::create($attributes);
        $contact->save();
        $resp = ['success' => 1, 'code' => 200, 'msg' => 'ส่งข้อมูลการติดต่อสำเร็จ'];

        return response()->json($resp);
    }

    /**
     * Function : frontend save 
     * Dev : pop
     * Update Date : 7 August 2021
     * @param POST
     * @return json response Request
     */
    public function career_save(Request $request)
    {
        if ($request->get('career_id') == "") {
            $resp = ['error' => 0, 'code' => 301, 'msg' => 'โปรดเลือกตำแหน่งงาน', 'focus' => 'career_id'];
            return response()->json($resp);
        }
        if ($request->get('name') == "") {
            $resp = ['error' => 0, 'code' => 301, 'msg' => 'โปรดระบุชื่อ', 'focus' => 'name'];
            return response()->json($resp);
        }
        if ($request->get('email') == "") {
            $resp = ['error' => 0, 'code' => 301, 'msg' => 'โปรดระบุอีเมล', 'focus' => 'email'];
            return response()->json($resp);
        }
        if ($request->get('tel') == "") {
            $resp = ['error' => 0, 'code' => 301, 'msg' => 'โปรดระบุเบอร์โทรศัพท์', 'focus' => 'tel'];
            return response()->json($resp);
        }
        if (!$request->hasFile('file')) {
            $resp = ['error' => 0, 'code' => 301, 'msg' => 'โปรดอัปโหลด Resume', 'focus' => 'file'];
            return response()->json($resp);
        }

        //validate post data
        $validator = Validator::make($request->all(), [
            'career_id' => 'required',
            'name' => 'required',
            'email' => 'required',
            'tel' => 'required',
            'file' => 'required'
        ]);

        if ($validator->fails()) {
            $errors = $validator->errors();
            $resp = ['success' => 0, 'code' => 0, 'msg' => 'error', 'error' => $errors];
            return response()->json($resp);
        }

        $attributes = [
            "career_id" => $request->get('career_id'),
            "fullname" => $request->get('name'),
            "email" => $request->get('email'),
            "mobile" => $request->get('tel'),
            "status" => 1
        ];
        if ($request->hasFile('file')) {
            $image = $request->file('file');
            $new_filename = time() . "_" . $request->get('name') . "." . $image->extension();
            $path = $image->storeAs(
                'public/candidates',
                $new_filename
            );
            $attributes['cv_file'] = Storage::url($path);
        }

        $frontend = Candidates::create($attributes);
        $frontend->save();
        $resp = ['success' => 1, 'code' => 200, 'msg' => 'ส่งใบสมัครเรียบร้อยแล้ว'];

        return response()->json($resp);
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        Paginator::useBootstrap();
    }


    /**
     * Function : frontend search language
     * Dev : pop
     * Update Date : 18 August 2021
     * @param POST
     * @return json response 
     */

    public function language($lang)
    {
        if ($lang == 'th') {
            session()->put('frontend_lang', 'th');
        } else {
            session()->put('frontend_lang', 'en');
        }

        return back()->withInput();
    }

    /**
     * Function : frontend search blog
     * Dev : pop
     * Update Date : 8 August 2021
     * @param POST
     * @return json response 
     */

    public function autoCompleteAjax(Request $request)
    {
        $search =  $request->term;

        $posts = Blogs::where('name_en', 'LIKE', "%{$search}%")
            ->orderBy('created_at', 'DESC')->limit(5)->get();
        if (!$posts->isEmpty()) {
            foreach ($posts as $post) {
                $new_row['id'] = $post->id;
                $new_row['name_en'] = $post->name_en;
                $new_row['image'] = $post->image;

                $row_set[] = $new_row; //build an array
            }
        }
        echo json_encode($row_set);
    }

    /**
     * Function : frontend search blog
     * Dev : Ta
     * Update Date : 8 August 2021
     * @param POST
     * @return json response 
     */
    public function about()
    {
        $lang = session()->get('frontend_lang');
        $partners = AboutPartners::where('status', 1)
            ->select('id', 'image', 'name_' . (($lang == '') ? 'en' : $lang) . ' as name', 'link')
            ->orderBy('sequence','ASC')
            ->get();

        $teams = AboutTeams::where('status', 1)
            ->select('id', 'fullname_' . (($lang == '') ? 'en' : $lang) . ' as fullname', 'image', 'position_' . (($lang == '') ? 'en' : $lang) . ' as position')
            ->get();

        return view('frontend::about', ['partners' => $partners, 'teams' => $teams]);
    }

    /**
     * Function : frontend search blog
     * Dev : Ta
     * Update Date : 8 August 2021
     * @param POST
     * @return json response 
     */
    public function blog(Request $request)
    {
        $lang = session()->get('frontend_lang');

        $blogs = Blogs::where('blogs.status', 1)
            ->select('id', 'name_' . (($lang == '') ? 'en' : $lang) . ' as name', 'image', 'publish_at', 'tags')
            ->where('category_id', $request->category_id)
            ->orderByDesc('sequence')
            ->paginate(9);

        $blog_cats = BlogCategories::where('status', 1)
            ->select('name_' . (($lang == '') ? 'en' : $lang) . ' as name', 'description_' . (($lang == '') ? 'en' : $lang) . ' as detail')
            ->where('id', $request->category_id)
            ->first();

        $page = 1;
        if (!empty($request->page)) {
            $page = $request->page;
        }

        return view('frontend::blog', ['blogs' => $blogs, 'category_id' => $request->category_id, 'blog_cats' => $blog_cats, 'page' => $page]);
    }

    /**
     * Function : frontend search blog
     * Dev : Ta
     * Update Date : 8 August 2021
     * @param POST
     * @return json response 
     */
    public function blogDetail($id)
    {
        $lang = session()->get('frontend_lang');
        $blog_detail = Blogs::join('blog_categories', 'blogs.category_id', '=', 'blog_categories.id')
            ->select(
                'blogs.id',
                'blog_categories.name_' . (($lang == '') ? 'en' : $lang) . ' as name_categories',
                'blogs.category_id',
                'blogs.name_' . (($lang == '') ? 'en' : $lang) . ' as name',
                'blogs.image',
                'blogs.description_' . (($lang == '') ? 'en' : $lang) . ' as description',
                'blogs.image_youtube',
                'blogs.link',
                'blogs.file',
                'blogs.publish_at',
                'blogs.tags'
            )
            ->where('blogs.id', $id)
            ->first();

        return view('frontend::blog-detail', ['blog_detail' => $blog_detail]);
    }

    /**
     * Function : frontend tags blog
     * Dev : Ta
     * Update Date : 8 August 2021
     * @param POST
     * @return json response 
     */
    public function blogTag($tags)
    {
        $lang = session()->get('frontend_lang');
        $blogs = Blogs::where('status', 1)
            ->select('id', 'name_' . (($lang == '') ? 'en' : $lang) . ' as name', 'publish_at', 'image')
            ->where('tags', 'like', '%' . $tags . '%')
            ->orderByDesc('sequence')
            ->paginate(12);

        return view('frontend::blog-tag', ['blogs' => $blogs, 'tags' => $tags]);
    }

    /**
     * Function : frontend search blog
     * Dev : Ta
     * Update Date : 8 August 2021
     * @param POST
     * @return json response 
     */
    public function blogSearch(Request $request)
    {
        $text = $request->search;
        $lang = session()->get('frontend_lang');
        if ($lang == '' || $lang == 'en') {
            $blogs = Blogs::where('status', 1)
                ->select('id', 'name_' . (($lang == '') ? 'en' : $lang) . ' as name', 'publish_at', 'image')
                ->where('name_en', 'like', '%' . $text . '%')
                ->orderByDesc('sequence')
                ->paginate(12);
        } else {
            $blogs = Blogs::where('status', 1)
                ->select('id', 'name_' . (($lang == '') ? 'en' : $lang) . ' as name', 'publish_at', 'image')
                ->where('name_th', 'like', '%' . $text . '%')
                ->orderByDesc('sequence')
                ->paginate(12);
        }

        return view('frontend::blog-search', ['blogs' => $blogs, 'text' => $text]);
    }

    /**
     * Function : frontend search blog
     * Dev : Ta
     * Update Date : 8 August 2021
     * @param POST
     * @return json response 
     */
    public function career(Request $request)
    {
        $lang = session()->get('frontend_lang');
        $careers = Careers::where('status', 1)
            ->select(
                'id',
                'title_' . (($lang == '') ? 'en' : $lang) . ' as title',
                'description_' . (($lang == '') ? 'en' : $lang) . ' as description'
            )
            ->orderByDesc('created_at')
            ->paginate(10);

        $page = 1;
        if (!empty($request->page)) {
            $page = $request->page;
        }

        return view('frontend::career', ['Careers' => $careers, 'page' => $page]);
    }

    /**
     * Function : frontend search blog
     * Dev : Ta
     * Update Date : 8 August 2021
     * @param POST
     * @return json response 
     */
    public function contact()
    {
        return view('frontend::contact');
    }

    /**
     * Function : frontend search blog
     * Dev : Ta
     * Update Date : 8 August 2021
     * @param POST
     * @return json response 
     */
    public function privacy()
    {
        return view('frontend::privacy');
    }

    /**
     * Function : frontend search blog
     * Dev : Ta
     * Update Date : 8 August 2021
     * @param POST
     * @return json response 
     */
    public function service(Request $request)
    {
        $lang = session()->get('frontend_lang');

        $services = Services::where('status', 1)
            ->select(
                'id',
                'service_name_' . (($lang == '') ? 'en' : $lang) . ' as name',
                'detail_' . (($lang == '') ? 'en' : $lang) . ' as detail',
                'description_' . (($lang == '') ? 'en' : $lang) . ' as description',
                'image_service',
                'file',
                'sequence'
            )
            ->orderBy('sequence')
            ->paginate(8);

        $page = 1;
        if (!empty($request->page)) {
            $page = $request->page;
        }

        return view('frontend::service', ['services' => $services, 'page' => $page]);
    }

    /**
     * Function : frontend search blog
     * Dev : Ta
     * Update Date : 8 August 2021
     * @param POST
     * @return json response 
     */
    public function serviceDetail($id)
    {
        return view('frontend::service-detail', ['id' => $id]);
    }

    /**
     * Function : frontend search blog
     * Dev : Ta
     * Update Date : 8 August 2021
     * @param POST
     * @return json response 
     */
    public function accept_cookie()
    {
        $ip = get_ip_address();
        $attributes = [
            "ip_address" => $ip,
            "accept" => 1,
        ];

        $contact = Cookie::create($attributes);
        $contact->save();
    }

    /**
     * Function : save subscribe
     * Dev : Ta
     * Update Date : 23 August 2021
     * @param POST
     * @return json response 
     */
    public function subscribe_save(Request $request)
    {
        //Check input is null
        if ($request->get('subscribe_email') == "") {
            $resp = ['error' => 0, 'code' => 301, 'msg' => 'กรุณาระบุอีเมล!', 'focus' => 'subscribe_email'];
            return response()->json($resp);
        }
        $subscribe = Subscribe::where('email', $request->get('subscribe_email'))->first();
        if (!empty($subscribe)) {
            $resp = ['error' => 0, 'code' => 301, 'msg' => 'อีเมลนี้สมัครรับจดหมายข่าวของเราไปแล้ว!', 'focus' => 'subscribe_email'];
            return response()->json($resp);
        }

        //validate post data
        $validator = Validator::make($request->all(), [
            'subscribe_email' => 'required'
        ]);

        if ($validator->fails()) {
            $errors = $validator->errors();
            $resp = ['success' => 0, 'code' => 0, 'msg' => 'error', 'error' => $errors];
            return response()->json($resp);
        }

        $attributes = [
            "email" => $request->get('subscribe_email')
        ];

        $subscribe = Subscribe::create($attributes);
        $subscribe->save();
        $resp = ['success' => 1, 'code' => 200, 'msg' => 'Subscribe สำเร็จ'];

        return response()->json($resp);
    }

    /**
     * Function : search list blog
     * Dev : Ta
     * Update Date : 26 Aug 2021
     * @param POST
     * @return json response 
     */
    public function search_list(Request $request)
    {
        if ($request->text != '') {
            $lang = session()->get('frontend_lang');
            $blogs = Blogs::where('status', 1)
                ->select('id', 'name_' . (($lang == '') ? 'en' : $lang) . ' as name', 'publish_at', 'image')
                ->where('name_' . (($lang == '') ? 'en' : $lang), 'like', '%' . $request->text . '%')
                ->orderByDesc('sequence')
                ->get();
        } else {
            $blogs = [];
        }

        foreach ($blogs as $blog) {
?>
            <div class="result-row aslk">
                <div class="rsltw-img">
                    <div class="rsltwfitc"><img src="<?= ($blog->image != '' && CheckFileInServer($blog->image) ? $blog->image : '/storage/no_image/1920-940.png') ?>" alt="Alternate Text">
                    </div>
                </div>
                <div class="rsltw-cnnt">
                    <p class="title"><?= $blog->name ?></p>
                </div>
                <a class="tglk" href="<?= route('index.frontend.blog.blogDetail', $blog->id) ?>"></a>
            </div>
<?php
        }
    }
}
