$(document).ready(function () {
    // init for table all
    initDatatable();
});

setReloadDataTable = function () {
    $('#cookie-datatable').DataTable().ajax.reload(null, false);
}

initDatatable = function () {
    if ($('#cookie-datatable').length > 0) {
        oTable = $('#cookie-datatable').DataTable({
            "processing": true,
            "serverSide": true,
            "stateSave": true,
            "ajax": {
                "url": "/admin/cookie/datatable_ajax"
            },
            "columns": [
                { "data": "id" },
                { "data": "ip_address" },
                { "data": "accept", orderable: false, searchable: false },
                { "data": "created_at", orderable: false },
                { "data": "action", orderable: false, searchable: false }
            ]
        });
    }
}

setDelete = function (id) {
    bootbox.confirm({
        message: "ยืนยันการลบ? <br> หากดำเนิดการแล้วจะไม่สามารถย้อนกลับได้!",
        buttons: {
            confirm: {
                label: 'ยืนยัน',
                className: 'btn-success'
            },
            cancel: {
                label: 'ยกเลิก',
                className: 'btn-danger'
            }
        },
        callback: function (result) {
            if (result) {
                event.preventDefault();
                let _token = $('meta[name="csrf-token"]').attr('content');

                $.ajax({
                    url: "/admin/cookie/set_delete",
                    type: "POST",
                    data: {
                        id: id,
                        status: status,
                        _token: _token
                    },
                    success: function (resp) {
                        if (resp.success) {
                            mwz_noti('success', resp.msg);
                            setReloadDataTable();
                        } else {
                            mwz_noti('error', resp.msg);
                            setReloadDataTable();
                        }
                    },
                });
            }
        }
    });
}

ExportData = function () {
    $.ajax({
        url: "/admin/cookie/type_export",
        type: "GET",
        success: function (data) {
            $('#modal_content').html(data);
            $('#modal-content').modal('show');
        },
    });
}

HideModal = function () {
    $('#modal-content').modal('hide');
}

Select_Time = function () {
    var type = document.getElementById('type').value;
    if (type == 2) {
        document.getElementById('date_time').style.display = 'block';
    } else {
        document.getElementById('date_time').style.display = 'none';
    }
}