<?php

namespace Modules\Cookie\Http\Controllers;

use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\Frontend\Entities\Cookie;
use Yajra\DataTables\Facades\DataTables;

class CookieController extends Controller
{
    /**
     * Function : view index
     * Dev : Ta
     * Update Date : 23 Aug 2021
     * @param POST
     * @return view index
     */
    public function index()
    {
        return view('cookie::index');
    }

    /**
     * Function : cookie datatable ajax response 
     * Dev : Ta
     * Update Date : 23 Aug 2021
     * @param Get
     * @return json of cookie 
     */
    public function datatable_ajax(Request $request)
    {
        if ($request->ajax()) {
            //init datatable
            $dt_name_column = array('id', 'ip_address', 'created_at');
            $dt_order_column = $request->get('order')[0]['column'];
            $dt_order_dir = $request->get('order')[0]['dir'];
            $dt_start = $request->get('start');
            $dt_length = $request->get('length');
            $dt_search = $request->get('search')['value'];

            // create cookie object 
            $o_cookie = new Cookie;

            // add search query if have search from datable
            if (!empty($dt_search)) {
                $o_cookie->where('created_at', 'like', "%" . $dt_search . "%")
                    ->where('ip_address', 'like', "%" . $dt_search . "%");
            }

            // set query order & limit from datatable
            $o_cookie->orderBy($dt_name_column[$dt_order_column], $dt_order_dir)
                ->offset($dt_start)
                ->limit($dt_length);

            // query cookie as tree resule
            $cookie = $o_cookie->get();

            $GLOBALS['num'] = 1;

            // count all category
            $dt_total = $cookie->count();

            // prepare datatable for resonse
            $tables = DataTables::of($cookie)
                ->addIndexColumn()
                ->setRowId('id')
                ->setRowClass('master_row')
                ->setTotalRecords($dt_total)
                ->editColumn('id', function () {
                    return $GLOBALS['num']++;
                })
                ->editColumn('accept', function ($record) {
                    if ($record->accept == 0) {
                        $data = '<span class="tag tag-red">ไม่ยอมรับ</span>';
                    } else {
                        $data = '<span class="tag tag-green">ยอมรับ</span>';
                    }
                    return $data;
                })
                ->editColumn('created_at', function ($record) {
                    return $record->created_at->format('Y-m-d H:i:s');
                })
                ->addColumn('action', function ($record) {
                    $action_btn = '<div class="btn-list">';

                    $action_btn .= '<a onclick="setDelete(' . $record->id . ')" href="javascript:void(0);" class="btn btn-outline-danger"><i class="fa fa-trash"></i></a>';
                    $action_btn .= '</div>';

                    return $action_btn;
                })
                ->escapeColumns([]);

            // response datatable json
            return $tables->make(true);
        }
    }

    /**
     * Function : delete cookie 
     * Dev : Ta
     * Update Date : 23 Aug 2021
     * @param POST
     * @return json of delete cookie
     */
    public function set_delete(Request $request)
    {
        if ($request->ajax()) {
            $id = $request->get('id');
            $member = Cookie::find($id);

            if ($member->delete()) {
                $resp = ['success' => 1, 'code' => 200, 'msg' => 'บันทึกการเปลี่ยนแปลงสำเร็จ'];
            } else {
                $resp = ['success' => 0, 'code' => 500, 'msg' => 'เกิดข้อผิดพลาด โปรดลองใหม่อีกครั้ง!'];
            }

            return response()->json($resp);
        }
    }

    /**
     * Function : export cookie 
     * Dev : Ta
     * Update Date : 23 Aug 2021
     * @param POST
     * @return json of export cookie
     */
    public function export(Request $request)
    {
        if ($request->type == '1') {
            $cookies = Cookie::all();
        } else {
            $cookies = Cookie::whereRaw("DATE(created_at) >= '" . $request->date_start . "'")
                ->whereRaw("DATE(created_at) <= '" . $request->date_stop . "'")
                ->get();
        }

        $fileName = 'cookie.csv';
        $headers = array(
            "Content-Encoding"    => "UTF-8",
            "Content-type"        => "text/csv; charset=UTF-8",
            "Content-Disposition" => "attachment; filename=$fileName",
            "Pragma"              => "no-cache",
            "Cache-Control"       => "must-revalidate, post-check=0, pre-check=0",
            "Expires"             => "0"
        );

        $columns = array('ลำดับ', 'IP Address', 'Accept', 'สร้างเมื่อ');

        $callback = function () use ($cookies, $columns) {
            $file = fopen('php://output', 'w');
            //add BOM to fix UTF-8 in Excel
            fputs($file, $bom = (chr(0xEF) . chr(0xBB) . chr(0xBF)));
            fputcsv($file, $columns);

            foreach ($cookies as $index => $cookie) {
                fputcsv($file, array(
                    ($index + 1),
                    $cookie->ip_address,
                    $cookie->accept,
                    $cookie->created_at
                ));
            }

            fclose($file);
        };

        return response()->stream($callback, 200, $headers);
    }

    /**
     * Function : type export cookie 
     * Dev : Ta
     * Update Date : 23 Aug 2021
     * @param POST
     * @return html text
     */
    public function type_export()
    {
?>
        <form action="<?= route('admin.cookie.cookie.export') ?>" onsubmit="HideModal()" method="get" enctype="multipart/form-data">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Export data</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
            </div>
            <div class="modal-body">
                <select id="type" name="type" class="form-control" data-placeholder="Choose one" onchange="Select_Time()">
                    <option value="1">ทั้งหมด</option>
                    <option value="2">ตามวันที่</option>
                </select>
                <div id="date_time" style="display: none;">
                    <div class="form-group mt-3">
                        <label class="form-label">วันที่เริ่มต้น</label>
                        <input type="date" name="date_start" class="form-control" name="example-text-input" placeholder="Text..">
                    </div>
                    <div class="form-group">
                        <label class="form-label">วันที่สิ้นสุด</label>
                        <input type="date" name="date_stop" class="form-control" name="example-text-input" placeholder="Text..">
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-danger" data-dismiss="modal">ยกเลิก</button>
                <button type="submit" class="btn btn-success">ยืนยัน</button>
            </div>
        </form>
<?php
    }
}
