$(document).ready(function () {
    // init for table all
    initDatatable();

    lightGallery(document.getElementById('lightgallery_2'));

    //tab inti
    if ($('.first_tab').length > 0) {
        $(".first_tab").champ();
    }
});

initDatatable = function () {
    if ($('#contactus-datatable').length > 0) {
        oTable = $('#contactus-datatable').DataTable({
            "processing": true,
            "serverSide": true,
            "stateSave": true,
            "ajax": {
                "url": "/admin/contactus/datatable_ajax"
            },
            "columns": [
                { "data": "id" },
                { "data": "fullname" },
                { "data": "subject" },
                { "data": "created_at" },
                { "data": "status", orderable: false, searchable: false },
                { "data": "action", orderable: false, searchable: false }
            ]
        });
    }
}


setReloadDataTable = function () {
    $('#contactus-datatable').DataTable().ajax.reload(null, false);
}


setDelete = function (id) {
    bootbox.confirm({
        message: "คุณต้องการลบข้อมูลการติดต่อหรือไม่?",
        buttons: {
            confirm: {
                label: 'OK',
                className: 'btn-success'
            },
            cancel: {
                label: 'Cancel',
                className: 'btn-danger'
            }
        },
        callback: function (result) {
            if (result) {
                event.preventDefault();
                let _token = $('meta[name="csrf-token"]').attr('content');

                $.ajax({
                    url: "/admin/contactus/set_delete",
                    type: "POST",
                    data: {
                        id: id,
                        status: status,
                        _token: _token
                    },
                    success: function (resp) {
                        if (resp.success) {
                            mwz_noti('success', resp.msg);
                            setReloadDataTable();
                        } else {
                            mwz_noti('error', resp.msg);
                            setReloadDataTable();
                        }
                    },
                });
            }
        }
    });
}


// setDelete = function(id) {
//     bootbox.confirm("Are you sure to delete member?", function(result) {
//         if (result) {
//             event.preventDefault();
//             let _token = $('meta[name="csrf-token"]').attr('content');

//             $.ajax({
//                 url: "/admin/contactus/set_delete",
//                 type: "POST",
//                 data: {
//                     id: id,
//                     status: status,
//                     _token: _token
//                 },
//                 success: function(resp) {
//                     if (resp.success) {
//                         mwz_noti('success', resp.msg);
//                         setReloadDataTable();
//                     } else {
//                         mwz_noti('error', resp.msg);
//                         setReloadDataTable();
//                     }
//                 },
//             });
//         }
//     })
// }

setSave = function () {
    event.preventDefault();
    tinyMCE.triggerSave();
    var frm_data = new FormData($('#contactus_frm')[0]);
    $.ajax({
        url: "/admin/contactus/save",
        type: "POST",
        contentType: false,
        data: frm_data,
        processData: false,
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        success: function (resp) {
            if (resp.success) {
                mwz_noti('success', resp.msg);
                $('#replay-modal').modal('hide');
                setReloadDataTable();
            } else {
                mwz_noti('error', resp.msg);
                if (resp.focus) {
                    document.getElementById(resp.focus).focus();
                }
            }
        },
    });
}

setSaveContent = function () {
    event.preventDefault();
    tinyMCE.triggerSave();
    var frm_data = new FormData($('#content_frm')[0]);
    $.ajax({
        url: "/admin/contactus/content/save",
        type: "POST",
        contentType: false,
        data: frm_data,
        processData: false,
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        success: function (resp) {
            if (resp.success) {
                mwz_noti('success', resp.msg);
                window.location.reload();
            } else {
                mwz_noti('error', resp.msg);
            }
        },
    });
}

Replay_form = function (id) {
    $.ajax({
        url: '/admin/contactus/replay_form',
        type: 'GET',
        data: {
            id: id
        },
        success: function (data) {
            $('#replay_modal').html(data);
            $('#replay-modal').modal('show');
        },
    });
}

DeleteImage = function (id) {
    bootbox.confirm({
        message: "ยืนยันการลบ? <br> เมื่อดำเนินการแล้วจะไม่สามารถย้อนกลับได้!",
        buttons: {
            confirm: {
                label: 'ยืนยัน',
                className: 'btn-success'
            },
            cancel: {
                label: 'ยกเลิก',
                className: 'btn-danger'
            }
        },
        callback: function (result) {
            if (result) {
                let _token = $('meta[name="csrf-token"]').attr('content');
                $.ajax({
                    url: "/admin/contactus/delete_image",
                    type: "POST",
                    data: {
                        id: id,
                        _token: _token
                    },
                    success: function (resp) {
                        if (resp.success) {
                            mwz_noti('success', resp.msg);
                            window.location.reload();
                        } else {
                            mwz_noti('error', resp.msg);
                        }
                    },
                });
            }
        }
    });
}