<?php

namespace Modules\ContactUs\Http\Controllers;

use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
// use Illuminate\Support\Facades\Auth;
use Illuminate\Routing\Redirector;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\DB;

use Yajra\DataTables\Facades\DataTables;

use Modules\Mwz\Http\Controllers\MwzController;
use Modules\ContactUs\Entities\Contacts;
use Modules\Frontend\Entities\Content;
use Modules\User\Http\Controllers\RoleController;

class ContactUsController extends Controller
{

    /**
     * Display a listing of the resource.
     * @return Renderable
     */
    public function index()
    {
        return view('contactus::index');
    }

    /**
     * Display a listing of the resource.
     * @return Renderable
     */
    public function content()
    {
        return view('contactus::content');
    }

    /**
     * Function : contactus datatable ajax response 
     * Dev : Dave
     * Update Date : 14 jul 2021
     * @param Get
     * @return json of contactus 
     */
    public function datatable_ajax(Request $request)
    {
        if ($request->ajax()) {
            //init datatable
            $dt_name_column = array('id', 'fullname', 'subject', 'created_at');
            $dt_order_column = $request->get('order')[0]['column'];
            $dt_order_dir = $request->get('order')[0]['dir'];
            $dt_start = $request->get('start');
            $dt_length = $request->get('length');
            $dt_search = $request->get('search')['value'];

            // create contactus object 
            $o_contactus = new Contacts;

            // add search query if have search from datable
            if (!empty($dt_search)) {
                $o_contactus->where('created_at', 'like', "%" . $dt_search . "%")
                    ->where('fullname', 'like', "%" . $dt_search . "%")
                    ->where('subject', 'like', "%" . $dt_search . "%");
            }

            // set query order & limit from datatable
            $o_contactus->orderBy($dt_name_column[$dt_order_column], $dt_order_dir)
                ->offset($dt_start)
                ->limit($dt_length);

            // query contactus as tree resule
            $contactus = $o_contactus->get();

            $GLOBALS['num'] = 1;

            // count all category
            $dt_total = $contactus->count();

            // prepare datatable for resonse
            $tables = Datatables::of($contactus)
                ->addIndexColumn()
                ->setRowId('id')
                ->setRowClass('master_row')
                ->setTotalRecords($dt_total)
                ->editColumn('id', function () {
                    return $GLOBALS['num']++;
                })
                ->editColumn('status', function ($record) {
                    if ($record->status == 0) {
                        $data = '<span class="tag tag-yellow">ใหม่</span>';
                    } else {
                        $data = '<span class="tag tag-green">ตอบกลับแล้ว</span>';
                    }
                    return $data;
                })
                ->editColumn('created_at', function ($record) {
                    return $record->created_at->format('Y-m-d H:i:s');
                })
                ->addColumn('action', function ($record) {
                    $action_btn = '<div class="btn-list">';

                    $action_btn .= '<a onclick="Replay_form(' . $record->id . ')" href="javascript:void(0);" class="btn btn-outline-primary"><i class="fa fa-pencil"></i></a>';
                    $action_btn .= '<a onclick="setDelete(' . $record->id . ')" href="javascript:void(0);" class="btn btn-outline-danger"><i class="fa fa-trash"></i></a>';
                    $action_btn .= '</div>';

                    return $action_btn;
                })
                ->escapeColumns([]);

            // response datatable json
            return $tables->make(true);
        }
    }

    /**
     * Function :  member save 
     * Dev : Dave
     * Update Date : 08 jul 2021
     * @param POST
     * @return json response status
     */
    public function save(Request $request)
    {
        if (empty($request->get('replay'))) {
            $resp = ['error' => 0, 'code' => 301, 'msg' => 'กรุณาระบุข้อความตอบกลับ!', 'focus' => 'replay'];
            return response()->json($resp);
        }

        //validate post data
        $validator = Validator::make($request->all(), [
            'id' => 'integer',
            'replay' => 'required',
            'email' => 'required'
        ]);

        if ($validator->fails()) {
            $errors = $validator->errors();
            $resp = ['success' => 0, 'code' => 0, 'msg' => 'เกิดข้อผิดพลาด โปรดลองใหม่อีกครั้ง!', 'error' => $errors];
            return response()->json($resp);
        }

        $attributes = [
            "replay" => $request->get('replay'),
            "status" => 1
        ];

        $contact = Contacts::where('id', $request->get('id'))->update($attributes);
        $resp = ['success' => 1, 'code' => 200, 'msg' => 'ตอบกลับสำเร็จ'];

        send_mail_contact($request->get('replay'), $request->get('email'));

        return response()->json($resp);
    }

    /**
     * Function : delete  category 
     * Dev : Dave
     * Update Date : 14 jul 2021
     * @param POST
     * @return json of delete status
     */
    public function set_delete(Request $request)
    {
        if ($request->ajax()) {
            $id = $request->get('id');
            $member = Contacts::find($id);

            if ($member->delete()) {
                $resp = ['success' => 1, 'code' => 200, 'msg' => 'บันทึกการเปลี่ยนแปลงสำเร็จ'];
            } else {
                $resp = ['success' => 0, 'code' => 500, 'msg' => 'เกิดข้อผิดพลาด โปรดลองใหม่อีกครั้ง!'];
            }

            return response()->json($resp);
        }
    }

    /**
     * Function :  content contact save
     * Dev : Ta
     * Update Date : 20 Aug 2021
     * @param POST
     * @return json response
     */
    public function content_save(Request $request)
    {
        $attributes_1 = [
            "content_data_th" => $request->get('content_id_7_th'),
            "content_data_en" => $request->get('content_id_7_en')
        ];
        if ($request->hasFile('content_id_8')) {
            $image = $request->file('content_id_8');
            $new_filename = time() . "." . $image->extension();
            $path = $image->storeAs(
                'public/contactus',
                $new_filename
            );
            $attributes['content_data_th'] = Storage::url($path);
            $attributes['content_data_en'] = Storage::url($path);
            Content::where('id', 8)->update($attributes);
        }
        $attributes_3 = [
            "content_data_th" => $request->get('content_id_9_th'),
            "content_data_en" => $request->get('content_id_9_en')
        ];
        $attributes_4 = [
            "content_data_th" => $request->get('content_id_10_th'),
            "content_data_en" => $request->get('content_id_10_en')
        ];
        $attributes_5 = [
            "content_data_th" => $request->get('content_id_11'),
            "content_data_en" => $request->get('content_id_11')
        ];
        $attributes_6 = [
            "content_data_th" => $request->get('content_id_12'),
            "content_data_en" => $request->get('content_id_12')
        ];
        $attributes_7 = [
            "content_data_th" => $request->get('content_id_13'),
            "content_data_en" => $request->get('content_id_13')
        ];
        if ($request->hasFile('content_id_14')) {
            $image = $request->file('content_id_14');
            $new_filename = time() . "." . $image->extension();
            $path = $image->storeAs(
                'public/contactus',
                $new_filename
            );
            $attributes['content_data_th'] = Storage::url($path);
            $attributes['content_data_en'] = Storage::url($path);
            Content::where('id', 14)->update($attributes);
        }
        $attributes_9 = [
            "content_data_th" => $request->get('content_id_15_th'),
            "content_data_en" => $request->get('content_id_15_en')
        ];
        $attributes_10 = [
            "content_data_th" => $request->get('content_id_16_th'),
            "content_data_en" => $request->get('content_id_16_en')
        ];
        $attributes_11 = [
            "content_data_th" => $request->get('content_id_17'),
            "content_data_en" => $request->get('content_id_17')
        ];
        $attributes_12 = [
            "content_data_th" => $request->get('content_id_18'),
            "content_data_en" => $request->get('content_id_18')
        ];
        $attributes_13 = [
            "content_data_th" => $request->get('content_id_19'),
            "content_data_en" => $request->get('content_id_19')
        ];

        $content_1 = Content::where('id', 7)->update($attributes_1);
        $content_3 = Content::where('id', 9)->update($attributes_3);
        $content_4 = Content::where('id', 10)->update($attributes_4);
        $content_5 = Content::where('id', 11)->update($attributes_5);
        $content_6 = Content::where('id', 12)->update($attributes_6);
        $content_7 = Content::where('id', 13)->update($attributes_7);
        $content_9 = Content::where('id', 15)->update($attributes_9);
        $content_10 = Content::where('id', 16)->update($attributes_10);
        $content_11 = Content::where('id', 17)->update($attributes_11);
        $content_12 = Content::where('id', 18)->update($attributes_12);
        $content_13 = Content::where('id', 19)->update($attributes_13);
        if ($content_1 && $content_3 && $content_4 && $content_5 && $content_6 && $content_7 && $content_9 && $content_10 && $content_11 && $content_12 && $content_13) {
            $resp = ['success' => 1, 'code' => 200, 'msg' => 'บันทึกการเปลี่ยนแปลงสำเร็จ'];
        } else {
            $resp = ['error' => 0, 'code' => 301, 'msg' => 'เกิดข้อผิดพลาด โปรดลองใหม่อีกครั้ง!'];
        }

        return response()->json($resp);
    }

    /**
     * Function : contactus form
     * Dev : Ta
     * Update Date : 21 Aug 2021
     * @param GET
     * @return contact form modal
     */
    public function replay_form(Request $request)
    {
        $contactus = Contacts::where('id', $request->id)->first();
?>
        <form id="contactus_frm" name="contactus_frm" method="POST" onsubmit="setSave(); return false;" enctype="multipart/form-data">
            <?php @csrf_token() ?>
            <div class="modal-header">
                <h5 class="modal-title" id="example-Modal3">ข้อมูลผู้ติดต่อ</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <input type="hidden" id="hnnjfn" name="id" value="<?= !empty($contactus->id) ? $contactus->id : '0' ?>">
                <div class="form-group">
                    <label class="form-label">ชื่อ-นามสกุลผู้ติดต่อ</label>
                    <input type="text" class="form-control" name="fullname" placeholder="ชื่อ-นามสกุลผู้ติดต่อ" value="<?= !empty($contactus->fullname) ? $contactus->fullname : '' ?>" readonly>
                </div>
                <div class="form-group">
                    <label class="form-label">วันที่ติดต่อ</label>
                    <input type="text" class="form-control" name="modify_date" placeholder="วันที่ติดต่อ" value="<?= !empty($contactus->created_at) ? date('m/d/Y H:i:s', strtotime($contactus->created_at)) : '' ?>" readonly>
                </div>
                <div class="form-group">
                    <label class="form-label">เบอร์โทรศัพท์</label>
                    <input type="text" class="form-control" name="phone" placeholder="เบอร์โทรศัพท์" value="<?= !empty($contactus->phone) ? $contactus->phone : '' ?>" readonly>
                </div>
                <div class="form-group">
                    <label class="form-label">อีเมล์</label>
                    <input type="text" class="form-control" name="email" placeholder="อีเมล์" value="<?= !empty($contactus->email) ? $contactus->email : '' ?>" readonly>
                </div>
                <div class="form-group">
                    <label class="form-label">เรื่องที่ติดต่อ</label>
                    <input type="text" class="form-control" name="subject" placeholder="subject" value="<?= !empty($contactus->subject) ? $contactus->subject : '' ?>" readonly>
                </div>
                <div class="form-group">
                    <label class="form-label">รายละเอียด</label>
                    <textarea class="form-control" name="message" rows="4" placeholder="message here.." readonly><?= !empty($contactus->message) ? $contactus->message : '' ?></textarea>
                </div>
                <div class="form-group">
                    <label class="form-label">ตอบกลับ</label>
                    <textarea <?= $contactus->status == 1 ? 'readonly' : '' ?> class="form-control" name="replay" id="replay" rows="4" placeholder="ข้อความติดต่อกลับ.."><?= !empty($contactus->replay) ? $contactus->replay : '' ?></textarea>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">ปิดหน้าต่าง</button>
                <?php if ($contactus->status != 1) { ?>
                    <button type="submit" class="btn btn-primary">ตอบกลับ</button>
                <?php } ?>
            </div>
        </form>
<?php
    }

    /**
     * Function : delete image
     * Dev : Ta
     * Update Date : 25 Aug 2021
     * @param POST
     * @return json of response
     */
    public function delete_image(Request $request)
    {
        if ($request->ajax()) {
            $id = $request->get('id');

            $contact = Content::find($id);
            $contact->content_data_th = '';
            $contact->content_data_en = '';

            if ($contact->save()) {
                $resp = ['success' => 1, 'code' => 200, 'msg' => 'บันทึกการเปลี่ยนแปลงสำเร็จ'];
            } else {
                $resp = ['success' => 0, 'code' => 500, 'msg' => 'เกิดข้อผิดพลาด โปรดลองใหม่อีกครั้ง!'];
            }

            return response()->json($resp);
        }
    }
}
