<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateContactTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('contact', function (Blueprint $table) {
            $table->id();
            $table->string('fullname', 250);
            $table->string('email', 250);
            $table->string('phone', 250);
            $table->string('subject', 200);
            $table->text('message');
            $table->text('replay')->nullable();
            $table->tinyInteger('status')->length(2)->default(0)->comment('0=ยังไม่ได้ตอบ, 1=ตอบแล้ว');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('contact');
    }
}
