<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::prefix('admin/career')->group(function() {
    Route::get('/', 'CareerController@index')->name('admin.career.career.index') ;
    Route::get('/datatable_ajax', 'CareerController@datatable_ajax')->name('admin.career.career.datatable_ajax') ;

    Route::post('/set_status', 'CareerController@set_status')->name('admin.career.career.set_status') ;
    Route::post('/save', 'CareerController@save')->name('admin.career.career.save') ;
    Route::post('/set_delete', 'CareerController@set_delete')->name('admin.career.career.set_delete') ;
    
    Route::get('/edit/{category_id}', 'CareerController@form')->name('admin.career.career.edit') ;
    Route::get('/add', 'CareerController@form')->name('admin.career.career.add') ;

    Route::get('/header_career/1', 'CareerController@header_career')->name('admin.career.header.edit') ;
    Route::post('/career_save', 'CareerController@career_save')->name('admin.career.header.save') ;
});


Route::prefix('admin/candidate')->group(function() {
    Route::get('/', 'CandidateController@index')->name('admin.career.candidate.index') ;
    Route::get('/datatable_ajax', 'CandidateController@datatable_ajax')->name('admin.career.candidate.datatable_ajax') ;
    
    Route::get('/edit/{category_id}', 'CandidateController@form')->name('admin.career.candidate.edit') ;
    Route::post('/set_delete', 'CandidateController@set_delete')->name('admin.career.candidate.set_delete') ;
});
