@extends('layouts.app')

@section('styles')

    <!---Tabs css-->
    <link href="{{ URL::asset('assets/plugins/tabs/tabs-style.css') }}" rel="stylesheet" />

    <!--Select2 css -->
    <link href="{{ URL::asset('assets/plugins/select2/select2.min.css') }}" rel="stylesheet" />

    <!-- Datetime Picker css-->
    <link rel="stylesheet" href="{{ URL::asset('assets/plugins/datetime-picker/bootstrap-datetimepicker.min.css') }}">

    <!-- File Uploads css-->
    <link href="{{ URL::asset('assets/plugins/fileuploads/css/dropify.css') }}" rel="stylesheet" type="text/css" />

    <!--Mutipleselect css-->
    <link rel="stylesheet" href="{{ URL::asset('assets/plugins/multipleselect/multiple-select.css') }}">

@endsection

@section('content')

    <!-- page-header -->
    <div class="page-header">
        <ol class="breadcrumb">
            <!-- breadcrumb -->
            <li class="breadcrumb-item"><a href="{{ route('admin.websetting.websetting.edit') }}">หน้าหลัก</a></li>
            <li class="breadcrumb-item active" aria-current="page"><a
                    href="{{ route('admin.career.career.index') }}">ประกาศสมัครงาน</a></li>
            <li class="breadcrumb-item active" aria-current="page">
                {{ !empty($career->id) ? 'จัดการข้อมูลประกาศสมัครงาน' : 'เพิ่มข้อมูลประกาศสมัครงาน' }}</li>
        </ol><!-- End breadcrumb -->
    </div>
    <!-- End page-header -->

    <!-- row -->
    <div class="row">
        <div class="col-md-12">
            <form id="career_frm" name="career_frm" method="POST" onsubmit="setSave(); return false;"
                enctype="multipart/form-data">
                @csrf
                <input type="hidden" name="id" value="{{ !empty($career->id) ? $career->id : '0' }}">
                <div class="card">
                    <div class="card-body">
                        <div class="panel panel-primary">
                            {{-- Start Tap --}}
                            <div class="tab_wrapper first_tab">
                                <ul class="tab_list">
                                    <li class="icons-list-item" style="height: 36px;" title="ภาษาไทย"><i
                                            class="flag flag-th"></i></li>
                                    <li class="icons-list-item" style="height: 36px;" title="ภาษาอังกฤษ"><i
                                            class="flag flag-gb"></i></li>
                                </ul>
                                <div class="content_wrapper">
                                    {{-- Tap 1 --}}
                                    <div class="tab_content active">
                                        {{-- Start Input --}}
                                        <div class="alert alert-default" role="alert" title="ภาษาไทย">
                                            <span class="alert-inner--icon"><i class="fe fe-bell"></i></i></span>
                                            <span class="alert-inner--text">คุณกำลังแก้ไขการแสดงผล
                                                <strong>ภาษาไทย</strong></span>
                                        </div>
                                        <div class="form-group" title="หัวข้อประกาศสมัครงาน (TH)">
                                            <label class="form-label">หัวข้อประกาศสมัครงาน (TH)</label>
                                            <input type="text" class="form-control" name="title_th" id="title_th" placeholder="ตำแหน่งงาน"
                                                value="{{ !empty($career->title_th) ? $career->title_th : '' }}">
                                        </div>
                                        <div class="form-group" title="รายละเอียด (TH)">
                                            <label class="form-label">รายละเอียด (TH)</label>
                                            <textarea class="form-control texteditor" name="description_th" id="description_th" rows="6"
                                                placeholder="รายละเอียดตำแหน่งประกาศสมัครงาน..">{{ !empty($career->description_th) ? mwz_getTextString($career->description_th) : '' }}</textarea>
                                        </div>
                                        {{-- End Input --}}
                                    </div>
                                    {{-- End Tap 1 --}}
                                    {{-- Tap 2 --}}
                                    <div class="tab_content">
                                        {{-- Start Input --}}
                                        <div class="alert alert-default" role="alert" title="ภาษอังกฤษ">
                                            <span class="alert-inner--icon"><i class="fe fe-bell"></i></i></span>
                                            <span class="alert-inner--text">คุณกำลังแก้ไขการแสดงผล
                                                <strong>ภาษอังกฤษ</strong></span>
                                        </div>
                                        <div class="form-group" title="หัวข้อประกาศสมัครงาน (EN)">
                                            <label class="form-label">หัวข้อประกาศสมัครงาน (EN)</label>
                                            <input type="text" class="form-control" name="title_en" id="title_en" placeholder="ตำแหน่งงาน"
                                                value="{{ !empty($career->title_en) ? $career->title_en : '' }}">
                                        </div>
                                        <div class="form-group" title="รายละเอียด (EN)">
                                            <label class="form-label">รายละเอียด (EN)</label>
                                            <textarea class="form-control texteditor" name="description_en" id="description_en" rows="6"
                                                placeholder="รายละเอียดตำแหน่งประกาศสมัครงาน..">{{ !empty($career->description_en) ? mwz_getTextString($career->description_en) : '' }}</textarea>
                                        </div>
                                        {{-- End Input --}}
                                    </div>
                                    {{-- End Tap 2 --}}
                                </div>
                            </div>
                            {{-- End Tap --}}
                            <div class="card mt-3">
                                <div class="card-body">
                                    <div class="form-group" title="ภาษอังกฤษ">
                                        <label class="form-label">สถานะ</label>
                                        <div class="form-check form-check-inline">
                                            <input class="form-check-input" type="radio" name="status" id="status_enable"
                                                value="1"
                                                {{ isset($career->status) ? ($career->status == 1 ? 'checked' : '') : 'checked' }}>
                                            <label class="form-check-label" for="status_enable">เปิด</label>
                                        </div>
                                        <div class="form-check form-check-inline">
                                            <input class="form-check-input" type="radio" name="status" id="status_disable"
                                                value="0"
                                                {{ isset($career->status) ? ($career->status == 0 ? 'checked' : '') : '' }}>
                                            <label class="form-check-label" for="status_disable">ปิด</label>
                                        </div>
                                        </label>
                                    </div>
                                    <div class="form-group">
                                        <div class="btn-list">
                                            <button type="submit" class="btn btn-primary"><i class="ion-checkmark-circled mr-1"></i>{{ !empty($career->id) ? 'บันทึกการเปลี่ยนแปลง' : 'เพิ่มรายการใหม่' }}</button>
                                            <button onclick="mwz_redirect('{{ route('admin.career.career.index') }}');"
                                                type="button" class="btn btn-warning"><i class="fa fa-undo"
                                                    aria-hidden="true"></i>ยกเลิก</button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
    <!-- .row -->

@endsection('content')

@section('scripts')

    <!--Jquery Sparkline js-->
    <script src="{{ URL::asset('assets/plugins/vendors/jquery.sparkline.min.js') }}"></script>

    <!-- File uploads js -->
    <script src="{{ URL::asset('assets/plugins/fileuploads/js/dropify.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/fileuploads/js/dropify-demo.js') }}"></script>

    <!--Select2 js -->
    <script src="{{ URL::asset('assets/plugins/select2/select2.full.min.js') }}"></script>
    <!-- <script src="{{ URL::asset('assets/js/form-elements.js') }}"></script> -->

    <!--MutipleSelect js-->
    <script src="{{ URL::asset('assets/plugins/multipleselect/multiple-select.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/multipleselect/multi-select.js') }}"></script>

    <!--ckeditor js-->
    <script src="{{ URL::asset('assets/plugins/tinymce/tinymce.min.js') }}"></script>
    <!-- <script src="{{ URL::asset('assets/js/formeditor.js') }}"></script> -->

    <!-- Datetimepicker js -->
    <script src="{{ URL::asset('assets/plugins/datetime-picker/moment.min.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/datetime-picker/bootstrap-datetimepicker.min.js') }}"></script>

    <!-- Notifications js -->
    <link href="{{ URL::asset('assets/plugins/notify-growl/css/jquery.growl.css') }}" rel="stylesheet" />
    <link href="{{ URL::asset('assets/plugins/notify-growl/css/notifIt.css') }}" rel="stylesheet" />
    <script src="{{ URL::asset('assets/plugins/bootbox/bootbox.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/notify-growl/js/rainbow.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/notify-growl/js/jquery.growl.js') }}"></script>

    <!-- validator js -->
    <script src="{{ URL::asset('assets/plugins/validator/js/jquery.validate.min.js') }}"></script>

    <!-- Tabs js -->
    <script src="{{ URL::asset('assets/plugins/tabs/jquery.multipurpose_tabcontent.js') }}"></script>
    <!-- <script src="{{ URL::asset('assets/plugins/tabs/tabs.js') }}"></script> -->

    <!-- mwz master js css -->
    <link rel="stylesheet" href="{{ mix('css/mwz.css') }}">
    <script src="{{ mix('js/mwz.js') }}"></script>

    <!-- module js css -->
    <link rel="stylesheet" href="{{ mix('css/career.css') }}">
    <script src="{{ mix('js/career.js') }}"></script>

@endsection
