$(document).ready(function () {
    // init for table all
    initDatatable();

    initDatatableCandidate();

    //tab inti
    if ($('.first_tab').length > 0) {
        $(".first_tab").champ();
    }
});

setReloadDataTable = function () {
    $('#career-datatable').DataTable().ajax.reload(null, false);
    $('#candidate-datatable').DataTable().ajax.reload(null, false);
}

initDatatable = function () {
    if ($('#career-datatable').length > 0) {
        oTable = $('#career-datatable').DataTable({
            "processing": true,
            "serverSide": true,
            "stateSave": true,
            "ajax": {
                "url": "/admin/career/datatable_ajax"
            },
            "columns": [
                { "data": "id" },
                { "data": "title_th" },
                { "data": "updated_at" },
                { "data": "action", orderable: false, searchable: false }
            ]
        });
    }
}

initDatatableCandidate = function () {
    if ($('#candidate-datatable').length > 0) {
        oTable = $('#candidate-datatable').DataTable({
            "processing": true,
            "serverSide": true,
            "stateSave": true,
            "ajax": {
                "url": "/admin/candidate/datatable_ajax"
            },
            "columns": [
                { "data": "id", orderable: true, searchable: false },
                { "data": "created_at" },
                { "data": "title_th" },
                { "data": "fullname" },
                { "data": "action", orderable: false, searchable: false }
            ]
        });
    }
}

setUpdateStatus = function (id, status) {
    event.preventDefault();
    let _token = $('meta[name="csrf-token"]').attr('content');

    $.ajax({
        url: "/admin/career/set_status",
        type: "POST",
        data: {
            id: id,
            status: status,
            _token: _token
        },
        success: function (resp) {
            if (resp.success) {
                mwz_noti('success', resp.msg);
                setReloadDataTable();
            } else {
                mwz_noti('error', resp.msg);
                setReloadDataTable();
            }
        },
    });
}

setDelete = function (id) {
    bootbox.confirm({
        message: "คุณต้องการลบข้อมูลการสมัครงานหรือไม่?",
        buttons: {
            confirm: {
                label: 'OK',
                className: 'btn-success'
            },
            cancel: {
                label: 'Cancel',
                className: 'btn-danger'
            }
        },
        callback: function (result) {
            if (result) {
                event.preventDefault();
                let _token = $('meta[name="csrf-token"]').attr('content');

                $.ajax({
                    url: "/admin/career/set_delete",
                    type: "POST",
                    data: {
                        id: id,
                        status: status,
                        _token: _token
                    },
                    success: function (resp) {
                        if (resp.success) {
                            mwz_noti('success', resp.msg);
                            setReloadDataTable();
                        } else {
                            mwz_noti('error', resp.msg);
                            setReloadDataTable();
                        }
                    },
                });
            }
        }
    });
}

setDeleteCandidate = function (id) {
    bootbox.confirm({
        message: "คุณต้องการลบข้อมูลการสมัครงานหรือไม่?",
        buttons: {
            confirm: {
                label: 'OK',
                className: 'btn-success'
            },
            cancel: {
                label: 'Cancel',
                className: 'btn-danger'
            }
        },
        callback: function (result) {
            if (result) {
                event.preventDefault();
                let _token = $('meta[name="csrf-token"]').attr('content');

                $.ajax({
                    url: "/admin/candidate/set_delete",
                    type: "POST",
                    data: {
                        id: id,
                        status: status,
                        _token: _token
                    },
                    success: function (resp) {
                        if (resp.success) {
                            mwz_noti('success', resp.msg);
                            setReloadDataTable();
                        } else {
                            mwz_noti('error', resp.msg);
                            setReloadDataTable();
                        }
                    },
                });
            }
        }
    });
}


setSave = function () {
    event.preventDefault();
    tinyMCE.triggerSave();
    var frm_data = new FormData($('#career_frm')[0]);
    $.ajax({
        url: "/admin/career/save",
        type: "POST",
        contentType: false,
        data: frm_data,
        processData: false,
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        beforeSend: function (xhr) {

            if ($("#career_frm").valid()) {
                return $("#career_frm").valid();
            } else {
                mwz_noti('error', resp.msg);
                return $("#career_frm").valid();
            }
        },
        success: function (resp) {
            if (resp.success) {
                mwz_noti('success', resp.msg);
                window.location.href = '/admin/career/';
            } else {
                mwz_noti('error', resp.msg);
                if (resp.focus) {
                    document.getElementById(resp.focus).focus();
                }
            }
        },
    });
}

setSaveHeader = function () {
    event.preventDefault();
    tinyMCE.triggerSave();

    var frm_data = new FormData($('#header_frm_career')[0]);

    $.ajax({
        url: "/admin/career/career_save",
        type: "POST",
        contentType: false,
        data: frm_data,
        processData: false,
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        success: function (resp) {
            if (resp.success) {
                mwz_noti('success', resp.msg);
                window.location.href = '/admin/career/header_career/1';
            } else {
                mwz_noti('error', resp.msg);
            }
        },
    });

}