<?php

namespace Modules\Career\Http\Controllers;

use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Routing\Redirector;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\DB;

use Yajra\DataTables\Facades\DataTables;
use Kalnoy\Nestedset\NestedSet;

use Modules\Mwz\Http\Controllers\MwzController;
use Modules\Career\Entities\Careers;
use Modules\Frontend\Entities\Content;
use Modules\User\Http\Controllers\RoleController;

class CareerController extends Controller
{
    /**
     * Display a listing of the resource.
     * @return Renderable
     */
    public function index()
    {
        return view('career::index');
    }

    /**
     * Function : career header
     * Dev : pop
     * Update Date : 14 Jul 2021
     * @param Get
     * @return form_header.blade view
     */
    public function header_career()
    {
        $content = Content::find(6);

        return view('career::form_header_career', ['content_id_6' => $content]);
    }


    /**
     * Function : service header_save
     * Dev : pop
     * Update Date : 11 Jul 2021
     * @param POST
     * @return json response status
     */
    public function career_save(Request $request)
    {
        $attributes = [
            "content_data_th" => mwz_setTextString($request->get('content_id_6_th')),
            "content_data_en" => mwz_setTextString($request->get('content_id_6_en'))
        ];

        $content = Content::where('id', 6)->update($attributes);
        if ($content) {
            $resp = ['success' => 1, 'code' => 200, 'msg' => 'อัปเดตข้อมูลสำเร็จ'];
        } else {
            $resp = ['error' => 0, 'code' => 301, 'msg' => 'อัปเดตข้อมูลไม่สำเร็จ'];
        }

        return response()->json($resp);
    }


    /**
     * Function : career datatable_ajax response 
     * Dev : Dave
     * Update Date : 22 jul 2021
     * @param Get
     * @return json of career 
     */
    public function datatable_ajax(Request $request)
    {
        if ($request->ajax()) {
            //init datatable
            $dt_name_column = array('id', 'title_th', 'updated_at', 'action');
            $dt_order_column = $request->get('order')[0]['column'];
            $dt_order_dir = $request->get('order')[0]['dir'];
            $dt_start = $request->get('start');
            $dt_length = $request->get('length');
            $dt_search = $request->get('search')['value'];


            // create career object 
            $o_career = new careers;

            // add search query if have search from datable
            if (!empty($dt_search)) {
                $o_career->where('title_th', 'like', "%" . $dt_search . "%");
            }

            // set query order & limit from datatable
            $o_career->orderBy($dt_name_column[$dt_order_column], $dt_order_dir)
                ->offset($dt_start)
                ->limit($dt_length);

            // query career as tree resule
            $career = $o_career->get();

            // count all category
            $dt_total = $career->count();

            $GLOBALS['num'] = 1;

            // prepare datatable for resonse
            $tables = Datatables::of($career)
                ->addIndexColumn()
                ->setRowId('id')
                ->setRowClass('career_row')
                ->setTotalRecords($dt_total)
                ->editColumn('id', function () {
                    return $GLOBALS['num']++;
                })
                ->editColumn('updated_at', function ($record) {
                    return $record->updated_at->format('Y-m-d H:i:s');
                })
                ->addColumn('action', function ($record) {
                    $action_btn = '<div class="btn-list">';

                    if ($record->status == 1) {
                        $action_btn .= '<a onclick="setUpdateStatus(' . $record->id . ',0)" href="javascript:void(0);" class="btn btn-outline-success"><i class="fa fa-check"></i></a></a>';
                    } else {
                        $action_btn .=  '<a onclick="setUpdateStatus(' . $record->id . ',1)" href="javascript:void(0);"  class="btn btn-outline-warning"><i class="fa fa-times"></i></a></a>';
                    }

                    $action_btn .= '<a href="' . route('admin.career.career.edit', $record->id) . '" class="btn btn-outline-primary"><i class="fa fa-pencil"></i></a></a>';
                    $action_btn .= '<a onclick="setDelete(' . $record->id . ')" href="javascript:void(0);" class="btn btn-outline-danger"><i class="fa fa-trash"></i></a></a>';
                    $action_btn .= '</div>';

                    return $action_btn;
                })
                ->escapeColumns([]);

            // response datatable json
            return $tables->make(true);
        }
    }

    /**
     * Function : add career form
     * Dev : Dave
     * Update Date : 22 jul 2021
     * @param GET
     * @return category form view
     */
    public function form($id = 0)
    {
        $career = [];
        if (!empty($id)) {
            $career = careers::find($id);
        }
        return view('career::form', ['career' => $career]);
    }

    /**
     * Function : update career  status
     * Dev : Dave
     * Update Date : 22 jul 2021
     * @param POST
     * @return json of update status
     */
    public function set_status(Request $request)
    {
        if ($request->ajax()) {
            $id = $request->get('id');
            $status = $request->get('status');

            $career = careers::find($id);
            $career->status = $status;

            if ($career->save()) {
                $resp = ['success' => 1, 'code' => 200, 'msg' => 'อัปเดตสถานะข้อมูลการสมัครงานสำเร็จ'];
            } else {
                $resp = ['success' => 0, 'code' => 500, 'msg' => 'อัปเดตสถานะข้อมูลการสมัครงานไม่สำเร็จ!'];
            }

            return response()->json($resp);
        }
    }

    /**
     * Function :  career save 
     * Dev : Dave
     * Update Date : 22 jul 2021
     * @param POST
     * @return json response status
     */
    public function save(Request $request)
    {
        if (empty($request->get('title_th'))) {
            $resp = ['error' => 0, 'code' => 301, 'msg' => 'โปรดระบุหัวข้อประกาศสมัครงานภาษาไทย!', 'focus' => 'title_th'];
            return response()->json($resp);
        }

        if (empty($request->get('title_en'))) {
            $resp = ['error' => 0, 'code' => 301, 'msg' => 'โปรดระบุหัวข้อประกาศสมัครงานภาษาอังกฤษ!', 'focus' => 'title_en'];
            return response()->json($resp);
        }

        if (empty($request->get('description_th'))) {
            $resp = ['error' => 0, 'code' => 301, 'msg' => 'โปรดระบุรายละเอียดภาษาไทย!', 'focus' => 'description_th'];
            return response()->json($resp);
        }

        if (empty($request->get('description_en'))) {
            $resp = ['error' => 0, 'code' => 301, 'msg' => 'โปรดระบุรายละเอียดภาษาอังกฤษ!', 'focus' => 'description_en'];
            return response()->json($resp);
        }

        //validate post data
        $validator = Validator::make($request->all(), [
            'id' => 'integer',
            'title_th' => 'required',
            'title_en' => 'required',
            'description_th' => 'required',
            'description_en' => 'required',
            'status' => 'required|integer',
            // 'image'=>'mimes:jpeg,jpg,png,gif|max:2048',	
        ]);

        if ($validator->fails()) {
            $errors = $validator->errors();
            $resp = ['success' => 0, 'code' => 0, 'msg' => 'error', 'error' => $errors];
            return response()->json($resp);
        }

        $now = DB::raw('NOW()');

        $attributes = [
            "title_th" => $request->get('title_th'),
            "title_en" => $request->get('title_en'),
            "description_th" => mwz_setTextString($request->get('description_th')),
            "description_en" => mwz_setTextString($request->get('description_en')),
            "status" => $request->get('status')
        ];
        $attributes2 = [
            "title_th" => $request->get('title_th'),
            "title_en" => $request->get('title_en'),
            "description_th" => mwz_setTextString($request->get('description_th')),
            "description_en" => mwz_setTextString($request->get('description_en')),
            "modify_date" => date("Y-m-d H:i:s"),
            "status" => $request->get('status')
        ];
        if (!empty($request->get('id'))) {
            $career_category = careers::where('id', $request->get('id'))->update($attributes);
            $resp = ['success' => 1, 'code' => 200, 'msg' => 'อัปเดตข้อมูลสำเร็จ'];
        } else {
            $career_category = careers::create($attributes2);
            if (!empty($request->get('id'))) {
                $career_category->id = $request->get('id');
            }
            $career_category->save();
            $resp = ['success' => 1, 'code' => 200, 'msg' => 'บันทึกข้อมูลสำเร็จ'];
        }

        return response()->json($resp);
    }

    /**
     * Function : delete  category 
     * Dev : Dave
     * Update Date : 22 jul 2021
     * @param POST
     * @return json of delete status
     */
    public function set_delete(Request $request)
    {
        if ($request->ajax()) {
            $id = $request->get('id');
            $career = careers::find($id);

            if ($career->delete()) {
                $resp = ['success' => 1, 'code' => 200, 'msg' => 'ลบข้อมูลการสมัครงานสำเร็จ'];
            } else {
                $resp = ['success' => 0, 'code' => 500, 'msg' => 'ลบข้อมูลการสมัครงานไม่สำเร็จ!'];
            }

            return response()->json($resp);
        }
    }
}
