<?php

namespace Modules\Career\Http\Controllers;

use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Routing\Redirector;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\DB;

use Yajra\DataTables\Facades\DataTables;
use Kalnoy\Nestedset\NestedSet;

use Modules\Mwz\Http\Controllers\MwzController;
use Modules\Career\Entities\Candidates;
use Modules\User\Http\Controllers\RoleController;

class CandidateController extends Controller
{
    /**
     * Display a listing of the resource.
     * @return Renderable
     */
    public function index()
    {
        return view('career::candidate ');
    }

    /**
     * Function : career datatable_ajax response 
     * Dev : Dave
     * Update Date : 22 jul 2021
     * @param Get
     * @return json of career 
     */
    public function datatable_ajax(Request $request)
    {
        if ($request->ajax()) {
            //init datatable
            $dt_name_column = array('id', 'created_at', 'career_id', 'fullname');
            $dt_order_column = $request->get('order')[0]['column'];
            $dt_order_dir = $request->get('order')[0]['dir'];
            $dt_start = $request->get('start');
            $dt_length = $request->get('length');
            $dt_search = $request->get('search')['value'];

            // create career object 
            $o_career = new Candidates;

            // add search query if have search from datable
            if (!empty($dt_search)) {
                $o_career->where('created_at', 'like', "%" . $dt_search . "%")
                    ->where('career_id', 'like', "%" . $dt_search . "%")
                    ->where('fullname', 'like', "%" . $dt_search . "%");
            }

            // set query order & limit from datatable
            $o_career->orderBy($dt_name_column[$dt_order_column], $dt_order_dir)
                ->offset($dt_start)
                ->limit($dt_length);

            // query career as tree resule
            $career = $o_career
                ->join('career', 'candidate.career_id', '=', 'career.id')
                ->select('candidate.id', 'candidate.created_at', 'candidate.fullname', 'career.title_th')
                ->get();

            // count all category
            $dt_total = $career->count();

            $GLOBALS['num'] = 1;

            // prepare datatable for resonse
            $tables = Datatables::of($career)
                ->addIndexColumn()
                ->setRowId('id')
                ->setRowClass('master_row')
                ->setTotalRecords($dt_total)
                ->editColumn('id', function () {
                    return $GLOBALS['num']++;
                })
                ->editColumn('created_at', function ($record) {
                    return $record->created_at->format('Y-m-d H:i:s');
                })
                ->addColumn('action', function ($record) {
                    $action_btn = '<div class="btn-list">';
                    $action_btn .= '<a href="' . route('admin.career.candidate.edit', $record->id) . '" class="btn btn-outline-primary"><i class="fa fa-search "></i></a></a>';
                    $action_btn .= '<a onclick="setDeleteCandidate(' . $record->id . ')" href="javascript:void(0);" class="btn btn-outline-danger"><i class="fa fa-trash"></i></a></a>';
                    $action_btn .= '</div>';

                    return $action_btn;
                })
                ->escapeColumns([]);

            // response datatable json
            return $tables->make(true);
        }
    }

    /**
     * Function : add career form
     * Dev : Dave
     * Update Date : 23 jul 2021
     * @param GET
     * @return category form view
     */
    public function form($id = 0)
    {
        $candidate = [];
        if (!empty($id)) {
            $candidate = Candidates::join('career', 'candidate.career_id', '=', 'career.id')
                ->where('candidate.id', $id)
                ->first();
        }
       
        return view('career::formcandidate', ['career' => $candidate]);
    }

    /**
     * Function : delete  candidate 
     * Dev : Ta
     * Update Date : 26 Aug 2021
     * @param POST
     * @return json of delete
     */
    public function set_delete(Request $request)
    {
        if ($request->ajax()) {
            $id = $request->get('id');
            $candidate = Candidates::find($id);

            if ($candidate->delete()) {
                $resp = ['success' => 1, 'code' => 200, 'msg' => 'ลบข้อมูลการสมัครงานสำเร็จ'];
            } else {
                $resp = ['success' => 0, 'code' => 500, 'msg' => 'ลบข้อมูลการสมัครงานไม่สำเร็จ!'];
            }

            return response()->json($resp);
        }
    }
}
