<?php

namespace Modules\Career\Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class CareerDatabaseSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        Model::unguard();

        $now = DB::raw('NOW()');
        DB::statement("ALTER TABLE career AUTO_INCREMENT=1");
        DB::table('career')->truncate();
        DB::table('career')->insert([
            'id'=> 1,
            'title_th' => 'Job positions IT',
            'title_en' => 'Job positions IT',
            'header_career_th' => 'ตำแหน่งาน',
            'header_career_en' => 'positions',
            'description_th' => 'The account development manager develops the potential of accounts and works closely with sales.',
            'description_en' => 'The account development manager develops the potential of accounts and works closely with sales.',
            'annouce_date'=>$now,
            'modify_date'=>$now,
            'status'=>1,
            'created_at'=>$now,
            'updated_at'=>$now
        ]);

        DB::statement("ALTER TABLE candidate AUTO_INCREMENT=1");
        DB::table('candidate')->truncate();
        DB::table('candidate')->insert([
            'id'  => 1,
            'career_id'  => 1,
            'fullname'  =>'Fullname test',
            'email'  =>'netdesignhost@netdesignhost.com',
            'mobile'  =>'0899999999',
            'cv_file'  =>'cv.pdf',
            'register_date'=>$now,
            'status'  => 1,
            'created_at'=>$now,
            'updated_at'=>$now
        ]);
    }
}
