<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCareerTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('career', function (Blueprint $table) {
            $table->id();
            $table->string('title_th', 250);
            $table->string('title_en', 250);
            $table->text('description_th')->comment('รายละเอียดตำแหน่งงาน');
            $table->text('description_en')->comment('รายละเอียดตำแหน่งงาน');
            $table->dateTime('annouce_date')->comment('วันที่ประกาศรับสมัคร');
            $table->integer('status')->length(1)->default(0)->comment('0=เปิด , 1 = ปิด');
            $table->timestamps();
        });
        Schema::create('candidate', function (Blueprint $table) {
            $table->id();
            $table->integer('career_id')->length(1)->default(0);
            $table->string('fullname', 200)->comment('ชื่อผู้สมัคร');
            $table->string('email', 200)->comment('อีเมล');
            $table->string('mobile', 20);
            $table->string('cv_file', 700);
            $table->integer('status')->length(1)->default(0)->comment('0=เปิด , 1 = ปิด');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('career');
    }
}
