<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::group(['middleware' => 'auth:admin'], function () {
    Route::prefix('admin/blog')->group(function () {

        Route::get('/index', 'BlogAdminController@index')->name('admin.blog.blog.index');
        Route::get('/datatable_ajax', 'BlogAdminController@datatable_ajax')->name('admin.blog.blog.datatable_ajax');

        Route::get('/add', 'BlogAdminController@form')->name('admin.blog.blog.add');
        Route::get('/edit/{category_id}', 'BlogAdminController@form')->name('admin.blog.blog.edit');
        Route::post('/save', 'BlogAdminController@save')->name('admin.blog.blog.save');

        Route::post('/set_status', 'BlogAdminController@set_status')->name('admin.blog.blog.set_status');
        Route::post('/set_delete', 'BlogAdminController@set_delete')->name('admin.blog.blog.set_delete');

        Route::get('/category', 'BlogAdminController@category')->name('admin.blog.category.index');
        Route::get('/category_datatable_ajax', 'BlogAdminController@category_datatable_ajax')->name('admin.blog.category.datatable_ajax');

        Route::get('/category/edit/{category_id}', 'BlogAdminController@category_form')->name('admin.blog.category.edit');
        Route::post('/category/save', 'BlogAdminController@category_save')->name('admin.blog.category.save');

        Route::post('/set_category_status', 'BlogAdminController@set_category_status')->name('admin.blog.category.set_category_status');
        Route::post('/delete_image', 'BlogAdminController@delete_image')->name('admin.blog.delete_image');
    });
});
