@extends('layouts.app')

@section('styles')

    <!---Tabs css-->
    <link href="{{ URL::asset('assets/plugins/tabs/tabs-style.css') }}" rel="stylesheet" />
    <!--Select2 css -->
    <link href="{{ URL::asset('assets/plugins/select2/select2.min.css') }}" rel="stylesheet" />
    <!-- Datetime Picker css-->
    <link rel="stylesheet" href="{{ URL::asset('assets/plugins/datetime-picker/bootstrap-datetimepicker.min.css') }}">
    <!-- File Uploads css-->
    <link href="{{ URL::asset('assets/plugins/fileuploads/css/dropify.css') }}" rel="stylesheet" type="text/css" />
    <!--Mutipleselect css-->
    <link rel="stylesheet" href="{{ URL::asset('assets/plugins/multipleselect/multiple-select.css') }}">
    <!-- Gallery css -->
    <link href="{{ URL::asset('assets/plugins/gallery/gallery.css') }}" rel="stylesheet">

@endsection

@section('content')

    <!-- page-header -->
    <div class="page-header">
        <ol class="breadcrumb">
            <!-- breadcrumb -->
            <li class="breadcrumb-item"><a href="{{ route('admin.websetting.websetting.edit') }}">หน้าหลัก</a></li>
            <li class="breadcrumb-item active" aria-current="page"><a
                    href="{{ route('admin.blog.blog.index') }}">บล็อก</a></li>
            <li class="breadcrumb-item active" aria-current="page">
                {{ !empty($blog->id) ? 'จัดการข้อมูลบล็อก' : 'เพิ่มข้อมูลบล็อก' }}</li>
        </ol><!-- End breadcrumb -->
    </div>
    <!-- End page-header -->

    <!-- row -->
    <div class="row">
        <div class="col-md-12">
            <form id="blog_frm" name="blog_frm" method="POST" onsubmit="setSave(); return false;"
                enctype="multipart/form-data">
                @csrf
                <input type="hidden" name="id" value="{{ !empty($blog->id) ? $blog->id : '0' }}">
                <div class="card">
                    <div class="card-body">
                        <div class="panel panel-primary">
                            <div class="form-group mt-3">
                                @if (empty($blog->image))
                                    <div class="card">
                                        <div class="card-header pb-0">
                                            <h3 class="mb-0 card-title">อัปโหลดรูปภาพ</h3>
                                        </div>
                                        <div class="card-body">
                                            <input type="file" name="image" class="dropify" data-default-file="" />
                                        </div>
                                        <label class="ml-5">ขนาดรูปภาพ 1920 x 940px</label>
                                    </div>
                                @else
                                    <div class="demo-gallery card">
                                        <div class="card-header pb-0">
                                            <div class="card-title">รูปภาพที่อัปโหลด</div>
                                        </div>
                                        <div class="card-body row">
                                            <div class="col-md-5"></div>
                                            <div class="col-md-2">
                                                <ul id="lightgallery" class="list-unstyled">
                                                    <li data-responsive="{{ $blog->image }}"
                                                        data-src="{{ $blog->image }}">
                                                        <a href="">
                                                            <img class="img-responsive" src="{{ $blog->image }}"
                                                                alt="Thumb-1">
                                                        </a>
                                                    </li>
                                                </ul>
                                            </div>
                                            <div class="col-md-5"></div>
                                            <label>ขนาดรูปภาพ 1920 x 940px</label>
                                            <button type="button" onclick="DeleteImage('{{ $blog->id }}',2)"
                                                class="btn btn-outline-danger btn-block">ลบรูปภาพ</button>
                                        </div>
                                    </div>
                                @endif
                            </div>
                            {{-- Start Tap --}}
                            <div class="tab_wrapper first_tab">
                                <ul class="tab_list">
                                    <li class="icons-list-item" style="height: 36px;" title="ภาษาไทย"><i
                                            class="flag flag-th"></i></li>
                                    <li class="icons-list-item" style="height: 36px;" title="ภาษาอังกฤษ"><i
                                            class="flag flag-gb"></i></li>
                                </ul>
                                <div class="content_wrapper">
                                    {{-- Tap 1 --}}
                                    <div class="tab_content active">
                                        {{-- Start Input --}}
                                        <div class="alert alert-default" role="alert" title="ภาษาไทย">
                                            <span class="alert-inner--icon"><i class="fe fe-bell"></i></i></span>
                                            <span class="alert-inner--text">คุณกำลังแก้ไขการแสดงผล
                                                <strong>ภาษาไทย</strong></span>
                                        </div>
                                        <div class="form-group" title="ชื่อหัวข้อบล็อก (TH)">
                                            <label class="form-label">ชื่อหัวข้อบล็อก (TH)</label>
                                            <input type="text" class="form-control" name="name_th" id="name_th"
                                                placeholder="ชื่อหัวข้อภาษาไทย"
                                                value="{{ !empty($blog->name_th) ? $blog->name_th : '' }}">
                                        </div>
                                        <div class="form-group" title="รายละเอียด (TH)">
                                            <label class="form-label">รายละเอียด (TH)</label>
                                            <textarea id="description_th" class="form-control texteditor"
                                                name="description_th" rows="4"
                                                placeholder="คำอธิบาย">{{ !empty($blog->description_th) ? $blog->description_th : '' }}</textarea>
                                        </div>
                                        {{-- End Input --}}
                                    </div>
                                    {{-- End Tap 1 --}}
                                    {{-- Tap 2 --}}
                                    <div class="tab_content">
                                        {{-- Start Input --}}
                                        <div class="alert alert-default" role="alert" title="ภาษอังกฤษ">
                                            <span class="alert-inner--icon"><i class="fe fe-bell"></i></i></span>
                                            <span class="alert-inner--text">คุณกำลังแก้ไขการแสดงผล
                                                <strong>ภาษอังกฤษ</strong></span>
                                        </div>
                                        <div class="form-group" title="ชื่อหัวข้อบล็อก (EN)">
                                            <label class="form-label">ชื่อหัวข้อบล็อก (EN)</label>
                                            <input type="text" class="form-control" name="name_en" id="name_en"
                                                placeholder="ชื่อหัวข้อภาษาอังกฤษ"
                                                value="{{ !empty($blog->name_en) ? $blog->name_en : '' }}">
                                        </div>
                                        <div class="form-group" title="รายละเอียด (EN)">
                                            <label class="form-label">รายละเอียด (EN)</label>
                                            <textarea id="description_en" class="form-control texteditor"
                                                name="description_en" rows="4"
                                                placeholder="description">{{ !empty($blog->description_en) ? $blog->description_en : '' }}</textarea>
                                        </div>
                                        {{-- End Input --}}
                                    </div>
                                    {{-- End Tap 2 --}}
                                </div>
                            </div>
                            {{-- End Tap --}}
                            <div class="card mt-3">
                                <div class="card-body">
                                    <div class="form-group ">
                                        <label class="form-label">หมวดหมู่</label>
                                        <select class="form-control select2 custom-select" name="category_id"
                                            id="category_id" data-placeholder="Choose one">
                                            <option value="0">-- กรุณาเลือกหมวดหมู่ --</option>
                                            @foreach ($categories as $category)
                                                <option value="{{ $category->id }}"
                                                    {{ !empty($blog->category_id) ? ($blog->category_id == $category->id ? 'selected' : '') : '' }}>
                                                    {{ $category->name_th }}</option>
                                            @endforeach
                                        </select>
                                    </div>

                                    <div class="form-group">
                                        <label class="form-label">Tags</label>
                                        <input type="text" class="form-control" name="tags" id="tags"
                                            placeholder="โปรดระบุ tags"
                                            value="{{ !empty($blog->tags) ? $blog->tags : '' }}">
                                        <span style="color: red">หมายเหตุ: การเพิ่ม Tags ต้องขั้นด้วย comma(,)
                                            เท่านั้น!</span>
                                    </div>

                                    <div class="form-group" title="วันที่กำหนดให้เผยแพร่">
                                        <label class="form-label">กำหนดวันที่สร้าง</label>
                                        <div class="wd-200 mg-b-30">
                                            <div class="input-group">
                                                <div class="input-group-prepend">
                                                    <div class="input-group-text">
                                                        <i class="fa fa-calendar tx-16 lh-0 op-6"></i>
                                                    </div>
                                                </div><input autocomplete="off" class="form-control fc-datepicker"
                                                    name="publish_at" id="publish_at" placeholder="MM/DD/YYYY" type="text"
                                                    value="{{ !empty($blog->publish_at) ? date('m/d/Y', strtotime($blog->publish_at)) : '' }}">
                                            </div>
                                        </div>
                                    </div>

                                    <div class="form-group">
                                        <label class="form-label">URL Youtube</label>
                                        <textarea id="link" class="form-control" name="link" placeholder="URL Youtube"
                                            rows="4">{{ !empty($blog->link) ? $blog->link : '' }}</textarea>
                                    </div>

                                    <div class="form-group" title="อัปโหลดไฟล์ PDF">
                                        <label class="form-label">อัปโหลดไฟล์ PDF</label>
                                        <div class="input-group file-browser">
                                            <input type="text" class="form-control border-right-0 browse-file"
                                                placeholder="อัปโหลดไฟล์ PDF" readonly>
                                            <label class="input-group-btn mb-0">
                                                <span class="btn btn-primary">
                                                    Browse <input type="file" name="file" style="display: none;"
                                                        accept="application/pdf" multiple>
                                                </span>
                                            </label>
                                        </div>
                                    </div>

                                    <div class="form-group" title="ลำดับการแสดงผล">
                                        <label class="form-label">ลำดับการแสดงผล</label>
                                        <input type="text" class="form-control" name="sequence" id="sequence"
                                            placeholder="ลำดับการแสดงผล"
                                            value="{{ !empty($blog->sequence) ? $blog->sequence : '' }}"
                                            onkeypress="return isNumberKey(event)">
                                    </div>

                                    <div class="form-group" title="สถานะ">
                                        <label class="form-label">สถานะ</label>
                                        <div class="form-check form-check-inline">
                                            <input class="form-check-input" type="radio" name="status" id="status_enable"
                                                value="1"
                                                {{ isset($blog->status) ? ($blog->status == 1 ? 'checked' : '') : 'checked' }}>
                                            <label class="form-check-label" for="status_enable">เปิด</label>
                                        </div>
                                        <div class="form-check form-check-inline">
                                            <input class="form-check-input" type="radio" name="status" id="status_disable"
                                                value="0"
                                                {{ isset($blog->status) ? ($blog->status == 0 ? 'checked' : '') : '' }}>
                                            <label class="form-check-label" for="status_disable">ปิด</label>
                                        </div>
                                        </label>
                                    </div>

                                    <div class="form-group mt-5">
                                        <div class="btn-list">
                                            <button type="submit" class="btn btn-primary"><i class="ion-checkmark-circled mr-1"></i>{{ !empty($blog->id) ? 'บันทึกการเปลี่ยนแปลง' : 'เพิ่มรายการใหม่' }}</button>
                                            <button onclick="mwz_redirect('{{ route('admin.blog.blog.index') }}');"
                                                type="button" class="btn btn-warning"><i class="fa fa-undo"
                                                    aria-hidden="true"></i>ยกเลิก</button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
    <!-- .row -->

@endsection('content')

@section('scripts')

    <!--Jquery Sparkline js-->
    <script src="{{ URL::asset('assets/plugins/vendors/jquery.sparkline.min.js') }}"></script>

    <!-- File uploads js -->
    <script src="{{ URL::asset('assets/plugins/fileuploads/js/dropify.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/fileuploads/js/dropify-demo.js') }}"></script>

    <!--Select2 js -->
    <script src="{{ URL::asset('assets/plugins/select2/select2.full.min.js') }}"></script>
    <script src="{{ URL::asset('assets/js/form-elements.js') }}"></script>

    <!--ckeditor js-->
    <script src="{{ URL::asset('assets/plugins/tinymce/tinymce.min.js') }}"></script>
    <!-- <script src="{{ URL::asset('assets/js/formeditor.js') }}"></script> -->

    <!-- Datepicker js -->
    <script src="{{ URL::asset('assets/plugins/spectrum-date-picker/spectrum.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/spectrum-date-picker/jquery-ui.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/input-mask/jquery.maskedinput.js') }}"></script>

    <!-- Notifications js -->
    <link href="{{ URL::asset('assets/plugins/notify-growl/css/jquery.growl.css') }}" rel="stylesheet" />
    <link href="{{ URL::asset('assets/plugins/notify-growl/css/notifIt.css') }}" rel="stylesheet" />
    <script src="{{ URL::asset('assets/plugins/bootbox/bootbox.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/notify-growl/js/rainbow.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/notify-growl/js/jquery.growl.js') }}"></script>

    <!-- validator js -->
    <script src="{{ URL::asset('assets/plugins/validator/js/jquery.validate.min.js') }}"></script>

    <!-- Tabs js -->
    <script src="{{ URL::asset('assets/plugins/tabs/jquery.multipurpose_tabcontent.js') }}"></script>
    <!-- <script src="{{ URL::asset('assets/plugins/tabs/tabs.js') }}"></script> -->

    <!--MutipleSelect js-->
    <script src="{{ URL::asset('assets/plugins/multipleselect/multiple-select.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/multipleselect/multi-select.js') }}"></script>

    <!-- Gallery js -->
    <script src="{{ URL::asset('assets/plugins/gallery/picturefill.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/gallery/lightgallery.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/gallery/lg-pager.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/gallery/lg-zoom.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/gallery/lg-hash.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/gallery/lg-share.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/gallery/gallery.js') }}"></script>

    <!-- mwz master js css -->
    <link rel="stylesheet" href="{{ mix('css/mwz.css') }}">
    <script src="{{ mix('js/mwz.js') }}"></script>

    <!-- module js css -->
    <link rel="stylesheet" href="{{ mix('css/blog.css') }}">
    <script src="{{ mix('js/blog.js') }}"></script>
    <script>
        //NumberKey ลำดัการแสดงผล
        function isNumberKey(evt) {
            var charCode = (evt.which) ? evt.which : event.keyCode
            if (charCode > 31 && (charCode < 48 || charCode > 57))
                return false;
            return true;
        }
    </script>

@endsection
