@extends('layouts.app')

@section('styles')

    <!---Tabs css-->
    <link href="{{ URL::asset('assets/plugins/tabs/tabs-style.css') }}" rel="stylesheet" />

    <!--Select2 css -->
    <link href="{{ URL::asset('assets/plugins/select2/select2.min.css') }}" rel="stylesheet" />

    <!-- Datetime Picker css-->
    <link rel="stylesheet" href="{{ URL::asset('assets/plugins/datetime-picker/bootstrap-datetimepicker.min.css') }}">

    <!-- File Uploads css-->
    <link href="{{ URL::asset('assets/plugins/fileuploads/css/dropify.css') }}" rel="stylesheet" type="text/css" />

    <!--Mutipleselect css-->
    <link rel="stylesheet" href="{{ URL::asset('assets/plugins/multipleselect/multiple-select.css') }}">

    <!-- Gallery css -->
    <link href="{{ URL::asset('assets/plugins/gallery/gallery.css') }}" rel="stylesheet">

@endsection

@section('content')

    <!-- page-header -->
    <div class="page-header">
        <ol class="breadcrumb">
            <!-- breadcrumb -->
            <li class="breadcrumb-item"><a href="{{ route('admin.websetting.websetting.edit') }}">หน้าหลัก</a></li>
            <li class="breadcrumb-item active" aria-current="page"><a
                    href="{{ route('admin.blog.category.index') }}">หมวดหมู่</a></li>
            <li class="breadcrumb-item active" aria-current="page">
                {{ !empty($category->id) ? 'จัดการข้อมูลหมวดหมู่' : '' }}</li>
        </ol><!-- End breadcrumb -->
    </div>
    <!-- End page-header -->

    <!-- row -->
    <div class="row">
        <div class="col-md-12">
            <form id="blog_category_frm" name="blog_category_frm" method="POST"
                onsubmit="setSaveCategory(this); return false;" enctype="multipart/form-data">
                @csrf
                <input type="hidden" name="id" value="{{ !empty($category->id) ? $category->id : '0' }}">
                <div class="card">
                    <div class="card-body">
                        <div class="panel panel-primary">
                            {{-- Start Tap --}}
                            <div class="tab_wrapper first_tab">
                                <ul class="tab_list">
                                    <li class="icons-list-item" style="height: 36px;" title="ภาษาไทย"><i
                                            class="flag flag-th"></i></li>
                                    <li class="icons-list-item" style="height: 36px;" title="ภาษาอังกฤษ"><i
                                            class="flag flag-gb"></i></li>
                                </ul>
                                <div class="content_wrapper">
                                    {{-- Tap 1 --}}
                                    <div class="tab_content active">
                                        {{-- Start Input --}}
                                        <div class="alert alert-default" role="alert" title="ภาษาไทย">
                                            <span class="alert-inner--icon"><i class="fe fe-bell"></i></i></span>
                                            <span class="alert-inner--text">คุณกำลังแก้ไขการแสดงผล
                                                <strong>ภาษาไทย</strong></span>
                                        </div>
                                        <div class="form-group" title="ชื่อหมวดหมู่ (TH)">
                                            <label class="form-label">ชื่อหมวดหมู่ (TH)</label>
                                            <input id="name_th" type="text" class="form-control" name="name_th"
                                                value="{{ !empty($category->name_th) ? $category->name_th : '' }}"
                                                placeholder="ชื่อหมวดหมู่">
                                            <input id="param" type="hidden" class="form-control" name="param" value=""
                                                placeholder="param">
                                        </div>
                                        <div class="form-group" title="รายละเอียด (TH)">
                                            <label class="form-label">รายละเอียด (TH)</label>
                                            <textarea id="blog_category_description_th" class="form-control texteditor"
                                                name="description_th" rows="4"
                                                placeholder="คำอธิบาย">{{ !empty($category->description_th) ? $category->description_th : '' }}</textarea>
                                        </div>
                                        {{-- End Input --}}
                                    </div>
                                    {{-- End Tap 1 --}}
                                    {{-- Tap 2 --}}
                                    <div class="tab_content">
                                        {{-- Start Input --}}
                                        <div class="alert alert-default" role="alert" title="ภาษอังกฤษ">
                                            <span class="alert-inner--icon"><i class="fe fe-bell"></i></i></span>
                                            <span class="alert-inner--text">คุณกำลังแก้ไขการแสดงผล
                                                <strong>ภาษอังกฤษ</strong></span>
                                        </div>
                                        <div class="form-group" title="ชื่อหมวดหมู่ (EN)">
                                            <label class="form-label">ชื่อหมวดหมู่ (EN)</label>
                                            <input id="name_en" type="text" class="form-control" name="name_en"
                                                value="{{ !empty($category->name_en) ? $category->name_en : '' }}"
                                                placeholder="Name">
                                            <input id="param" type="hidden" class="form-control" name="param" value=""
                                                placeholder="param">
                                        </div>
                                        <div class="form-group" title="รายละเอียด (EN">
                                            <label class="form-label">รายละเอียด (EN)</label>
                                            <textarea id="blog_category_description_en" class="form-control texteditor"
                                                name="description_en" rows="4"
                                                placeholder="description">{{ !empty($category->description_en) ? $category->description_en : '' }}</textarea>
                                        </div>
                                        {{-- End Input --}}
                                    </div>
                                    {{-- End Tap 2 --}}
                                </div>
                            </div>
                            {{-- End Tap --}}
                            <div class="form-group mt-3">
                                @if (empty($category->image))
                                    <div class="card">
                                        <div class="card-header pb-0">
                                            <h3 class="mb-0 card-title">อัปโหลดรูปภาพ</h3>
                                        </div>
                                        <div class="card-body">
                                            <input type="file" name="image" class="dropify" data-default-file="" />
                                        </div>
                                        <label class="ml-5">ขนาดรูปภาพ 420 x 260px</label>
                                    </div>
                                @else
                                    <div class="demo-gallery card">
                                        <div class="card-header pb-0">
                                            <div class="card-title">รูปภาพที่อัปโหลด</div>
                                        </div>
                                        <div class="card-body row">
                                            <div class="col-md-5"></div>
                                            <div class="col-md-2">
                                                <ul id="lightgallery" class="list-unstyled">
                                                    <li data-responsive="{{ $category->image }}"
                                                        data-src="{{ $category->image }}">
                                                        <a href="">
                                                            <img class="img-responsive" src="{{ $category->image }}"
                                                                alt="Thumb-1">
                                                        </a>
                                                    </li>
                                                </ul>
                                            </div>
                                            <div class="col-md-5"></div>
                                            <label>ขนาดรูปภาพ 420 x 260px</label>
                                            <button type="button" onclick="DeleteImage('{{ $category->id }}',1)"
                                                class="btn btn-outline-danger btn-block">ลบรูปภาพ</button>
                                        </div>
                                    </div>
                                @endif
                            </div>
                            <div class="form-group" title="สถานะ">
                                <label class="form-label">สถานะ</label>
                                <div class="form-check form-check-inline">
                                    <input class="form-check-input" type="radio" name="status" id="status_enable" value="1"
                                        {{ isset($category->status) ? ($category->status == 1 ? 'checked' : '') : 'checked' }}>
                                    <label class="form-check-label" for="status_enable">เปิด</label>
                                </div>
                                <div class="form-check form-check-inline">
                                    <input class="form-check-input" type="radio" name="status" id="status_disable" value="0"
                                        {{ isset($category->status) ? ($category->status == 0 ? 'checked' : '') : '' }}>
                                    <label class="form-check-label" for="status_disable">ปิด</label>
                                </div>
                                </label>
                            </div>
                            <div class="form-group">
                                <div class="btn-list">
                                    <button type="submit" class="btn btn-primary"><i class="ion-checkmark-circled mr-1"></i>บันทึกการเปลี่ยนแปลง</button>
                                    <button onclick="mwz_redirect('{{ route('admin.blog.category.index') }}');"
                                        type="button" class="btn btn-warning"><i class="fa fa-undo"
                                            aria-hidden="true"></i>ยกเลิก</button>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
    <!-- .row -->

@endsection('content')

@section('scripts')

    <!--Jquery Sparkline js-->
    <script src="{{ URL::asset('assets/plugins/vendors/jquery.sparkline.min.js') }}"></script>

    <!-- File uploads js -->
    <script src="{{ URL::asset('assets/plugins/fileuploads/js/dropify.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/fileuploads/js/dropify-demo.js') }}"></script>

    <!--Select2 js -->
    <script src="{{ URL::asset('assets/plugins/select2/select2.full.min.js') }}"></script>
    <!-- <script src="{{ URL::asset('assets/js/form-elements.js') }}"></script> -->

    <!--MutipleSelect js-->
    <script src="{{ URL::asset('assets/plugins/multipleselect/multiple-select.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/multipleselect/multi-select.js') }}"></script>

    <!--ckeditor js-->
    <script src="{{ URL::asset('assets/plugins/tinymce/tinymce.min.js') }}"></script>
    <!-- <script src="{{ URL::asset('assets/js/formeditor.js') }}"></script> -->

    <!-- Datetimepicker js -->
    <script src="{{ URL::asset('assets/plugins/datetime-picker/moment.min.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/datetime-picker/bootstrap-datetimepicker.min.js') }}"></script>

    <!-- Notifications js -->
    <link href="{{ URL::asset('assets/plugins/notify-growl/css/jquery.growl.css') }}" rel="stylesheet" />
    <link href="{{ URL::asset('assets/plugins/notify-growl/css/notifIt.css') }}" rel="stylesheet" />
    <script src="{{ URL::asset('assets/plugins/bootbox/bootbox.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/notify-growl/js/rainbow.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/notify-growl/js/jquery.growl.js') }}"></script>

    <!-- Gallery js -->
    <script src="{{ URL::asset('assets/plugins/gallery/picturefill.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/gallery/lightgallery.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/gallery/lg-pager.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/gallery/lg-zoom.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/gallery/lg-hash.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/gallery/lg-share.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/gallery/gallery.js') }}"></script>

    <!-- validator js -->
    <script src="{{ URL::asset('assets/plugins/validator/js/jquery.validate.min.js') }}"></script>

    <!-- Tabs js -->
    <script src="{{ URL::asset('assets/plugins/tabs/jquery.multipurpose_tabcontent.js') }}"></script>
    <!-- <script src="{{ URL::asset('assets/plugins/tabs/tabs.js') }}"></script> -->

    <!-- mwz master js css -->
    <link rel="stylesheet" href="{{ mix('css/mwz.css') }}">
    <script src="{{ mix('js/mwz.js') }}"></script>

    <!-- module js css -->
    <link rel="stylesheet" href="{{ mix('css/blog.css') }}">
    <script src="{{ mix('js/blog.js') }}"></script>

@endsection
