$(document).ready(function () {
    // init for blog
    initDatatable();

    // init for blog category
    initCategorydatatable();

    //tab inti
    if ($('.first_tab').length > 0) {
        $(".first_tab").champ();
    }

});


$(function () {
    'use strict'
    // Datepicker
    $('.fc-datepicker').datepicker({
        showOtherMonths: true,
        selectOtherMonths: true
    });

    $('#datepickerNoOfMonths').datepicker({
        showOtherMonths: true,
        selectOtherMonths: true,
        numberOfMonths: 2
    });

});

$(document).on('change', ':file', function () {
    var input = $(this),
        numFiles = input.get(0).files ? input.get(0).files.length : 1,
        label = input.val().replace(/\\/g, '/').replace(/.*\//, '');
    input.trigger('fileselect', [numFiles, label]);
});

// Upload file
$(document).ready(function () {
    $(':file').on('fileselect', function (event, numFiles, label) {

        var input = $(this).parents('.input-group').find(':text'),
            log = numFiles > 1 ? numFiles + ' files selected' : label;

        if (input.length) {
            input.val(log);
        } else {
            //if (log) alert(log);
        }

    });
});
// =========================  blog =========================== //

initDatatable = function () {
    if ($('#blog-datatable').length > 0) {
        oTable = $('#blog-datatable').DataTable({
            "processing": true,
            "serverSide": true,
            "stateSave": true,
            "ajax": {
                "url": "/admin/blog/datatable_ajax"
            },
            "columns": [
                { "data": "sequence" },
                { "data": "image", orderable: false, searchable: false },
                { "data": "name_th" },
                { "data": "cat_name" },
                { "data": "updated_at" },
                { "data": "action", orderable: false, searchable: false }
            ]
        });
    }
}

setReloadDataTable = function () {
    $('#blog-datatable').DataTable().ajax.reload(null, false);
}

setUpdateStatus = function (id, status) {
    event.preventDefault();
    let _token = $('meta[name="csrf-token"]').attr('content');

    $.ajax({
        url: "/admin/blog/set_status",
        type: "POST",
        data: {
            id: id,
            status: status,
            _token: _token
        },
        success: function (resp) {
            if (resp.success) {
                mwz_noti('success', resp.msg);
                setReloadDataTable();
            } else {
                mwz_noti('error', resp.msg);
                setReloadDataTable();
            }
        },
    });
}

setDelete = function (id) {
    bootbox.confirm({
        message: "คุณต้องการลบข้อมูลบล็อกหรือไม่?",
        buttons: {
            confirm: {
                label: 'OK',
                className: 'btn-success'
            },
            cancel: {
                label: 'Cancel',
                className: 'btn-danger'
            }
        },
        callback: function (result) {
            if (result) {
                event.preventDefault();
                let _token = $('meta[name="csrf-token"]').attr('content');

                $.ajax({
                    url: "/admin/blog/set_delete",
                    type: "POST",
                    data: {
                        id: id,
                        status: status,
                        _token: _token
                    },
                    success: function (resp) {
                        if (resp.success) {
                            mwz_noti('success', resp.msg);
                            setReloadDataTable();
                        } else {
                            mwz_noti('error', resp.msg);
                            setReloadDataTable();
                        }
                    },
                });
            }
        }
    });
}

setSave = function () {
    event.preventDefault();
    tinyMCE.triggerSave();

    var frm_data = new FormData($('#blog_frm')[0]);

    $.ajax({
        url: "/admin/blog/save",
        type: "POST",
        contentType: false,
        data: frm_data,
        processData: false,
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        success: function (resp) {
            if (resp.success) {
                mwz_noti('success', resp.msg);
                if (resp.code == 200) {
                    window.location.reload();
                } else {
                    JsRedirect('/admin/blog/index', 1500);
                }
            } else {
                mwz_noti('error', resp.msg);
                if (resp.focus) {
                    document.getElementById(resp.focus).focus();
                }
            }
        },
    });

}

// =========================  blog category =========================== //

initCategorydatatable = function () {
    if ($('#blog-categroy-datatable').length > 0) {
        oTable = $('#blog-categroy-datatable').DataTable({
            "processing": true,
            "serverSide": true,
            "stateSave": true,
            "ajax": {
                "url": "/admin/blog/category_datatable_ajax"
            },
            "columns": [
                { "data": "id" },
                { "data": "image", orderable: false, searchable: false },
                { "data": "name_th" },
                { "data": "updated_at" },
                { "data": "action", orderable: false, searchable: false }
            ]
        });
    }
}


setReloadCategoryDataTable = function () {
    $('#blog-categroy-datatable').DataTable().ajax.reload(null, false);
}


setUpdateCategoryStatus = function (category_id, status) {
    event.preventDefault();
    let _token = $('meta[name="csrf-token"]').attr('content');

    $.ajax({
        url: "/admin/blog/set_category_status",
        type: "POST",
        data: {
            category_id: category_id,
            status: status,
            _token: _token
        },
        success: function (resp) {
            if (resp.success) {
                mwz_noti('success', resp.msg);
                setReloadCategoryDataTable();
            } else {
                mwz_noti('error', resp.msg);
                setReloadCategoryDataTable();
            }
        },
    });
}

setSaveCategory = function (frm) {
    event.preventDefault();
    tinyMCE.triggerSave();

    var frm_data = new FormData($('#blog_category_frm')[0]);

    $.ajax({
        url: "/admin/blog/category/save",
        type: "POST",
        contentType: false,
        data: frm_data,
        processData: false,
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        success: function (resp) {
            if (resp.success) {
                mwz_noti('success', resp.msg);
                if (resp.code == 200) {
                    window.location.reload();
                } else {
                    JsRedirect('/admin/blog/category/', 1500);
                }
            } else {
                mwz_noti('error', resp.msg);
                if (resp.focus) {
                    document.getElementById(resp.focus).focus();
                }
            }
        },
    });
}

JsReload = function (time) {
    setInterval(function () {
        window.location.reload();
    }, time);
}

JsRedirect = function (url, time) {
    setInterval(function () {
        window.location.replace(url);
    }, time);
}

DeleteImage = function (id, type) {
    bootbox.confirm({
        message: "ยืนยันการลบ? <br> เมื่อดำเนินการแล้วจะไม่สามารถย้อนกลับได้!",
        buttons: {
            confirm: {
                label: 'ยืนยัน',
                className: 'btn-success'
            },
            cancel: {
                label: 'ยกเลิก',
                className: 'btn-danger'
            }
        },
        callback: function (result) {
            if (result) {
                let _token = $('meta[name="csrf-token"]').attr('content');
                $.ajax({
                    url: "/admin/blog/delete_image",
                    type: "POST",
                    data: {
                        id: id,
                        type: type,
                        _token: _token
                    },
                    success: function (resp) {
                        if (resp.success) {
                            mwz_noti('success', resp.msg);
                            window.location.reload();
                        } else {
                            mwz_noti('error', resp.msg);
                        }
                    },
                });
            }
        }
    });
}