<?php

namespace Modules\Blog\Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

use Modules\Blog\Entities\BlogCategories ;
class BlogDatabaseSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        Model::unguard();

        $now = DB::raw('NOW()');

        DB::statement("ALTER TABLE blog_categories AUTO_INCREMENT=1");
        DB::table('blog_categories')->truncate();
        DB::table('blog_categories')->insert([
            [ 'id'=> 1,
            'name_th' => 'หมวดหมู่ A',
            'name_en' => 'Type A',
            'image'=> 'blog_categories_thai.jpg',
            'description_th'=>'blog category description thai',
            'description_en'=>'blog category description english',
            'status' =>1,
            '_lft' => 1,
            '_rgt' => 2,
            'created_at'=>$now,
            'updated_at'=>$now],

            [ 'id'=> 2,
            'name_th' => 'หมวดหมู่ B',
            'name_en' => 'Type B',
            'image'=> 'blog_categories_thai.jpg',
            'description_th'=>'blog category description thai',
            'description_en'=>'blog category description english',
            'status' =>1,
            '_lft' => 1,
            '_rgt' => 2,
            'created_at'=>$now,
            'updated_at'=>$now],

            [ 'id'=> 3,
            'name_th' => 'หมวดหมู่ C',
            'name_en' => 'Type C',
            'image'=> 'blog_categories_thai.jpg',
            'description_th'=>'blog category description thai',
            'description_en'=>'blog category description english',
            'status' =>1,
            '_lft' => 1,
            '_rgt' => 2,
            'created_at'=>$now,
            'updated_at'=>$now],
        ]);

        DB::statement("ALTER TABLE blogs AUTO_INCREMENT=1");
        DB::table('blogs')->truncate();
        DB::table('blogs')->insert([
            'id'  => 1,
            'category_id'  => 1,
            'name_th' => 'blog name thai',
            'name_en' => 'blog name english',
            'description_th'=>'blog description thai',
            'description_en'=>'blog description english',
            'image'=> 'blog_storage_thai.jpg',
            'link'=> 'https://www.youtube.com/watch?v=AVqAmkGuq60',
            'file'=> '_wellek.pdf',
            'image_youtube'=> 'blog_storage_english.jpg',
            'sequence'=> 1,
            'status' =>1,
            'author' =>1,
            'publish_at'=>$now,
            'created_at'=>$now,
            'updated_at'=>$now
        ]);
    }
}
