<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Kalnoy\Nestedset\NestedSet;

class CreateBlogTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('blog_categories', function (Blueprint $table) {
            $table->id();
            $table->string('name_th', 500);
            $table->string('name_en', 500);
            $table->string('image', 700)->nullable();
            $table->text('description_th');
            $table->text('description_en');
            $table->boolean('status')->default(0);
            NestedSet::columns($table);
            $table->dateTime('created_at');
            $table->dateTime('updated_at');
        });
        Schema::create('blogs', function (Blueprint $table) {
            $table->id();
            $table->boolean('category_id');
            $table->string('name_th', 500);
            $table->string('name_en', 500);
            $table->text('description_th');
            $table->text('description_en');
            $table->string('image', 700)->nullable();
            $table->text('tags')->nullable();
            $table->text('link')->nullable();
            $table->string('file', 700)->nullable();
            $table->string('image_youtube', 700)->nullable();
            $table->tinyInteger('sequence')->comment = 'ลำดับในการแสดงผล';
            $table->boolean('status')->default(0);
            $table->integer('author')->nullable()->comment = 'ผู้เขียน';
            $table->dateTime('publish_at')->comment = 'วันที่กำหนดให้เผยแพร่';
            $table->dateTime('created_at');
            $table->dateTime('updated_at');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('blog_categories');
        Schema::dropIfExists('blogs');
    }
}
