<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::group(['middleware' => 'auth:admin'], function () {
    Route::prefix('admin/banner')->group(function () {
        Route::get('/index', 'BannerAdminController@index')->name('admin.banner.banner.index');
        Route::get('/datatable_ajax', 'BannerAdminController@datatable_ajax')->name('admin.banner.banner.datatable_ajax');

        Route::get('/edit/{category_id}', 'BannerAdminController@form_banner')->name('admin.banner.banner.edit');
        Route::post('/save', 'BannerAdminController@save_banner')->name('admin.banner.banner.save');

        Route::post('/set_status', 'BannerAdminController@set_status')->name('admin.banner.banner.set_status');
        Route::post('/set_delete', 'BannerAdminController@set_delete')->name('admin.banner.banner.set_delete');

        Route::post('/delete_image', 'BannerAdminController@delete_image')->name('admin.banner.banner.delete_image');
    });
});
