$(document).ready(function () {
    // init for banner
    initDatatable();

    //tab inti
    if ($('.first_tab').length > 0) {
        $(".first_tab").champ();
    }

});

// =========================  banner ======================================= //
initDatatable = function () {
    if ($('#banner-datatable').length > 0) {
        oTable = $('#banner-datatable').DataTable({
            "processing": true,
            "serverSide": true,
            "stateSave": true,
            "ajax": {
                "url": "/admin/banner/datatable_ajax"
            },
            "columns": [
                { "data": "sequence" },
                { "data": "image" },
                { "data": "name_th" },
                { "data": "updated_at" },
                { "data": "action", orderable: false, searchable: false }
            ]
        });
    }
}

setReloadDataTable = function () {
    $('#banner-datatable').DataTable().ajax.reload(null, false);
}

setUpdateStatus = function (id, status) {
    event.preventDefault();
    let _token = $('meta[name="csrf-token"]').attr('content');

    $.ajax({
        url: "/admin/banner/set_status",
        type: "POST",
        data: {
            id: id,
            status: status,
            _token: _token
        },
        success: function (resp) {
            if (resp.success) {
                mwz_noti('success', resp.msg);
                setReloadDataTable();
            } else {
                mwz_noti('error', resp.msg);
                setReloadDataTable();
            }
        },
    });
}

setSave = function () {
    event.preventDefault();
    tinyMCE.triggerSave();

    var frm_data = new FormData($('#banner_frm')[0]);

    $.ajax({
        url: "/admin/banner/save",
        type: "POST",
        contentType: false,
        data: frm_data,
        processData: false,
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        beforeSend: function (xhr) {

            if ($("#banner_frm").valid()) {
                return $("#banner_frm").valid();
            } else {
                mwz_noti('error', resp.msg);
                return $("#banner_frm").valid();
            }
        },
        success: function (resp) {
            if (resp.success) {
                mwz_noti('success', resp.msg);
                if (resp.code == 200) {
                    JsReload(1500);
                } else {
                    JsRedirect('/admin/banner/index', 1500);
                }
            } else {
                mwz_noti('error', resp.msg);
            }
        },
    });
}

JsReload = function (time) {
    setInterval(function () {
        window.location.reload();
    }, time);
}

JsRedirect = function (url, time) {
    setInterval(function () {
        window.location.replace(url);
    }, time);
}

DeleteImage = function (id) {
    bootbox.confirm({
        message: "ยืนยันการลบ? <br> เมื่อดำเนินการแล้วจะไม่สามารถย้อนกลับได้!",
        buttons: {
            confirm: {
                label: 'ยืนยัน',
                className: 'btn-success'
            },
            cancel: {
                label: 'ยกเลิก',
                className: 'btn-danger'
            }
        },
        callback: function (result) {
            if (result) {
                let _token = $('meta[name="csrf-token"]').attr('content');
                $.ajax({
                    url: "/admin/banner/delete_image",
                    type: "POST",
                    data: {
                        id: id,
                        _token: _token
                    },
                    success: function (resp) {
                        if (resp.success) {
                            mwz_noti('success', resp.msg);
                            JsReload(1000);
                        } else {
                            mwz_noti('error', resp.msg);
                        }
                    },
                });
            }
        }
    });
}